@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin

import com.pulumi.alicloud.wafv3.Wafv3Functions.getDomainsPlain
import com.pulumi.alicloud.wafv3.Wafv3Functions.getInstancesPlain
import com.pulumi.alicloud.wafv3.kotlin.inputs.GetDomainsPlainArgs
import com.pulumi.alicloud.wafv3.kotlin.inputs.GetDomainsPlainArgsBuilder
import com.pulumi.alicloud.wafv3.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.alicloud.wafv3.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsResult
import com.pulumi.alicloud.wafv3.kotlin.outputs.GetInstancesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsResult.Companion.toKotlin as getDomainsResultToKotlin
import com.pulumi.alicloud.wafv3.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin

public object Wafv3Functions {
    /**
     * This data source provides the Wafv3 Domains of the current Alibaba Cloud user.
     * > **NOTE:** Available since v1.200.0.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.wafv3.getInstances({});
     * const ids = _default.then(_default => alicloud.wafv3.getDomains({
     *     instanceId: _default.ids?.[0],
     *     ids: ["example_id"],
     * }));
     * export const wafv3DomainsId1 = ids.then(ids => ids.domains?.[0]?.id);
     * const defaultGetDomains = _default.then(_default => alicloud.wafv3.getDomains({
     *     instanceId: _default.ids?.[0],
     *     domain: "zctest12.wafqax.top",
     * }));
     * export const wafv3DomainsId2 = defaultGetDomains.then(defaultGetDomains => defaultGetDomains.domains?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.wafv3.get_instances()
     * ids = alicloud.wafv3.get_domains(instance_id=default.ids[0],
     *     ids=["example_id"])
     * pulumi.export("wafv3DomainsId1", ids.domains[0].id)
     * default_get_domains = alicloud.wafv3.get_domains(instance_id=default.ids[0],
     *     domain="zctest12.wafqax.top")
     * pulumi.export("wafv3DomainsId2", default_get_domains.domains[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Wafv3.GetInstances.Invoke();
     *     var ids = AliCloud.Wafv3.GetDomains.Invoke(new()
     *     {
     *         InstanceId = @default.Apply(getInstancesResult => getInstancesResult.Ids[0]),
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     var defaultGetDomains = AliCloud.Wafv3.GetDomains.Invoke(new()
     *     {
     *         InstanceId = @default.Apply(getInstancesResult => getInstancesResult.Ids[0]),
     *         Domain = "zctest12.wafqax.top",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["wafv3DomainsId1"] = ids&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.Id),
     *         ["wafv3DomainsId2"] = defaultGetDomains&#46;Apply(getDomainsResult => getDomainsResult&#46;Domains[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/wafv3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := wafv3.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ids, err := wafv3.GetDomains(ctx, &wafv3.GetDomainsArgs{
     * 			InstanceId: _default.Ids[0],
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("wafv3DomainsId1", ids.Domains[0].Id)
     * 		defaultGetDomains, err := wafv3.GetDomains(ctx, &wafv3.GetDomainsArgs{
     * 			InstanceId: _default.Ids[0],
     * 			Domain:     pulumi.StringRef("zctest12.wafqax.top"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("wafv3DomainsId2", defaultGetDomains.Domains[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.wafv3.Wafv3Functions;
     * import com.pulumi.alicloud.wafv3.inputs.GetInstancesArgs;
     * import com.pulumi.alicloud.wafv3.inputs.GetDomainsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Wafv3Functions.getInstances();
     *         final var ids = Wafv3Functions.getDomains(GetDomainsArgs.builder()
     *             .instanceId(default_.ids()[0])
     *             .ids("example_id")
     *             .build());
     *         ctx.export("wafv3DomainsId1", ids.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id()));
     *         final var defaultGetDomains = Wafv3Functions.getDomains(GetDomainsArgs.builder()
     *             .instanceId(default_.ids()[0])
     *             .domain("zctest12.wafqax.top")
     *             .build());
     *         ctx.export("wafv3DomainsId2", defaultGetDomains.applyValue(getDomainsResult -> getDomainsResult.domains()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:wafv3:getInstances
     *       Arguments: {}
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:wafv3:getDomains
     *       Arguments:
     *         instanceId: ${default.ids[0]}
     *         ids:
     *           - example_id
     *   defaultGetDomains:
     *     fn::invoke:
     *       Function: alicloud:wafv3:getDomains
     *       Arguments:
     *         instanceId: ${default.ids[0]}
     *         domain: zctest12.wafqax.top
     * outputs:
     *   wafv3DomainsId1: ${ids.domains[0].id}
     *   wafv3DomainsId2: ${defaultGetDomains.domains[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDomains.
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: GetDomainsPlainArgs): GetDomainsResult =
        getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())

    /**
     * @see [getDomains].
     * @param backend The address type of the origin server. The address can be an IP address or a domain name. You can specify only one type of address.
     * @param domain The name of the domain name to query.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param ids A list of domain IDs.
     * @param instanceId The WAF instance ID.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(
        backend: String? = null,
        domain: String? = null,
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        instanceId: String,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetDomainsResult {
        val argument = GetDomainsPlainArgs(
            backend = backend,
            domain = domain,
            enableDetails = enableDetails,
            ids = ids,
            instanceId = instanceId,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getDomainsResultToKotlin(getDomainsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDomains].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;wafv3&#46;kotlin&#46;inputs&#46;GetDomainsPlainArgs].
     * @return A collection of values returned by getDomains.
     */
    public suspend fun getDomains(argument: suspend GetDomainsPlainArgsBuilder.() -> Unit): GetDomainsResult {
        val builder = GetDomainsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDomainsResultToKotlin(getDomainsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides Wafv3 Instance available to the user.[What is Instance](https://www.alibabacloud.com/help/en/web-application-firewall/latest/what-is-waf)
     * > **NOTE:** Available in 1.200.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.wafv3.getInstances({});
     * export const alicloudWafv3InstanceExampleId = _default.then(_default => _default.instances?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.wafv3.get_instances()
     * pulumi.export("alicloudWafv3InstanceExampleId", default.instances[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Wafv3.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["alicloudWafv3InstanceExampleId"] = @default&#46;Apply(@default => @default&#46;Apply(getInstancesResult => getInstancesResult&#46;Instances[0]?.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/wafv3"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := wafv3.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("alicloudWafv3InstanceExampleId", _default.Instances[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.wafv3.Wafv3Functions;
     * import com.pulumi.alicloud.wafv3.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Wafv3Functions.getInstances();
     *         ctx.export("alicloudWafv3InstanceExampleId", default_.instances()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:wafv3:getInstances
     *       Arguments: {}
     * outputs:
     *   alicloudWafv3InstanceExampleId: ${default.instances[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(outputFile: String? = null): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            outputFile = outputFile,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;wafv3&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }
}
