@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.inputs

import com.pulumi.alicloud.wafv3.inputs.DomainListenArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certId The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property cipherSuite The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **1**: indicates that all encryption suites are added.
 * - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
 * - **99**: indicates that a custom encryption suite is added.
 * @property customCiphers The specific custom encryption suite to add.
 * @property enableTlsv3 Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that TSL1.3 is supported.
 * - **false**: indicates that TSL1.3 is not supported.
 * @property exclusiveIp Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
 * - **true**: indicates that the exclusive IP address is enabled.
 * - **false** (default): indicates that exclusive IP address is not enabled.
 * @property focusHttps Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
 * - **true**: indicates that HTTPS forced redirection is enabled.
 * - **false**: indicates that HTTPS forced redirection is not enabled.
 * @property http2Enabled Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true:** indicates that HTTP2 is enabled.
 * - **false** (default): indicates that HTTP2 is not enabled.
 * @property httpPorts The listening port of the HTTP protocol.
 * @property httpsPorts The listening port of the HTTPS protocol.
 * @property ipv6Enabled Whether IPv6 is turned on. Value:
 * - **true**: indicates that IPv6 is enabled.
 * - **false** (default): indicates that IPv6 is not enabled.
 * @property protectionResource The type of protection resource to use. Value:
 * - **share** (default): indicates that a shared cluster is used.
 * - **gslb**: indicates that the shared cluster intelligent load balancing is used.
 * @property tlsVersion The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
 * @property xffHeaderMode WAF obtains the real IP address of the client. Value:
 * - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
 * - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
 * - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
 * @property xffHeaders Set the list of custom fields used to obtain the client IP address.
 */
public data class DomainListenArgs(
    public val certId: Output<String>? = null,
    public val cipherSuite: Output<Int>? = null,
    public val customCiphers: Output<List<String>>? = null,
    public val enableTlsv3: Output<Boolean>? = null,
    public val exclusiveIp: Output<Boolean>? = null,
    public val focusHttps: Output<Boolean>? = null,
    public val http2Enabled: Output<Boolean>? = null,
    public val httpPorts: Output<List<Int>>? = null,
    public val httpsPorts: Output<List<Int>>? = null,
    public val ipv6Enabled: Output<Boolean>? = null,
    public val protectionResource: Output<String>? = null,
    public val tlsVersion: Output<String>? = null,
    public val xffHeaderMode: Output<Int>? = null,
    public val xffHeaders: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.wafv3.inputs.DomainListenArgs> {
    override fun toJava(): com.pulumi.alicloud.wafv3.inputs.DomainListenArgs =
        com.pulumi.alicloud.wafv3.inputs.DomainListenArgs.builder()
            .certId(certId?.applyValue({ args0 -> args0 }))
            .cipherSuite(cipherSuite?.applyValue({ args0 -> args0 }))
            .customCiphers(customCiphers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enableTlsv3(enableTlsv3?.applyValue({ args0 -> args0 }))
            .exclusiveIp(exclusiveIp?.applyValue({ args0 -> args0 }))
            .focusHttps(focusHttps?.applyValue({ args0 -> args0 }))
            .http2Enabled(http2Enabled?.applyValue({ args0 -> args0 }))
            .httpPorts(httpPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .httpsPorts(httpsPorts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipv6Enabled(ipv6Enabled?.applyValue({ args0 -> args0 }))
            .protectionResource(protectionResource?.applyValue({ args0 -> args0 }))
            .tlsVersion(tlsVersion?.applyValue({ args0 -> args0 }))
            .xffHeaderMode(xffHeaderMode?.applyValue({ args0 -> args0 }))
            .xffHeaders(xffHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainListenArgs].
 */
@PulumiTagMarker
public class DomainListenArgsBuilder internal constructor() {
    private var certId: Output<String>? = null

    private var cipherSuite: Output<Int>? = null

    private var customCiphers: Output<List<String>>? = null

    private var enableTlsv3: Output<Boolean>? = null

    private var exclusiveIp: Output<Boolean>? = null

    private var focusHttps: Output<Boolean>? = null

    private var http2Enabled: Output<Boolean>? = null

    private var httpPorts: Output<List<Int>>? = null

    private var httpsPorts: Output<List<Int>>? = null

    private var ipv6Enabled: Output<Boolean>? = null

    private var protectionResource: Output<String>? = null

    private var tlsVersion: Output<String>? = null

    private var xffHeaderMode: Output<Int>? = null

    private var xffHeaders: Output<List<String>>? = null

    /**
     * @param value The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
     */
    @JvmName("tphjvgxbmvyimhrb")
    public suspend fun certId(`value`: Output<String>) {
        this.certId = value
    }

    /**
     * @param value The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **1**: indicates that all encryption suites are added.
     * - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
     * - **99**: indicates that a custom encryption suite is added.
     */
    @JvmName("fvexafrtqtqfrtar")
    public suspend fun cipherSuite(`value`: Output<Int>) {
        this.cipherSuite = value
    }

    /**
     * @param value The specific custom encryption suite to add.
     */
    @JvmName("ahaofnwekrbeemqi")
    public suspend fun customCiphers(`value`: Output<List<String>>) {
        this.customCiphers = value
    }

    @JvmName("lcqpkiebjcqybeqr")
    public suspend fun customCiphers(vararg values: Output<String>) {
        this.customCiphers = Output.all(values.asList())
    }

    /**
     * @param values The specific custom encryption suite to add.
     */
    @JvmName("gkkpiydjybjreakb")
    public suspend fun customCiphers(values: List<Output<String>>) {
        this.customCiphers = Output.all(values)
    }

    /**
     * @param value Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that TSL1.3 is supported.
     * - **false**: indicates that TSL1.3 is not supported.
     */
    @JvmName("yldtaoafpbnaqxnh")
    public suspend fun enableTlsv3(`value`: Output<Boolean>) {
        this.enableTlsv3 = value
    }

    /**
     * @param value Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
     * - **true**: indicates that the exclusive IP address is enabled.
     * - **false** (default): indicates that exclusive IP address is not enabled.
     */
    @JvmName("cajdghdkbxtucnei")
    public suspend fun exclusiveIp(`value`: Output<Boolean>) {
        this.exclusiveIp = value
    }

    /**
     * @param value Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
     * - **true**: indicates that HTTPS forced redirection is enabled.
     * - **false**: indicates that HTTPS forced redirection is not enabled.
     */
    @JvmName("oltdlotdahbheqjj")
    public suspend fun focusHttps(`value`: Output<Boolean>) {
        this.focusHttps = value
    }

    /**
     * @param value Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true:** indicates that HTTP2 is enabled.
     * - **false** (default): indicates that HTTP2 is not enabled.
     */
    @JvmName("wgopulycjksocumd")
    public suspend fun http2Enabled(`value`: Output<Boolean>) {
        this.http2Enabled = value
    }

    /**
     * @param value The listening port of the HTTP protocol.
     */
    @JvmName("yqhebkgtwclskcjx")
    public suspend fun httpPorts(`value`: Output<List<Int>>) {
        this.httpPorts = value
    }

    @JvmName("giwpnmypcgknosea")
    public suspend fun httpPorts(vararg values: Output<Int>) {
        this.httpPorts = Output.all(values.asList())
    }

    /**
     * @param values The listening port of the HTTP protocol.
     */
    @JvmName("jekmjrufthcbiiyy")
    public suspend fun httpPorts(values: List<Output<Int>>) {
        this.httpPorts = Output.all(values)
    }

    /**
     * @param value The listening port of the HTTPS protocol.
     */
    @JvmName("pnlxrejkfgytjjnr")
    public suspend fun httpsPorts(`value`: Output<List<Int>>) {
        this.httpsPorts = value
    }

    @JvmName("rniebpmvjkpgdpjm")
    public suspend fun httpsPorts(vararg values: Output<Int>) {
        this.httpsPorts = Output.all(values.asList())
    }

    /**
     * @param values The listening port of the HTTPS protocol.
     */
    @JvmName("wshskoqqcagybjal")
    public suspend fun httpsPorts(values: List<Output<Int>>) {
        this.httpsPorts = Output.all(values)
    }

    /**
     * @param value Whether IPv6 is turned on. Value:
     * - **true**: indicates that IPv6 is enabled.
     * - **false** (default): indicates that IPv6 is not enabled.
     */
    @JvmName("uyuromdwvnhuvsgw")
    public suspend fun ipv6Enabled(`value`: Output<Boolean>) {
        this.ipv6Enabled = value
    }

    /**
     * @param value The type of protection resource to use. Value:
     * - **share** (default): indicates that a shared cluster is used.
     * - **gslb**: indicates that the shared cluster intelligent load balancing is used.
     */
    @JvmName("vxdvksuhiuibaqey")
    public suspend fun protectionResource(`value`: Output<String>) {
        this.protectionResource = value
    }

    /**
     * @param value The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
     */
    @JvmName("nuoojalsyrgtaqua")
    public suspend fun tlsVersion(`value`: Output<String>) {
        this.tlsVersion = value
    }

    /**
     * @param value WAF obtains the real IP address of the client. Value:
     * - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
     * - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
     * - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
     */
    @JvmName("wdbjkrmycxkjkwjj")
    public suspend fun xffHeaderMode(`value`: Output<Int>) {
        this.xffHeaderMode = value
    }

    /**
     * @param value Set the list of custom fields used to obtain the client IP address.
     */
    @JvmName("warphhbubayposoj")
    public suspend fun xffHeaders(`value`: Output<List<String>>) {
        this.xffHeaders = value
    }

    @JvmName("xphgqqpkvypdedbc")
    public suspend fun xffHeaders(vararg values: Output<String>) {
        this.xffHeaders = Output.all(values.asList())
    }

    /**
     * @param values Set the list of custom fields used to obtain the client IP address.
     */
    @JvmName("xvidhhbmquxgjlfj")
    public suspend fun xffHeaders(values: List<Output<String>>) {
        this.xffHeaders = Output.all(values)
    }

    /**
     * @param value The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
     */
    @JvmName("ykurmomesafnkomn")
    public suspend fun certId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certId = mapped
    }

    /**
     * @param value The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **1**: indicates that all encryption suites are added.
     * - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
     * - **99**: indicates that a custom encryption suite is added.
     */
    @JvmName("mxqitnqrqtfyqngl")
    public suspend fun cipherSuite(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipherSuite = mapped
    }

    /**
     * @param value The specific custom encryption suite to add.
     */
    @JvmName("ntstejtrlfhrrvgi")
    public suspend fun customCiphers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customCiphers = mapped
    }

    /**
     * @param values The specific custom encryption suite to add.
     */
    @JvmName("drjmuksbcrtrrymf")
    public suspend fun customCiphers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customCiphers = mapped
    }

    /**
     * @param value Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that TSL1.3 is supported.
     * - **false**: indicates that TSL1.3 is not supported.
     */
    @JvmName("bwqqlquxqfncxlgs")
    public suspend fun enableTlsv3(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTlsv3 = mapped
    }

    /**
     * @param value Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
     * - **true**: indicates that the exclusive IP address is enabled.
     * - **false** (default): indicates that exclusive IP address is not enabled.
     */
    @JvmName("fwvgmdsokokexmml")
    public suspend fun exclusiveIp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveIp = mapped
    }

    /**
     * @param value Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
     * - **true**: indicates that HTTPS forced redirection is enabled.
     * - **false**: indicates that HTTPS forced redirection is not enabled.
     */
    @JvmName("bpwnilinrkbhboeq")
    public suspend fun focusHttps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.focusHttps = mapped
    }

    /**
     * @param value Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true:** indicates that HTTP2 is enabled.
     * - **false** (default): indicates that HTTP2 is not enabled.
     */
    @JvmName("rafoohjhmosjonvg")
    public suspend fun http2Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http2Enabled = mapped
    }

    /**
     * @param value The listening port of the HTTP protocol.
     */
    @JvmName("tdbqkrmkdllijeic")
    public suspend fun httpPorts(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPorts = mapped
    }

    /**
     * @param values The listening port of the HTTP protocol.
     */
    @JvmName("ufemhjdrlxewskxs")
    public suspend fun httpPorts(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpPorts = mapped
    }

    /**
     * @param value The listening port of the HTTPS protocol.
     */
    @JvmName("vgqujgnwwfllijkq")
    public suspend fun httpsPorts(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPorts = mapped
    }

    /**
     * @param values The listening port of the HTTPS protocol.
     */
    @JvmName("qjjxjlhxluwmonfo")
    public suspend fun httpsPorts(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsPorts = mapped
    }

    /**
     * @param value Whether IPv6 is turned on. Value:
     * - **true**: indicates that IPv6 is enabled.
     * - **false** (default): indicates that IPv6 is not enabled.
     */
    @JvmName("asgdwxtpnrayqugw")
    public suspend fun ipv6Enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Enabled = mapped
    }

    /**
     * @param value The type of protection resource to use. Value:
     * - **share** (default): indicates that a shared cluster is used.
     * - **gslb**: indicates that the shared cluster intelligent load balancing is used.
     */
    @JvmName("eliagqhbfoptmuuc")
    public suspend fun protectionResource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionResource = mapped
    }

    /**
     * @param value The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
     */
    @JvmName("cabmwwpygesssiok")
    public suspend fun tlsVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsVersion = mapped
    }

    /**
     * @param value WAF obtains the real IP address of the client. Value:
     * - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
     * - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
     * - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
     */
    @JvmName("ctxigtousxxexesu")
    public suspend fun xffHeaderMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xffHeaderMode = mapped
    }

    /**
     * @param value Set the list of custom fields used to obtain the client IP address.
     */
    @JvmName("gxsrfctdichfrsxn")
    public suspend fun xffHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xffHeaders = mapped
    }

    /**
     * @param values Set the list of custom fields used to obtain the client IP address.
     */
    @JvmName("dbrwbrgyguwlublf")
    public suspend fun xffHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.xffHeaders = mapped
    }

    internal fun build(): DomainListenArgs = DomainListenArgs(
        certId = certId,
        cipherSuite = cipherSuite,
        customCiphers = customCiphers,
        enableTlsv3 = enableTlsv3,
        exclusiveIp = exclusiveIp,
        focusHttps = focusHttps,
        http2Enabled = http2Enabled,
        httpPorts = httpPorts,
        httpsPorts = httpsPorts,
        ipv6Enabled = ipv6Enabled,
        protectionResource = protectionResource,
        tlsVersion = tlsVersion,
        xffHeaderMode = xffHeaderMode,
        xffHeaders = xffHeaders,
    )
}
