@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.inputs

import com.pulumi.alicloud.wafv3.inputs.DomainRedirectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property backends The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
 * @property connectTimeout Connection timeout. Unit: seconds, value range: 5~120.
 * @property focusHttpBackend Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that forced HTTP back-to-origin is enabled.
 * - **false**: indicates that forced HTTP back-to-origin is not enabled.
 * @property keepalive Open long connection, default true.
 * @property keepaliveRequests Number of long connections,  default: `60`. range :60-1000.
 * @property keepaliveTimeout Long connection over time, default: `15`. Range: 1-60.
 * @property loadbalance The load balancing algorithm used when returning to the source. Value:
 * - **iphash**: indicates the IPHash algorithm.
 * - **roundRobin**: indicates the polling algorithm.
 * - **leastTime**: indicates the Least Time algorithm.
 * - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
 * @property readTimeout Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
 * @property requestHeaders The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
 * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
 * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
 * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
 * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
 * custom header field already exists in the request, the system will overwrite the value of the custom field in the
 * request with the set traffic tag value. See `request_headers` below.
 * @property retry Back to Source Retry. default: true, retry 3 times by default.
 * @property sniEnabled Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that the back-to-source SNI is enabled.
 * - **false** (default) indicates that the back-to-source SNI is not enabled.
 * @property sniHost Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
 * @property writeTimeout Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
 */
public data class DomainRedirectArgs(
    public val backends: Output<List<String>>? = null,
    public val connectTimeout: Output<Int>? = null,
    public val focusHttpBackend: Output<Boolean>? = null,
    public val keepalive: Output<Boolean>? = null,
    public val keepaliveRequests: Output<Int>? = null,
    public val keepaliveTimeout: Output<Int>? = null,
    public val loadbalance: Output<String>,
    public val readTimeout: Output<Int>? = null,
    public val requestHeaders: Output<List<DomainRedirectRequestHeaderArgs>>? = null,
    public val retry: Output<Boolean>? = null,
    public val sniEnabled: Output<Boolean>? = null,
    public val sniHost: Output<String>? = null,
    public val writeTimeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.wafv3.inputs.DomainRedirectArgs> {
    override fun toJava(): com.pulumi.alicloud.wafv3.inputs.DomainRedirectArgs =
        com.pulumi.alicloud.wafv3.inputs.DomainRedirectArgs.builder()
            .backends(backends?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectTimeout(connectTimeout?.applyValue({ args0 -> args0 }))
            .focusHttpBackend(focusHttpBackend?.applyValue({ args0 -> args0 }))
            .keepalive(keepalive?.applyValue({ args0 -> args0 }))
            .keepaliveRequests(keepaliveRequests?.applyValue({ args0 -> args0 }))
            .keepaliveTimeout(keepaliveTimeout?.applyValue({ args0 -> args0 }))
            .loadbalance(loadbalance.applyValue({ args0 -> args0 }))
            .readTimeout(readTimeout?.applyValue({ args0 -> args0 }))
            .requestHeaders(
                requestHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .retry(retry?.applyValue({ args0 -> args0 }))
            .sniEnabled(sniEnabled?.applyValue({ args0 -> args0 }))
            .sniHost(sniHost?.applyValue({ args0 -> args0 }))
            .writeTimeout(writeTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainRedirectArgs].
 */
@PulumiTagMarker
public class DomainRedirectArgsBuilder internal constructor() {
    private var backends: Output<List<String>>? = null

    private var connectTimeout: Output<Int>? = null

    private var focusHttpBackend: Output<Boolean>? = null

    private var keepalive: Output<Boolean>? = null

    private var keepaliveRequests: Output<Int>? = null

    private var keepaliveTimeout: Output<Int>? = null

    private var loadbalance: Output<String>? = null

    private var readTimeout: Output<Int>? = null

    private var requestHeaders: Output<List<DomainRedirectRequestHeaderArgs>>? = null

    private var retry: Output<Boolean>? = null

    private var sniEnabled: Output<Boolean>? = null

    private var sniHost: Output<String>? = null

    private var writeTimeout: Output<Int>? = null

    /**
     * @param value The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
     */
    @JvmName("xdibphxnnkfnjrbi")
    public suspend fun backends(`value`: Output<List<String>>) {
        this.backends = value
    }

    @JvmName("xcqhsktsambcqsdi")
    public suspend fun backends(vararg values: Output<String>) {
        this.backends = Output.all(values.asList())
    }

    /**
     * @param values The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
     */
    @JvmName("prsgiftbwdwprfjh")
    public suspend fun backends(values: List<Output<String>>) {
        this.backends = Output.all(values)
    }

    /**
     * @param value Connection timeout. Unit: seconds, value range: 5~120.
     */
    @JvmName("lysmlkafoiugardg")
    public suspend fun connectTimeout(`value`: Output<Int>) {
        this.connectTimeout = value
    }

    /**
     * @param value Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that forced HTTP back-to-origin is enabled.
     * - **false**: indicates that forced HTTP back-to-origin is not enabled.
     */
    @JvmName("lipbbqlhkwsvkidf")
    public suspend fun focusHttpBackend(`value`: Output<Boolean>) {
        this.focusHttpBackend = value
    }

    /**
     * @param value Open long connection, default true.
     */
    @JvmName("dxlkknodjxlkrkip")
    public suspend fun keepalive(`value`: Output<Boolean>) {
        this.keepalive = value
    }

    /**
     * @param value Number of long connections,  default: `60`. range :60-1000.
     */
    @JvmName("ljxeuarqpigwyciu")
    public suspend fun keepaliveRequests(`value`: Output<Int>) {
        this.keepaliveRequests = value
    }

    /**
     * @param value Long connection over time, default: `15`. Range: 1-60.
     */
    @JvmName("ybhcwmrlvwmclwcv")
    public suspend fun keepaliveTimeout(`value`: Output<Int>) {
        this.keepaliveTimeout = value
    }

    /**
     * @param value The load balancing algorithm used when returning to the source. Value:
     * - **iphash**: indicates the IPHash algorithm.
     * - **roundRobin**: indicates the polling algorithm.
     * - **leastTime**: indicates the Least Time algorithm.
     * - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
     */
    @JvmName("viuuslrwtfjfksll")
    public suspend fun loadbalance(`value`: Output<String>) {
        this.loadbalance = value
    }

    /**
     * @param value Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
     */
    @JvmName("ydbvvkqgasdmlcni")
    public suspend fun readTimeout(`value`: Output<Int>) {
        this.readTimeout = value
    }

    /**
     * @param value The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("sdvkapiirrltngqj")
    public suspend fun requestHeaders(`value`: Output<List<DomainRedirectRequestHeaderArgs>>) {
        this.requestHeaders = value
    }

    @JvmName("yhhbqsjjcwdjcghx")
    public suspend fun requestHeaders(vararg values: Output<DomainRedirectRequestHeaderArgs>) {
        this.requestHeaders = Output.all(values.asList())
    }

    /**
     * @param values The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("tempisjvpbfnwrtu")
    public suspend fun requestHeaders(values: List<Output<DomainRedirectRequestHeaderArgs>>) {
        this.requestHeaders = Output.all(values)
    }

    /**
     * @param value Back to Source Retry. default: true, retry 3 times by default.
     */
    @JvmName("lyfppsbaeqqlqdwq")
    public suspend fun retry(`value`: Output<Boolean>) {
        this.retry = value
    }

    /**
     * @param value Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that the back-to-source SNI is enabled.
     * - **false** (default) indicates that the back-to-source SNI is not enabled.
     */
    @JvmName("gudabrfleluitlpe")
    public suspend fun sniEnabled(`value`: Output<Boolean>) {
        this.sniEnabled = value
    }

    /**
     * @param value Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
     */
    @JvmName("ljnfjvhnbeacgojr")
    public suspend fun sniHost(`value`: Output<String>) {
        this.sniHost = value
    }

    /**
     * @param value Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
     */
    @JvmName("rjqkphbihmlabjhu")
    public suspend fun writeTimeout(`value`: Output<Int>) {
        this.writeTimeout = value
    }

    /**
     * @param value The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
     */
    @JvmName("cbgupgehmlcoqbye")
    public suspend fun backends(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param values The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
     */
    @JvmName("awrahlcrattxvgxn")
    public suspend fun backends(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backends = mapped
    }

    /**
     * @param value Connection timeout. Unit: seconds, value range: 5~120.
     */
    @JvmName("oxrvggcympjwqxbv")
    public suspend fun connectTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectTimeout = mapped
    }

    /**
     * @param value Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that forced HTTP back-to-origin is enabled.
     * - **false**: indicates that forced HTTP back-to-origin is not enabled.
     */
    @JvmName("qlefntlpbnqsjqtj")
    public suspend fun focusHttpBackend(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.focusHttpBackend = mapped
    }

    /**
     * @param value Open long connection, default true.
     */
    @JvmName("llpqckwdujlsjdna")
    public suspend fun keepalive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepalive = mapped
    }

    /**
     * @param value Number of long connections,  default: `60`. range :60-1000.
     */
    @JvmName("mehotmjxdefyfncl")
    public suspend fun keepaliveRequests(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepaliveRequests = mapped
    }

    /**
     * @param value Long connection over time, default: `15`. Range: 1-60.
     */
    @JvmName("gfywnayxfvqevwqr")
    public suspend fun keepaliveTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepaliveTimeout = mapped
    }

    /**
     * @param value The load balancing algorithm used when returning to the source. Value:
     * - **iphash**: indicates the IPHash algorithm.
     * - **roundRobin**: indicates the polling algorithm.
     * - **leastTime**: indicates the Least Time algorithm.
     * - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
     */
    @JvmName("jtidhqciktukfscr")
    public suspend fun loadbalance(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadbalance = mapped
    }

    /**
     * @param value Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
     */
    @JvmName("kndpkeeeerrjkram")
    public suspend fun readTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readTimeout = mapped
    }

    /**
     * @param value The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("xljkwmbrsnmltmhe")
    public suspend fun requestHeaders(`value`: List<DomainRedirectRequestHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param argument The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("dvsqldhtsamkfhlw")
    public suspend fun requestHeaders(argument: List<suspend DomainRedirectRequestHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainRedirectRequestHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param argument The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("ndrvyxenlqsksxsm")
    public suspend fun requestHeaders(vararg argument: suspend DomainRedirectRequestHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainRedirectRequestHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param argument The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("wtafmpupmvabxodx")
    public suspend fun requestHeaders(argument: suspend DomainRedirectRequestHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainRedirectRequestHeaderArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param values The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
     * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
     * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
     * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
     * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
     * custom header field already exists in the request, the system will overwrite the value of the custom field in the
     * request with the set traffic tag value. See `request_headers` below.
     */
    @JvmName("vmkswxpobmogglex")
    public suspend fun requestHeaders(vararg values: DomainRedirectRequestHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param value Back to Source Retry. default: true, retry 3 times by default.
     */
    @JvmName("jagsufwouppsrhdy")
    public suspend fun retry(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retry = mapped
    }

    /**
     * @param value Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
     * - **true**: indicates that the back-to-source SNI is enabled.
     * - **false** (default) indicates that the back-to-source SNI is not enabled.
     */
    @JvmName("cjomptvtdpeoktdi")
    public suspend fun sniEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sniEnabled = mapped
    }

    /**
     * @param value Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
     */
    @JvmName("ucdkueolxytwnptk")
    public suspend fun sniHost(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sniHost = mapped
    }

    /**
     * @param value Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
     */
    @JvmName("bhhhwbcwwovpvjte")
    public suspend fun writeTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeTimeout = mapped
    }

    internal fun build(): DomainRedirectArgs = DomainRedirectArgs(
        backends = backends,
        connectTimeout = connectTimeout,
        focusHttpBackend = focusHttpBackend,
        keepalive = keepalive,
        keepaliveRequests = keepaliveRequests,
        keepaliveTimeout = keepaliveTimeout,
        loadbalance = loadbalance ?: throw PulumiNullFieldException("loadbalance"),
        readTimeout = readTimeout,
        requestHeaders = requestHeaders,
        retry = retry,
        sniEnabled = sniEnabled,
        sniHost = sniHost,
        writeTimeout = writeTimeout,
    )
}
