@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.inputs

import com.pulumi.alicloud.wafv3.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetInstancesPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.wafv3.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.wafv3.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.wafv3.inputs.GetInstancesPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ccriwrlrvagarxsj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        outputFile = outputFile,
    )
}
