@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certId The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property cipherSuite The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **1**: indicates that all encryption suites are added.
 * - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
 * - **99**: indicates that a custom encryption suite is added.
 * @property customCiphers The specific custom encryption suite to add.
 * @property enableTlsv3 Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that TSL1.3 is supported.
 * - **false**: indicates that TSL1.3 is not supported.
 * @property exclusiveIp Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
 * - **true**: indicates that the exclusive IP address is enabled.
 * - **false** (default): indicates that exclusive IP address is not enabled.
 * @property focusHttps Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
 * - **true**: indicates that HTTPS forced redirection is enabled.
 * - **false**: indicates that HTTPS forced redirection is not enabled.
 * @property http2Enabled Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true:** indicates that HTTP2 is enabled.
 * - **false** (default): indicates that HTTP2 is not enabled.
 * @property httpPorts The listening port of the HTTP protocol.
 * @property httpsPorts The listening port of the HTTPS protocol.
 * @property ipv6Enabled Whether IPv6 is turned on. Value:
 * - **true**: indicates that IPv6 is enabled.
 * - **false** (default): indicates that IPv6 is not enabled.
 * @property protectionResource The type of protection resource to use. Value:
 * - **share** (default): indicates that a shared cluster is used.
 * - **gslb**: indicates that the shared cluster intelligent load balancing is used.
 * @property tlsVersion The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
 * @property xffHeaderMode WAF obtains the real IP address of the client. Value:
 * - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
 * - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
 * - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
 * @property xffHeaders Set the list of custom fields used to obtain the client IP address.
 */
public data class DomainListen(
    public val certId: String? = null,
    public val cipherSuite: Int? = null,
    public val customCiphers: List<String>? = null,
    public val enableTlsv3: Boolean? = null,
    public val exclusiveIp: Boolean? = null,
    public val focusHttps: Boolean? = null,
    public val http2Enabled: Boolean? = null,
    public val httpPorts: List<Int>? = null,
    public val httpsPorts: List<Int>? = null,
    public val ipv6Enabled: Boolean? = null,
    public val protectionResource: String? = null,
    public val tlsVersion: String? = null,
    public val xffHeaderMode: Int? = null,
    public val xffHeaders: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.DomainListen): DomainListen =
            DomainListen(
                certId = javaType.certId().map({ args0 -> args0 }).orElse(null),
                cipherSuite = javaType.cipherSuite().map({ args0 -> args0 }).orElse(null),
                customCiphers = javaType.customCiphers().map({ args0 -> args0 }),
                enableTlsv3 = javaType.enableTlsv3().map({ args0 -> args0 }).orElse(null),
                exclusiveIp = javaType.exclusiveIp().map({ args0 -> args0 }).orElse(null),
                focusHttps = javaType.focusHttps().map({ args0 -> args0 }).orElse(null),
                http2Enabled = javaType.http2Enabled().map({ args0 -> args0 }).orElse(null),
                httpPorts = javaType.httpPorts().map({ args0 -> args0 }),
                httpsPorts = javaType.httpsPorts().map({ args0 -> args0 }),
                ipv6Enabled = javaType.ipv6Enabled().map({ args0 -> args0 }).orElse(null),
                protectionResource = javaType.protectionResource().map({ args0 -> args0 }).orElse(null),
                tlsVersion = javaType.tlsVersion().map({ args0 -> args0 }).orElse(null),
                xffHeaderMode = javaType.xffHeaderMode().map({ args0 -> args0 }).orElse(null),
                xffHeaders = javaType.xffHeaders().map({ args0 -> args0 }),
            )
    }
}
