@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backends The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
 * @property connectTimeout Connection timeout. Unit: seconds, value range: 5~120.
 * @property focusHttpBackend Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that forced HTTP back-to-origin is enabled.
 * - **false**: indicates that forced HTTP back-to-origin is not enabled.
 * @property keepalive Open long connection, default true.
 * @property keepaliveRequests Number of long connections,  default: `60`. range :60-1000.
 * @property keepaliveTimeout Long connection over time, default: `15`. Range: 1-60.
 * @property loadbalance The load balancing algorithm used when returning to the source. Value:
 * - **iphash**: indicates the IPHash algorithm.
 * - **roundRobin**: indicates the polling algorithm.
 * - **leastTime**: indicates the Least Time algorithm.
 * - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
 * @property readTimeout Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
 * @property requestHeaders The traffic tag field and value of the domain name which used to mark the traffic processed by WAF.
 * It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
 * and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
 * when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
 * to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
 * custom header field already exists in the request, the system will overwrite the value of the custom field in the
 * request with the set traffic tag value. See `request_headers` below.
 * @property retry Back to Source Retry. default: true, retry 3 times by default.
 * @property sniEnabled Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
 * - **true**: indicates that the back-to-source SNI is enabled.
 * - **false** (default) indicates that the back-to-source SNI is not enabled.
 * @property sniHost Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
 * @property writeTimeout Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
 */
public data class DomainRedirect(
    public val backends: List<String>? = null,
    public val connectTimeout: Int? = null,
    public val focusHttpBackend: Boolean? = null,
    public val keepalive: Boolean? = null,
    public val keepaliveRequests: Int? = null,
    public val keepaliveTimeout: Int? = null,
    public val loadbalance: String,
    public val readTimeout: Int? = null,
    public val requestHeaders: List<DomainRedirectRequestHeader>? = null,
    public val retry: Boolean? = null,
    public val sniEnabled: Boolean? = null,
    public val sniHost: String? = null,
    public val writeTimeout: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.DomainRedirect): DomainRedirect = DomainRedirect(
            backends = javaType.backends().map({ args0 -> args0 }),
            connectTimeout = javaType.connectTimeout().map({ args0 -> args0 }).orElse(null),
            focusHttpBackend = javaType.focusHttpBackend().map({ args0 -> args0 }).orElse(null),
            keepalive = javaType.keepalive().map({ args0 -> args0 }).orElse(null),
            keepaliveRequests = javaType.keepaliveRequests().map({ args0 -> args0 }).orElse(null),
            keepaliveTimeout = javaType.keepaliveTimeout().map({ args0 -> args0 }).orElse(null),
            loadbalance = javaType.loadbalance(),
            readTimeout = javaType.readTimeout().map({ args0 -> args0 }).orElse(null),
            requestHeaders = javaType.requestHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.wafv3.kotlin.outputs.DomainRedirectRequestHeader.Companion.toKotlin(args0)
                })
            }),
            retry = javaType.retry().map({ args0 -> args0 }).orElse(null),
            sniEnabled = javaType.sniEnabled().map({ args0 -> args0 }).orElse(null),
            sniHost = javaType.sniHost().map({ args0 -> args0 }).orElse(null),
            writeTimeout = javaType.writeTimeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
