@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property domain The name of the domain name to query.
 * @property id The ID of the domain. It formats as `<instance_id>:<domain>`.
 * @property listens Configure listening information
 * @property redirects Configure forwarding information.
 * @property resourceManagerResourceGroupId The ID of the resource group.
 * @property status The status of the domain.
 */
public data class GetDomainsDomain(
    public val domain: String,
    public val id: String,
    public val listens: List<GetDomainsDomainListen>,
    public val redirects: List<GetDomainsDomainRedirect>,
    public val resourceManagerResourceGroupId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.GetDomainsDomain): GetDomainsDomain = GetDomainsDomain(
            domain = javaType.domain(),
            id = javaType.id(),
            listens = javaType.listens().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsDomainListen.Companion.toKotlin(args0)
                })
            }),
            redirects = javaType.redirects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsDomainRedirect.Companion.toKotlin(args0)
                })
            }),
            resourceManagerResourceGroupId = javaType.resourceManagerResourceGroupId(),
            status = javaType.status(),
        )
    }
}
