@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property certId The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property cipherSuite The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property customCiphers The specific custom encryption suite to add.
 * @property enableTlsv3 Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property exclusiveIp Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
 * @property focusHttps Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
 * @property http2Enabled Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property httpPorts The listening port of the HTTP protocol.
 * @property httpsPorts The listening port of the HTTPS protocol.
 * @property ipv6Enabled Whether IPv6 is turned on.
 * @property protectionResource The type of protection resource to use.
 * @property tlsVersion The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property xffHeaderMode WAF obtains the real IP address of the client.
 * @property xffHeaders Set the list of custom fields used to obtain the client IP address.
 */
public data class GetDomainsDomainListen(
    public val certId: String,
    public val cipherSuite: Int,
    public val customCiphers: List<String>,
    public val enableTlsv3: Boolean,
    public val exclusiveIp: Boolean,
    public val focusHttps: Boolean,
    public val http2Enabled: Boolean,
    public val httpPorts: List<Int>,
    public val httpsPorts: List<Int>,
    public val ipv6Enabled: Boolean,
    public val protectionResource: String,
    public val tlsVersion: String,
    public val xffHeaderMode: Int,
    public val xffHeaders: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.GetDomainsDomainListen): GetDomainsDomainListen = GetDomainsDomainListen(
            certId = javaType.certId(),
            cipherSuite = javaType.cipherSuite(),
            customCiphers = javaType.customCiphers().map({ args0 -> args0 }),
            enableTlsv3 = javaType.enableTlsv3(),
            exclusiveIp = javaType.exclusiveIp(),
            focusHttps = javaType.focusHttps(),
            http2Enabled = javaType.http2Enabled(),
            httpPorts = javaType.httpPorts().map({ args0 -> args0 }),
            httpsPorts = javaType.httpsPorts().map({ args0 -> args0 }),
            ipv6Enabled = javaType.ipv6Enabled(),
            protectionResource = javaType.protectionResource(),
            tlsVersion = javaType.tlsVersion(),
            xffHeaderMode = javaType.xffHeaderMode(),
            xffHeaders = javaType.xffHeaders().map({ args0 -> args0 }),
        )
    }
}
