@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backends The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
 * @property connectTimeout Connection timeout, Unit: seconds, value range: 5~120.
 * @property focusHttpBackend Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property keepalive Open long connection, default true.
 * @property keepaliveRequests Number of long connections, default: `60`. range :60-1000.
 * @property keepaliveTimeout Long connection over time, default: `15`. Range: 1-60.
 * @property loadbalance The load balancing algorithm used when returning to the source.
 * @property readTimeout Read timeout duration. Unit: seconds, Value range: 5~1800.
 * @property requestHeaders The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
 * @property retry Back to Source Retry. default `true`, retry 3 times by default.
 * @property sniEnabled Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
 * @property sniHost Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
 * @property writeTimeout Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
 */
public data class GetDomainsDomainRedirect(
    public val backends: List<String>,
    public val connectTimeout: Int,
    public val focusHttpBackend: Boolean,
    public val keepalive: Boolean,
    public val keepaliveRequests: Int,
    public val keepaliveTimeout: Int,
    public val loadbalance: String,
    public val readTimeout: Int,
    public val requestHeaders: List<GetDomainsDomainRedirectRequestHeader>,
    public val retry: Boolean,
    public val sniEnabled: Boolean,
    public val sniHost: String,
    public val writeTimeout: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.GetDomainsDomainRedirect): GetDomainsDomainRedirect = GetDomainsDomainRedirect(
            backends = javaType.backends().map({ args0 -> args0 }),
            connectTimeout = javaType.connectTimeout(),
            focusHttpBackend = javaType.focusHttpBackend(),
            keepalive = javaType.keepalive(),
            keepaliveRequests = javaType.keepaliveRequests(),
            keepaliveTimeout = javaType.keepaliveTimeout(),
            loadbalance = javaType.loadbalance(),
            readTimeout = javaType.readTimeout(),
            requestHeaders = javaType.requestHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsDomainRedirectRequestHeader.Companion.toKotlin(args0)
                })
            }),
            retry = javaType.retry(),
            sniEnabled = javaType.sniEnabled(),
            sniHost = javaType.sniHost(),
            writeTimeout = javaType.writeTimeout(),
        )
    }
}
