@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.wafv3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDomains.
 * @property backend
 * @property domain The name of the domain.
 * @property domains A list of Domain Entries. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 */
public data class GetDomainsResult(
    public val backend: String? = null,
    public val domain: String? = null,
    public val domains: List<GetDomainsDomain>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.wafv3.outputs.GetDomainsResult): GetDomainsResult = GetDomainsResult(
            backend = javaType.backend().map({ args0 -> args0 }).orElse(null),
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.wafv3.kotlin.outputs.GetDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
