@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin

import com.pulumi.alicloud.yundun.kotlin.outputs.BastionHostInstanceAdAuthServer
import com.pulumi.alicloud.yundun.kotlin.outputs.BastionHostInstanceLdapAuthServer
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.yundun.kotlin.outputs.BastionHostInstanceAdAuthServer.Companion.toKotlin as bastionHostInstanceAdAuthServerToKotlin
import com.pulumi.alicloud.yundun.kotlin.outputs.BastionHostInstanceLdapAuthServer.Companion.toKotlin as bastionHostInstanceLdapAuthServerToKotlin

/**
 * Builder for [BastionHostInstance].
 */
@PulumiTagMarker
public class BastionHostInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BastionHostInstanceArgs = BastionHostInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BastionHostInstanceArgsBuilder.() -> Unit) {
        val builder = BastionHostInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BastionHostInstance {
        val builtJavaResource = com.pulumi.alicloud.yundun.BastionHostInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BastionHostInstance(builtJavaResource)
    }
}

public class BastionHostInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.yundun.BastionHostInstance,
) : KotlinCustomResource(javaResource, BastionHostInstanceMapper) {
    public val adAuthServers: Output<List<BastionHostInstanceAdAuthServer>>
        get() = javaResource.adAuthServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bastionHostInstanceAdAuthServerToKotlin(args0) })
            })
        })

    public val bandwidth: Output<String>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0 })

    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    public val enablePublicAccess: Output<Boolean>
        get() = javaResource.enablePublicAccess().applyValue({ args0 -> args0 })

    public val ldapAuthServers: Output<List<BastionHostInstanceLdapAuthServer>>
        get() = javaResource.ldapAuthServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bastionHostInstanceLdapAuthServerToKotlin(args0) })
            })
        })

    public val licenseCode: Output<String>
        get() = javaResource.licenseCode().applyValue({ args0 -> args0 })

    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val planCode: Output<String>
        get() = javaResource.planCode().applyValue({ args0 -> args0 })

    public val publicWhiteLists: Output<List<String>>?
        get() = javaResource.publicWhiteLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val renewalPeriodUnit: Output<String>
        get() = javaResource.renewalPeriodUnit().applyValue({ args0 -> args0 })

    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val storage: Output<String>
        get() = javaResource.storage().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object BastionHostInstanceMapper : ResourceMapper<BastionHostInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.yundun.BastionHostInstance::class == javaResource::class

    override fun map(javaResource: Resource): BastionHostInstance = BastionHostInstance(
        javaResource
            as com.pulumi.alicloud.yundun.BastionHostInstance,
    )
}

/**
 * @see [BastionHostInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BastionHostInstance].
 */
public suspend fun bastionHostInstance(
    name: String,
    block: suspend BastionHostInstanceResourceBuilder.() -> Unit,
): BastionHostInstance {
    val builder = BastionHostInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BastionHostInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bastionHostInstance(name: String): BastionHostInstance {
    val builder = BastionHostInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
