@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin

import com.pulumi.alicloud.yundun.BastionHostInstanceArgs.builder
import com.pulumi.alicloud.yundun.kotlin.inputs.BastionHostInstanceAdAuthServerArgs
import com.pulumi.alicloud.yundun.kotlin.inputs.BastionHostInstanceAdAuthServerArgsBuilder
import com.pulumi.alicloud.yundun.kotlin.inputs.BastionHostInstanceLdapAuthServerArgs
import com.pulumi.alicloud.yundun.kotlin.inputs.BastionHostInstanceLdapAuthServerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property adAuthServers
 * @property bandwidth
 * @property description
 * @property enablePublicAccess
 * @property ldapAuthServers
 * @property licenseCode
 * @property period
 * @property planCode
 * @property publicWhiteLists
 * @property renewPeriod
 * @property renewalPeriodUnit
 * @property renewalStatus
 * @property resourceGroupId
 * @property securityGroupIds
 * @property storage
 * @property tags
 * @property vswitchId
 */
public data class BastionHostInstanceArgs(
    public val adAuthServers: Output<List<BastionHostInstanceAdAuthServerArgs>>? = null,
    public val bandwidth: Output<String>? = null,
    public val description: Output<String>? = null,
    public val enablePublicAccess: Output<Boolean>? = null,
    public val ldapAuthServers: Output<List<BastionHostInstanceLdapAuthServerArgs>>? = null,
    public val licenseCode: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val planCode: Output<String>? = null,
    public val publicWhiteLists: Output<List<String>>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalPeriodUnit: Output<String>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storage: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.BastionHostInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.BastionHostInstanceArgs =
        com.pulumi.alicloud.yundun.BastionHostInstanceArgs.builder()
            .adAuthServers(
                adAuthServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enablePublicAccess(enablePublicAccess?.applyValue({ args0 -> args0 }))
            .ldapAuthServers(
                ldapAuthServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .licenseCode(licenseCode?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .planCode(planCode?.applyValue({ args0 -> args0 }))
            .publicWhiteLists(publicWhiteLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalPeriodUnit(renewalPeriodUnit?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storage(storage?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BastionHostInstanceArgs].
 */
@PulumiTagMarker
public class BastionHostInstanceArgsBuilder internal constructor() {
    private var adAuthServers: Output<List<BastionHostInstanceAdAuthServerArgs>>? = null

    private var bandwidth: Output<String>? = null

    private var description: Output<String>? = null

    private var enablePublicAccess: Output<Boolean>? = null

    private var ldapAuthServers: Output<List<BastionHostInstanceLdapAuthServerArgs>>? = null

    private var licenseCode: Output<String>? = null

    private var period: Output<Int>? = null

    private var planCode: Output<String>? = null

    private var publicWhiteLists: Output<List<String>>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalPeriodUnit: Output<String>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storage: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ufqfwhyugnnmjhxr")
    public suspend fun adAuthServers(`value`: Output<List<BastionHostInstanceAdAuthServerArgs>>) {
        this.adAuthServers = value
    }

    @JvmName("bwqdgkhovhqjiptb")
    public suspend fun adAuthServers(vararg values: Output<BastionHostInstanceAdAuthServerArgs>) {
        this.adAuthServers = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qspvxakvxdawdacl")
    public suspend fun adAuthServers(values: List<Output<BastionHostInstanceAdAuthServerArgs>>) {
        this.adAuthServers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ihxpoxhnrmrjjrrv")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value
     */
    @JvmName("tfiomrntqldeapnr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("tpetinlgaejwvstd")
    public suspend fun enablePublicAccess(`value`: Output<Boolean>) {
        this.enablePublicAccess = value
    }

    /**
     * @param value
     */
    @JvmName("dresjoxxwtlogsef")
    public suspend fun ldapAuthServers(`value`: Output<List<BastionHostInstanceLdapAuthServerArgs>>) {
        this.ldapAuthServers = value
    }

    @JvmName("tmhyunqbjuicnkud")
    public suspend fun ldapAuthServers(vararg values: Output<BastionHostInstanceLdapAuthServerArgs>) {
        this.ldapAuthServers = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yayesakhnfwvfljd")
    public suspend fun ldapAuthServers(values: List<Output<BastionHostInstanceLdapAuthServerArgs>>) {
        this.ldapAuthServers = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("pvjlftcfjkinhjjs")
    public suspend fun licenseCode(`value`: Output<String>) {
        this.licenseCode = value
    }

    /**
     * @param value
     */
    @JvmName("vuafuacvdhgvrcya")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value
     */
    @JvmName("mmpputwrufsffwla")
    public suspend fun planCode(`value`: Output<String>) {
        this.planCode = value
    }

    /**
     * @param value
     */
    @JvmName("sljflspwaefutrio")
    public suspend fun publicWhiteLists(`value`: Output<List<String>>) {
        this.publicWhiteLists = value
    }

    @JvmName("qeobauocedqdwcsq")
    public suspend fun publicWhiteLists(vararg values: Output<String>) {
        this.publicWhiteLists = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nijdgalklswworsq")
    public suspend fun publicWhiteLists(values: List<Output<String>>) {
        this.publicWhiteLists = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("umcseadbinwodpfd")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("lxertfkdpbqxbcub")
    public suspend fun renewalPeriodUnit(`value`: Output<String>) {
        this.renewalPeriodUnit = value
    }

    /**
     * @param value
     */
    @JvmName("ymgjwakdhungqgvy")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value
     */
    @JvmName("urypwjpwyaulcylh")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value
     */
    @JvmName("lwxaiqiickgskcfd")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("jnrlqpixablppjqk")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("omiwlhutuxfeommn")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ofrxrtufrmhadrbr")
    public suspend fun storage(`value`: Output<String>) {
        this.storage = value
    }

    /**
     * @param value
     */
    @JvmName("xxldkvdrgcrqnhpr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("jkckumtfywstcnff")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value
     */
    @JvmName("hohfvafmagcpcxuj")
    public suspend fun adAuthServers(`value`: List<BastionHostInstanceAdAuthServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uhcblaamytixdhgd")
    public suspend fun adAuthServers(argument: List<suspend BastionHostInstanceAdAuthServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BastionHostInstanceAdAuthServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iblfbdtfavaochms")
    public suspend fun adAuthServers(vararg argument: suspend BastionHostInstanceAdAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BastionHostInstanceAdAuthServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hnoqxjqsqswttrbh")
    public suspend fun adAuthServers(argument: suspend BastionHostInstanceAdAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BastionHostInstanceAdAuthServerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.adAuthServers = mapped
    }

    /**
     * @param values
     */
    @JvmName("aurxlrwnfxvacfxh")
    public suspend fun adAuthServers(vararg values: BastionHostInstanceAdAuthServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adAuthServers = mapped
    }

    /**
     * @param value
     */
    @JvmName("prabltycqguubjnn")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value
     */
    @JvmName("yefaxcprkhtxupcs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("bnkcitshdtrvdnas")
    public suspend fun enablePublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublicAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("mlygjikdorrgxitv")
    public suspend fun ldapAuthServers(`value`: List<BastionHostInstanceLdapAuthServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ulurhbiqvobxkwop")
    public suspend fun ldapAuthServers(argument: List<suspend BastionHostInstanceLdapAuthServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BastionHostInstanceLdapAuthServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("nklxptumefpplqta")
    public suspend fun ldapAuthServers(vararg argument: suspend BastionHostInstanceLdapAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BastionHostInstanceLdapAuthServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sgojhwvoylqvlrcj")
    public suspend fun ldapAuthServers(argument: suspend BastionHostInstanceLdapAuthServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BastionHostInstanceLdapAuthServerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ldapAuthServers = mapped
    }

    /**
     * @param values
     */
    @JvmName("euhskprhclkkbepk")
    public suspend fun ldapAuthServers(vararg values: BastionHostInstanceLdapAuthServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ldapAuthServers = mapped
    }

    /**
     * @param value
     */
    @JvmName("txwgwtiybjimxjpm")
    public suspend fun licenseCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("drexvmqoatblmwjs")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value
     */
    @JvmName("aijhyneggemxabxj")
    public suspend fun planCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCode = mapped
    }

    /**
     * @param value
     */
    @JvmName("mtbovjjjlpvvnxoe")
    public suspend fun publicWhiteLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicWhiteLists = mapped
    }

    /**
     * @param values
     */
    @JvmName("qidstjshkldsdfbu")
    public suspend fun publicWhiteLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicWhiteLists = mapped
    }

    /**
     * @param value
     */
    @JvmName("lagjcnuvwwjtwsny")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("dtbafwdliqggrcfa")
    public suspend fun renewalPeriodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalPeriodUnit = mapped
    }

    /**
     * @param value
     */
    @JvmName("novwpolaiskfwcbd")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value
     */
    @JvmName("umvbrkpmitvxpyaf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcskwpbfwgdjyblj")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("hwjlqdklctaoxpqg")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("dpkjmlddjqdvfwrb")
    public suspend fun storage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param value
     */
    @JvmName("ccvwqjfyjkyowqfq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("eaxvlswuwuxipnvt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("ggitwkqfbyltfwjd")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): BastionHostInstanceArgs = BastionHostInstanceArgs(
        adAuthServers = adAuthServers,
        bandwidth = bandwidth,
        description = description,
        enablePublicAccess = enablePublicAccess,
        ldapAuthServers = ldapAuthServers,
        licenseCode = licenseCode,
        period = period,
        planCode = planCode,
        publicWhiteLists = publicWhiteLists,
        renewPeriod = renewPeriod,
        renewalPeriodUnit = renewalPeriodUnit,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        securityGroupIds = securityGroupIds,
        storage = storage,
        tags = tags,
        vswitchId = vswitchId,
    )
}
