@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DBAuditInstance].
 */
@PulumiTagMarker
public class DBAuditInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DBAuditInstanceArgs = DBAuditInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DBAuditInstanceArgsBuilder.() -> Unit) {
        val builder = DBAuditInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DBAuditInstance {
        val builtJavaResource = com.pulumi.alicloud.yundun.DBAuditInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DBAuditInstance(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * Yundun_dbaudit instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:yundun/dBAuditInstance:DBAuditInstance example dbaudit-exampe123456
 * ```
 */
public class DBAuditInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.yundun.DBAuditInstance,
) : KotlinCustomResource(javaResource, DBAuditInstanceMapper) {
    /**
     * Description of the instance. This name can have a string of 1 to 63 characters.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * Plan code of the Cloud DBAudit to produce. (alpha.professional, alpha.basic, alpha.premium)
     */
    public val planCode: Output<String>
        get() = javaResource.planCode().applyValue({ args0 -> args0 })

    /**
     * The Id of resource group which the DBaudit Instance belongs. If not set, the resource is created in the default resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * vSwtich ID configured to audit
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object DBAuditInstanceMapper : ResourceMapper<DBAuditInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.yundun.DBAuditInstance::class == javaResource::class

    override fun map(javaResource: Resource): DBAuditInstance = DBAuditInstance(
        javaResource as
            com.pulumi.alicloud.yundun.DBAuditInstance,
    )
}

/**
 * @see [DBAuditInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DBAuditInstance].
 */
public suspend fun dbAuditInstance(
    name: String,
    block: suspend DBAuditInstanceResourceBuilder.() -> Unit,
): DBAuditInstance {
    val builder = DBAuditInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DBAuditInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dbAuditInstance(name: String): DBAuditInstance {
    val builder = DBAuditInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
