@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin

import com.pulumi.alicloud.yundun.DBAuditInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Yundun_dbaudit instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:yundun/dBAuditInstance:DBAuditInstance example dbaudit-exampe123456
 * ```
 * @property description Description of the instance. This name can have a string of 1 to 63 characters.
 * @property period Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
 * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
 * @property planCode Plan code of the Cloud DBAudit to produce. (alpha.professional, alpha.basic, alpha.premium)
 * @property resourceGroupId The Id of resource group which the DBaudit Instance belongs. If not set, the resource is created in the default resource group.
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId vSwtich ID configured to audit
 */
public data class DBAuditInstanceArgs(
    public val description: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val planCode: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.DBAuditInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.DBAuditInstanceArgs =
        com.pulumi.alicloud.yundun.DBAuditInstanceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .planCode(planCode?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DBAuditInstanceArgs].
 */
@PulumiTagMarker
public class DBAuditInstanceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var period: Output<Int>? = null

    private var planCode: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Description of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("mpsjwebnoglqrhnl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("aqtuktmrcnancsff")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Plan code of the Cloud DBAudit to produce. (alpha.professional, alpha.basic, alpha.premium)
     */
    @JvmName("gusvyqqjyfnhmxni")
    public suspend fun planCode(`value`: Output<String>) {
        this.planCode = value
    }

    /**
     * @param value The Id of resource group which the DBaudit Instance belongs. If not set, the resource is created in the default resource group.
     */
    @JvmName("bhqjqevmvrpebdct")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("anpcibtprqhinbej")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value vSwtich ID configured to audit
     */
    @JvmName("krrscyudhrfskuod")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Description of the instance. This name can have a string of 1 to 63 characters.
     */
    @JvmName("uwqnqyjsrneaxemc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Duration for initially producing the instance. Valid values: [1~9], 12, 24, 36. At present, the provider does not support modify "period".
     * > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
     */
    @JvmName("odnnywhwashsbiro")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Plan code of the Cloud DBAudit to produce. (alpha.professional, alpha.basic, alpha.premium)
     */
    @JvmName("iswbajwtrwxhocyp")
    public suspend fun planCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.planCode = mapped
    }

    /**
     * @param value The Id of resource group which the DBaudit Instance belongs. If not set, the resource is created in the default resource group.
     */
    @JvmName("yrhgypxlntrerbdf")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("dvpmkvufonvnxdmg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("schjgphpjbsthptf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value vSwtich ID configured to audit
     */
    @JvmName("metlcxhfavqypvlu")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): DBAuditInstanceArgs = DBAuditInstanceArgs(
        description = description,
        period = period,
        planCode = planCode,
        resourceGroupId = resourceGroupId,
        tags = tags,
        vswitchId = vswitchId,
    )
}
