@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin

import com.pulumi.alicloud.yundun.YundunFunctions.getBastionHostInstancesPlain
import com.pulumi.alicloud.yundun.YundunFunctions.getDBAuditInstancePlain
import com.pulumi.alicloud.yundun.kotlin.inputs.GetBastionHostInstancesPlainArgs
import com.pulumi.alicloud.yundun.kotlin.inputs.GetBastionHostInstancesPlainArgsBuilder
import com.pulumi.alicloud.yundun.kotlin.inputs.GetDBAuditInstancePlainArgs
import com.pulumi.alicloud.yundun.kotlin.inputs.GetDBAuditInstancePlainArgsBuilder
import com.pulumi.alicloud.yundun.kotlin.outputs.GetBastionHostInstancesResult
import com.pulumi.alicloud.yundun.kotlin.outputs.GetDBAuditInstanceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.yundun.kotlin.outputs.GetBastionHostInstancesResult.Companion.toKotlin as getBastionHostInstancesResultToKotlin
import com.pulumi.alicloud.yundun.kotlin.outputs.GetDBAuditInstanceResult.Companion.toKotlin as getDBAuditInstanceResultToKotlin

public object YundunFunctions {
    /**
     *
     * @param argument A collection of arguments for invoking getBastionHostInstances.
     * @return A collection of values returned by getBastionHostInstances.
     */
    public suspend fun getBastionHostInstances(argument: GetBastionHostInstancesPlainArgs): GetBastionHostInstancesResult =
        getBastionHostInstancesResultToKotlin(getBastionHostInstancesPlain(argument.toJava()).await())

    /**
     * @see [getBastionHostInstances].
     * @param descriptionRegex
     * @param ids
     * @param outputFile
     * @param tags
     * @return A collection of values returned by getBastionHostInstances.
     */
    public suspend fun getBastionHostInstances(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetBastionHostInstancesResult {
        val argument = GetBastionHostInstancesPlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            tags = tags,
        )
        return getBastionHostInstancesResultToKotlin(getBastionHostInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getBastionHostInstances].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;yundun&#46;kotlin&#46;inputs&#46;GetBastionHostInstancesPlainArgs].
     * @return A collection of values returned by getBastionHostInstances.
     */
    public suspend fun getBastionHostInstances(argument: suspend GetBastionHostInstancesPlainArgsBuilder.() -> Unit): GetBastionHostInstancesResult {
        val builder = GetBastionHostInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBastionHostInstancesResultToKotlin(getBastionHostInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     *
     * @param argument A collection of arguments for invoking getDBAuditInstance.
     * @return A collection of values returned by getDBAuditInstance.
     */
    public suspend fun getDBAuditInstance(argument: GetDBAuditInstancePlainArgs): GetDBAuditInstanceResult =
        getDBAuditInstanceResultToKotlin(getDBAuditInstancePlain(argument.toJava()).await())

    /**
     * @see [getDBAuditInstance].
     * @param descriptionRegex
     * @param ids
     * @param outputFile
     * @param tags
     * @return A collection of values returned by getDBAuditInstance.
     */
    public suspend fun getDBAuditInstance(
        descriptionRegex: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetDBAuditInstanceResult {
        val argument = GetDBAuditInstancePlainArgs(
            descriptionRegex = descriptionRegex,
            ids = ids,
            outputFile = outputFile,
            tags = tags,
        )
        return getDBAuditInstanceResultToKotlin(getDBAuditInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getDBAuditInstance].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;yundun&#46;kotlin&#46;inputs&#46;GetDBAuditInstancePlainArgs].
     * @return A collection of values returned by getDBAuditInstance.
     */
    public suspend fun getDBAuditInstance(argument: suspend GetDBAuditInstancePlainArgsBuilder.() -> Unit): GetDBAuditInstanceResult {
        val builder = GetDBAuditInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDBAuditInstanceResultToKotlin(getDBAuditInstancePlain(builtArgument.toJava()).await())
    }
}
