@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.inputs

import com.pulumi.alicloud.yundun.inputs.BastionHostInstanceAdAuthServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property account
 * @property baseDn
 * @property domain
 * @property emailMapping
 * @property filter
 * @property isSsl
 * @property mobileMapping
 * @property nameMapping
 * @property password
 * @property port
 * @property server
 * @property standbyServer
 */
public data class BastionHostInstanceAdAuthServerArgs(
    public val account: Output<String>,
    public val baseDn: Output<String>,
    public val domain: Output<String>,
    public val emailMapping: Output<String>? = null,
    public val filter: Output<String>? = null,
    public val isSsl: Output<Boolean>,
    public val mobileMapping: Output<String>? = null,
    public val nameMapping: Output<String>? = null,
    public val password: Output<String>,
    public val port: Output<Int>,
    public val server: Output<String>,
    public val standbyServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.inputs.BastionHostInstanceAdAuthServerArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.inputs.BastionHostInstanceAdAuthServerArgs =
        com.pulumi.alicloud.yundun.inputs.BastionHostInstanceAdAuthServerArgs.builder()
            .account(account.applyValue({ args0 -> args0 }))
            .baseDn(baseDn.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 }))
            .emailMapping(emailMapping?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0 }))
            .isSsl(isSsl.applyValue({ args0 -> args0 }))
            .mobileMapping(mobileMapping?.applyValue({ args0 -> args0 }))
            .nameMapping(nameMapping?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .standbyServer(standbyServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BastionHostInstanceAdAuthServerArgs].
 */
@PulumiTagMarker
public class BastionHostInstanceAdAuthServerArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var baseDn: Output<String>? = null

    private var domain: Output<String>? = null

    private var emailMapping: Output<String>? = null

    private var filter: Output<String>? = null

    private var isSsl: Output<Boolean>? = null

    private var mobileMapping: Output<String>? = null

    private var nameMapping: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var server: Output<String>? = null

    private var standbyServer: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("osvbcdeylygfjipw")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value
     */
    @JvmName("puudbssdthchnmsb")
    public suspend fun baseDn(`value`: Output<String>) {
        this.baseDn = value
    }

    /**
     * @param value
     */
    @JvmName("lhgfwbdmeggnmtoi")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value
     */
    @JvmName("rafutfxntudrqchi")
    public suspend fun emailMapping(`value`: Output<String>) {
        this.emailMapping = value
    }

    /**
     * @param value
     */
    @JvmName("qtdvxwyodhupcoxh")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value
     */
    @JvmName("nxndfyanlwkkqvqg")
    public suspend fun isSsl(`value`: Output<Boolean>) {
        this.isSsl = value
    }

    /**
     * @param value
     */
    @JvmName("wkmhcesktqnhvkht")
    public suspend fun mobileMapping(`value`: Output<String>) {
        this.mobileMapping = value
    }

    /**
     * @param value
     */
    @JvmName("cgwsolfiwrjllyuh")
    public suspend fun nameMapping(`value`: Output<String>) {
        this.nameMapping = value
    }

    /**
     * @param value
     */
    @JvmName("hrdpadscftqbabjd")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("vdkbsmylbrpfpdko")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("plopfmyngjokoyas")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value
     */
    @JvmName("fbhbuhfclietdipw")
    public suspend fun standbyServer(`value`: Output<String>) {
        this.standbyServer = value
    }

    /**
     * @param value
     */
    @JvmName("pueuiohiyducpufi")
    public suspend fun account(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujacsdkjhqjfcoqf")
    public suspend fun baseDn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseDn = mapped
    }

    /**
     * @param value
     */
    @JvmName("cuexvgftpctpucrb")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypnckaylanixbmho")
    public suspend fun emailMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("ntejldewdvsbfnfi")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value
     */
    @JvmName("ktdpwdaxfedacteh")
    public suspend fun isSsl(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isSsl = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqjeotofwlisajgc")
    public suspend fun mobileMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("jsekasbrinpdnxvi")
    public suspend fun nameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujsxemolnlljpcfd")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("avsspqhqqqkvtdmg")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("apwanndrerssvtui")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value
     */
    @JvmName("qrlqqdhaigljfrhm")
    public suspend fun standbyServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyServer = mapped
    }

    internal fun build(): BastionHostInstanceAdAuthServerArgs = BastionHostInstanceAdAuthServerArgs(
        account = account ?: throw PulumiNullFieldException("account"),
        baseDn = baseDn ?: throw PulumiNullFieldException("baseDn"),
        domain = domain ?: throw PulumiNullFieldException("domain"),
        emailMapping = emailMapping,
        filter = filter,
        isSsl = isSsl ?: throw PulumiNullFieldException("isSsl"),
        mobileMapping = mobileMapping,
        nameMapping = nameMapping,
        password = password ?: throw PulumiNullFieldException("password"),
        port = port ?: throw PulumiNullFieldException("port"),
        server = server ?: throw PulumiNullFieldException("server"),
        standbyServer = standbyServer,
    )
}
