@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.inputs

import com.pulumi.alicloud.yundun.inputs.BastionHostInstanceLdapAuthServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property account
 * @property baseDn
 * @property emailMapping
 * @property filter
 * @property isSsl
 * @property loginNameMapping
 * @property mobileMapping
 * @property nameMapping
 * @property password
 * @property port
 * @property server
 * @property standbyServer
 */
public data class BastionHostInstanceLdapAuthServerArgs(
    public val account: Output<String>,
    public val baseDn: Output<String>,
    public val emailMapping: Output<String>? = null,
    public val filter: Output<String>? = null,
    public val isSsl: Output<Boolean>? = null,
    public val loginNameMapping: Output<String>? = null,
    public val mobileMapping: Output<String>? = null,
    public val nameMapping: Output<String>? = null,
    public val password: Output<String>,
    public val port: Output<Int>,
    public val server: Output<String>,
    public val standbyServer: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.inputs.BastionHostInstanceLdapAuthServerArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.inputs.BastionHostInstanceLdapAuthServerArgs =
        com.pulumi.alicloud.yundun.inputs.BastionHostInstanceLdapAuthServerArgs.builder()
            .account(account.applyValue({ args0 -> args0 }))
            .baseDn(baseDn.applyValue({ args0 -> args0 }))
            .emailMapping(emailMapping?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0 }))
            .isSsl(isSsl?.applyValue({ args0 -> args0 }))
            .loginNameMapping(loginNameMapping?.applyValue({ args0 -> args0 }))
            .mobileMapping(mobileMapping?.applyValue({ args0 -> args0 }))
            .nameMapping(nameMapping?.applyValue({ args0 -> args0 }))
            .password(password.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .standbyServer(standbyServer?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BastionHostInstanceLdapAuthServerArgs].
 */
@PulumiTagMarker
public class BastionHostInstanceLdapAuthServerArgsBuilder internal constructor() {
    private var account: Output<String>? = null

    private var baseDn: Output<String>? = null

    private var emailMapping: Output<String>? = null

    private var filter: Output<String>? = null

    private var isSsl: Output<Boolean>? = null

    private var loginNameMapping: Output<String>? = null

    private var mobileMapping: Output<String>? = null

    private var nameMapping: Output<String>? = null

    private var password: Output<String>? = null

    private var port: Output<Int>? = null

    private var server: Output<String>? = null

    private var standbyServer: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ktdfnkvivptsrxdc")
    public suspend fun account(`value`: Output<String>) {
        this.account = value
    }

    /**
     * @param value
     */
    @JvmName("njxhxghsjpnrqhdh")
    public suspend fun baseDn(`value`: Output<String>) {
        this.baseDn = value
    }

    /**
     * @param value
     */
    @JvmName("vhfcrqssanifuqcf")
    public suspend fun emailMapping(`value`: Output<String>) {
        this.emailMapping = value
    }

    /**
     * @param value
     */
    @JvmName("eiwkrsaxcgvwoara")
    public suspend fun filter(`value`: Output<String>) {
        this.filter = value
    }

    /**
     * @param value
     */
    @JvmName("hutmnuuctokrpjoo")
    public suspend fun isSsl(`value`: Output<Boolean>) {
        this.isSsl = value
    }

    /**
     * @param value
     */
    @JvmName("jyogixnygbiyjeni")
    public suspend fun loginNameMapping(`value`: Output<String>) {
        this.loginNameMapping = value
    }

    /**
     * @param value
     */
    @JvmName("esmvcdgfjdjmgfgk")
    public suspend fun mobileMapping(`value`: Output<String>) {
        this.mobileMapping = value
    }

    /**
     * @param value
     */
    @JvmName("llyaosboyukdttpp")
    public suspend fun nameMapping(`value`: Output<String>) {
        this.nameMapping = value
    }

    /**
     * @param value
     */
    @JvmName("rocxsndryffjcfea")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value
     */
    @JvmName("tlqttngdemlkwlgq")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value
     */
    @JvmName("bdphxbmfantpndlh")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value
     */
    @JvmName("whahgyqvgqlksdib")
    public suspend fun standbyServer(`value`: Output<String>) {
        this.standbyServer = value
    }

    /**
     * @param value
     */
    @JvmName("klccwwxqxmyrsyuq")
    public suspend fun account(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.account = mapped
    }

    /**
     * @param value
     */
    @JvmName("tmfqpjvsjxhosudt")
    public suspend fun baseDn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.baseDn = mapped
    }

    /**
     * @param value
     */
    @JvmName("fdhhpyjseowwxwqm")
    public suspend fun emailMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("losworfnrwybeojn")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param value
     */
    @JvmName("mjhwxyxhwdrlmoiu")
    public suspend fun isSsl(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSsl = mapped
    }

    /**
     * @param value
     */
    @JvmName("imndbbybwraapudw")
    public suspend fun loginNameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loginNameMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("hjeydwntbrshplhh")
    public suspend fun mobileMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobileMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("mwqhmiwrffhqfjys")
    public suspend fun nameMapping(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameMapping = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxhjsslnwahifjnb")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value
     */
    @JvmName("fxtnystxbisounsc")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value
     */
    @JvmName("puyqaundgwdacjow")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value
     */
    @JvmName("piukgublcufkvtvd")
    public suspend fun standbyServer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyServer = mapped
    }

    internal fun build(): BastionHostInstanceLdapAuthServerArgs =
        BastionHostInstanceLdapAuthServerArgs(
            account = account ?: throw PulumiNullFieldException("account"),
            baseDn = baseDn ?: throw PulumiNullFieldException("baseDn"),
            emailMapping = emailMapping,
            filter = filter,
            isSsl = isSsl,
            loginNameMapping = loginNameMapping,
            mobileMapping = mobileMapping,
            nameMapping = nameMapping,
            password = password ?: throw PulumiNullFieldException("password"),
            port = port ?: throw PulumiNullFieldException("port"),
            server = server ?: throw PulumiNullFieldException("server"),
            standbyServer = standbyServer,
        )
}
