@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.inputs

import com.pulumi.alicloud.yundun.inputs.GetBastionHostInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBastionHostInstances.
 * @property descriptionRegex
 * @property ids
 * @property outputFile
 * @property tags
 */
public data class GetBastionHostInstancesPlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.inputs.GetBastionHostInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.inputs.GetBastionHostInstancesPlainArgs =
        com.pulumi.alicloud.yundun.inputs.GetBastionHostInstancesPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetBastionHostInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetBastionHostInstancesPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("adrsupsodwbxbkfx")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("sppajknhaejkhvgs")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("sylibmcaeshetakb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("stmdhgcqlxkinsmo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ikbtvfmmehftsahr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("udakeraogfchsyiy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetBastionHostInstancesPlainArgs = GetBastionHostInstancesPlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        tags = tags,
    )
}
