@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.inputs

import com.pulumi.alicloud.yundun.inputs.GetDBAuditInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDBAuditInstance.
 * @property descriptionRegex
 * @property ids
 * @property outputFile
 * @property tags
 */
public data class GetDBAuditInstancePlainArgs(
    public val descriptionRegex: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.yundun.inputs.GetDBAuditInstancePlainArgs> {
    override fun toJava(): com.pulumi.alicloud.yundun.inputs.GetDBAuditInstancePlainArgs =
        com.pulumi.alicloud.yundun.inputs.GetDBAuditInstancePlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDBAuditInstancePlainArgs].
 */
@PulumiTagMarker
public class GetDBAuditInstancePlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value
     */
    @JvmName("rhefgfupqfnbpuvq")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("nxlbjmgmcqwexujl")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("eflstfqcntfsyqrc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("incwhwrcgocmgnmd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("gblvotjwblndjkpt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("bdckabrgtyvpqwys")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDBAuditInstancePlainArgs = GetDBAuditInstancePlainArgs(
        descriptionRegex = descriptionRegex,
        ids = ids,
        outputFile = outputFile,
        tags = tags,
    )
}
