@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property account
 * @property baseDn
 * @property domain
 * @property emailMapping
 * @property filter
 * @property isSsl
 * @property mobileMapping
 * @property nameMapping
 * @property password
 * @property port
 * @property server
 * @property standbyServer
 */
public data class BastionHostInstanceAdAuthServer(
    public val account: String,
    public val baseDn: String,
    public val domain: String,
    public val emailMapping: String? = null,
    public val filter: String? = null,
    public val isSsl: Boolean,
    public val mobileMapping: String? = null,
    public val nameMapping: String? = null,
    public val password: String,
    public val port: Int,
    public val server: String,
    public val standbyServer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.yundun.outputs.BastionHostInstanceAdAuthServer): BastionHostInstanceAdAuthServer = BastionHostInstanceAdAuthServer(
            account = javaType.account(),
            baseDn = javaType.baseDn(),
            domain = javaType.domain(),
            emailMapping = javaType.emailMapping().map({ args0 -> args0 }).orElse(null),
            filter = javaType.filter().map({ args0 -> args0 }).orElse(null),
            isSsl = javaType.isSsl(),
            mobileMapping = javaType.mobileMapping().map({ args0 -> args0 }).orElse(null),
            nameMapping = javaType.nameMapping().map({ args0 -> args0 }).orElse(null),
            password = javaType.password(),
            port = javaType.port(),
            server = javaType.server(),
            standbyServer = javaType.standbyServer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
