@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.yundun.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property description
 * @property id
 * @property instanceStatus
 * @property licenseCode
 * @property privateDomain
 * @property publicDomain
 * @property publicNetworkAccess
 * @property tags
 * @property userVswitchId
 */
public data class GetDBAuditInstanceInstance(
    public val description: String,
    public val id: String,
    public val instanceStatus: String,
    public val licenseCode: String,
    public val privateDomain: String,
    public val publicDomain: String,
    public val publicNetworkAccess: Boolean,
    public val tags: Map<String, String>? = null,
    public val userVswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.yundun.outputs.GetDBAuditInstanceInstance): GetDBAuditInstanceInstance = GetDBAuditInstanceInstance(
            description = javaType.description(),
            id = javaType.id(),
            instanceStatus = javaType.instanceStatus(),
            licenseCode = javaType.licenseCode(),
            privateDomain = javaType.privateDomain(),
            publicDomain = javaType.publicDomain(),
            publicNetworkAccess = javaType.publicNetworkAccess(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            userVswitchId = javaType.userVswitchId(),
        )
    }
}
