/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.client.language.dql;

import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.language.basics.Direction;
import org.vitrivr.cottontail.client.language.basics.Distances;
import org.vitrivr.cottontail.client.language.basics.LanguageFeature;
import org.vitrivr.cottontail.client.language.basics.expression.Column;
import org.vitrivr.cottontail.client.language.basics.expression.Expression;
import org.vitrivr.cottontail.client.language.basics.predicate.Predicate;
import org.vitrivr.cottontail.client.language.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J&\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u001a\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u001a\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u001e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003J4\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020 J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u0016\u0010)\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0003H\u0016J \u0010-\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020$J\u001a\u00101\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u001a\u00101\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u000e\u00102\u001a\u00020\u00002\u0006\u00102\u001a\u00020$J\u0010\u00103\u001a\u00020\u00002\u0006\u00103\u001a\u00020$H\u0016J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0003J.\u00108\u001a\u00020\u00002\b\b\u0002\u00109\u001a\u00020/2\b\b\u0002\u0010:\u001a\u00020/2\b\b\u0002\u0010;\u001a\u00020/2\b\b\u0002\u0010<\u001a\u00020/J\u0011\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020?H\u0086\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006@"}, d2={"Lorg/vitrivr/cottontail/client/language/dql/Query;", "Lorg/vitrivr/cottontail/client/language/basics/LanguageFeature;", "entity", "", "(Ljava/lang/String;)V", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;)V", "builder", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage$Builder;", "getBuilder", "()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage$Builder;", "clear", "count", "disallowIndex", "disallowOptimisation", "disallowParallelism", "distance", "probingColumn", "query", "Lorg/vitrivr/cottontail/core/values/PublicValue;", "Lorg/vitrivr/cottontail/client/language/basics/Distances;", "name", "distinct", "column", "alias", "expression", "Lorg/vitrivr/cottontail/client/language/basics/expression/Expression;", "exists", "from", "fulltext", "knn", "k", "", "weight", "", "limit", "", "limitParallelism", "max", "mean", "min", "order", "direction", "Lorg/vitrivr/cottontail/client/language/basics/Direction;", "queryId", "sample", "probability", "", "seed", "select", "skip", "txId", "useIndex", "index", "useIndexType", "type", "usePolicy", "wio", "wcpu", "wmem", "wq", "where", "predicate", "Lorg/vitrivr/cottontail/client/language/basics/predicate/Predicate;", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Query.kt\norg/vitrivr/cottontail/client/language/dql/Query\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n1#2:458\n*E\n"})
public final class Query
extends LanguageFeature {
    @NotNull
    private final CottontailGrpc.QueryMessage.Builder builder;

    public Query(@NotNull Name.EntityName entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        CottontailGrpc.QueryMessage.Builder builder = CottontailGrpc.QueryMessage.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        this.builder = builder;
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(NameExtensionsKt.proto(entity))));
    }

    public Query(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this(Name.EntityName.Companion.parse(entity));
    }

    @NotNull
    public final CottontailGrpc.QueryMessage.Builder getBuilder() {
        return this.builder;
    }

    @Override
    @NotNull
    public Query txId(long txId) {
        this.builder.getMetadataBuilder().setTransactionId(txId);
        return this;
    }

    @Override
    @NotNull
    public Query queryId(@NotNull String queryId) {
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        this.builder.getMetadataBuilder().setQueryId(queryId);
        return this;
    }

    @NotNull
    public final Query select(@NotNull String column, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.select(new Column(column), alias);
    }

    public static /* synthetic */ Query select$default(Query query, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return query.select(string, string2);
    }

    @NotNull
    public final Query select(@NotNull Expression expression, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.SELECT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT);
        }
        CottontailGrpc.Projection.ProjectionElement.Builder element = builder.addElementsBuilder();
        element.setExpression(expression.toGrpc());
        if (alias != null) {
            element.setAlias(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(alias)));
        }
        return this;
    }

    public static /* synthetic */ Query select$default(Query query, Expression expression, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return query.select(expression, string);
    }

    @NotNull
    public final Query distinct(@NotNull String column, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.distinct(new Column(column), alias);
    }

    public static /* synthetic */ Query distinct$default(Query query, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return query.distinct(string, string2);
    }

    @NotNull
    public final Query distinct(@NotNull Expression expression, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.SELECT_DISTINCT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT_DISTINCT);
        }
        CottontailGrpc.Projection.ProjectionElement.Builder element = builder.addElementsBuilder();
        element.setExpression(expression.toGrpc());
        if (alias != null) {
            element.setAlias(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(alias)));
        }
        return this;
    }

    public static /* synthetic */ Query distinct$default(Query query, Expression expression, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return query.distinct(expression, string);
    }

    @NotNull
    public final Query count() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.COUNT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.COUNT);
        }
        builder.addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setExpression(CottontailGrpc.Expression.newBuilder().setColumn(NameExtensionsKt.proto(Name.ColumnName.Companion.getALL_COLUMNS()))));
        return this;
    }

    @NotNull
    public final Query mean() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.MEAN) {
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.MEAN);
        }
        return this;
    }

    @NotNull
    public final Query min() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.MIN) {
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.MIN);
        }
        return this;
    }

    @NotNull
    public final Query max() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.MAX) {
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.MAX);
        }
        return this;
    }

    @NotNull
    public final Query exists() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.EXISTS) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.EXISTS);
        }
        builder.addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setExpression(CottontailGrpc.Expression.newBuilder().setColumn(NameExtensionsKt.proto(Name.ColumnName.Companion.getALL_COLUMNS()))));
        return this;
    }

    @NotNull
    public final Query from(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(NameExtensionsKt.proto(Name.EntityName.Companion.parse(entity)))));
        return this;
    }

    @NotNull
    public final Query sample(@NotNull String entity, float probability, long seed) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(0.0f <= probability ? probability <= 1.0f : false)) {
            boolean bl = false;
            String string = "Probability value must be between 0.0 and 1.0f but is " + probability + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setSample(CottontailGrpc.Sample.newBuilder().setEntity(NameExtensionsKt.proto(Name.EntityName.Companion.parse(entity))).setSeed(seed).setProbability(probability)));
        return this;
    }

    public static /* synthetic */ Query sample$default(Query query, String string, float f, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = System.currentTimeMillis();
        }
        return query.sample(string, f, l);
    }

    @NotNull
    public final Query from(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (!(!Intrinsics.areEqual((Object)query, (Object)this))) {
            boolean bl = false;
            String string = "SUB-SELECT query cannot specify itself.";
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setQuery(query.builder.getQueryBuilder()));
        return this;
    }

    @NotNull
    public final Query where(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        this.builder.getQueryBuilder().clearWhere();
        this.builder.getQueryBuilder().getWhereBuilder().setPredicate(predicate.toGrpc());
        return this;
    }

    @Deprecated(message="Deprecated since version 0.13.0; use nns() function instead!", replaceWith=@ReplaceWith(expression="nns", imports={}))
    @NotNull
    public final Query knn(@NotNull String column, int k, @NotNull String distance, @NotNull PublicValue query, @Nullable Object weight) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (weight != null) {
            throw new UnsupportedOperationException("Weighted NNS is no longer supported by Cottontail DB. Use weighted distance function with respective arguments instead.");
        }
        String string = distance.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        this.distance(column, query, Distances.valueOf(string), "distance");
        this.builder.getQueryBuilder().getOrderBuilder().addComponents(CottontailGrpc.Order.Component.newBuilder().setColumn(CottontailGrpc.ColumnName.newBuilder().setName("distance")).setDirection(Direction.ASC.toGrpc()));
        this.builder.getQueryBuilder().setLimit(k);
        return this;
    }

    public static /* synthetic */ Query knn$default(Query query, String string, int n, String string2, PublicValue publicValue, Object object, int n2, Object object2) {
        if ((n2 & 0x10) != 0) {
            object = null;
        }
        return query.knn(string, n, string2, publicValue, object);
    }

    @NotNull
    public final Query distance(@NotNull String probingColumn, @NotNull PublicValue query, @NotNull Distances distance, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)probingColumn, (String)"probingColumn");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)distance), (String)"distance");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CottontailGrpc.Function.Builder distanceFunction = CottontailGrpc.Function.newBuilder().setName(distance.toGrpc()).addArguments(CottontailGrpc.Expression.newBuilder().setColumn(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(probingColumn)))).addArguments(CottontailGrpc.Expression.newBuilder().setLiteral(query.toGrpc()));
        this.builder.getQueryBuilder().getProjectionBuilder().addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setAlias(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(name))).setExpression(CottontailGrpc.Expression.newBuilder().setFunction(distanceFunction)));
        return this;
    }

    @NotNull
    public final Query fulltext(@NotNull String probingColumn, @NotNull String query, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)probingColumn, (String)"probingColumn");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CottontailGrpc.Function.Builder fulltextFunction = CottontailGrpc.Function.newBuilder().setName(CottontailGrpc.FunctionName.newBuilder().setName("fulltext")).addArguments(CottontailGrpc.Expression.newBuilder().setColumn(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(probingColumn)))).addArguments(CottontailGrpc.Expression.newBuilder().setLiteral(CottontailGrpc.Literal.newBuilder().setStringData(query)));
        this.builder.getQueryBuilder().getProjectionBuilder().addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setAlias(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(name))).setExpression(CottontailGrpc.Expression.newBuilder().setFunction(fulltextFunction)));
        return this;
    }

    @NotNull
    public final Query order(@NotNull String column, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        CottontailGrpc.Order.Builder builder = this.builder.getQueryBuilder().getOrderBuilder();
        CottontailGrpc.Order.Component.Builder cBuilder = builder.addComponentsBuilder();
        cBuilder.setColumn(NameExtensionsKt.proto(Name.ColumnName.Companion.parse(column)));
        cBuilder.setDirection(direction.toGrpc());
        return this;
    }

    @NotNull
    public final Query skip(long skip) {
        this.builder.getQueryBuilder().setSkip(skip);
        return this;
    }

    @NotNull
    public final Query limit(long limit) {
        this.builder.getQueryBuilder().setLimit(limit);
        return this;
    }

    @NotNull
    public final Query clear() {
        this.builder.getQueryBuilder().clear();
        return this;
    }

    @NotNull
    public final Query disallowIndex() {
        this.builder.getMetadataBuilder().getIndexHintBuilder().setDisallow(true);
        return this;
    }

    @NotNull
    public final Query useIndex(@NotNull String index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        CottontailGrpc.IndexName parsed = NameExtensionsKt.proto(Name.IndexName.Companion.parse(index));
        this.builder.getMetadataBuilder().getIndexHintBuilder().setName(parsed.getName());
        return this;
    }

    @NotNull
    public final Query useIndexType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        CottontailGrpc.IndexType parsed = CottontailGrpc.IndexType.valueOf(string);
        this.builder.getMetadataBuilder().getIndexHintBuilder().setType(parsed);
        return this;
    }

    @NotNull
    public final Query usePolicy(float wio, float wcpu, float wmem, float wq) {
        if (!(0.0f <= wio ? wio <= 1.0f : false)) {
            boolean $i$a$-require-Query$usePolicy$52 = false;
            String $i$a$-require-Query$usePolicy$52 = "Cost policy weights must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException($i$a$-require-Query$usePolicy$52.toString());
        }
        if (!(0.0f <= wcpu ? wcpu <= 1.0f : false)) {
            boolean $i$a$-require-Query$usePolicy$62 = false;
            String $i$a$-require-Query$usePolicy$62 = "Cost policy weights must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException($i$a$-require-Query$usePolicy$62.toString());
        }
        if (!(0.0f <= wmem ? wmem <= 1.0f : false)) {
            boolean $i$a$-require-Query$usePolicy$72 = false;
            String $i$a$-require-Query$usePolicy$72 = "Cost policy weights must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException($i$a$-require-Query$usePolicy$72.toString());
        }
        if (!(0.0f <= wq ? wq <= 1.0f : false)) {
            boolean bl = false;
            String string = "Cost policy weights must be in the range [0.0, 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.getMetadataBuilder().getPolicyHintBuilder().setWeightIo(wio).setWeightCpu(wcpu).setWeightMemory(wmem).setWeightAccuracy(wq);
        return this;
    }

    public static /* synthetic */ Query usePolicy$default(Query query, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n & 4) != 0) {
            f3 = 1.0f;
        }
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        return query.usePolicy(f, f2, f3, f4);
    }

    @NotNull
    public final Query disallowOptimisation() {
        this.builder.getMetadataBuilder().setNoOptimiseHint(true);
        return this;
    }

    @NotNull
    public final Query disallowParallelism() {
        return this.limitParallelism(1);
    }

    @NotNull
    public final Query limitParallelism(int max) {
        this.builder.getMetadataBuilder().getParallelHintBuilder().setLimit(max);
        return this;
    }
}

