/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.tuple;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.MutableTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.core.values.ByteValue;
import org.vitrivr.cottontail.core.values.DateValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.FloatValue;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.core.values.ShortValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B)\b\u0016\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB5\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020 H\u0096\u0002J\u0014\u0010!\u001a\u00020\u001b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\u0014\u0010#\u001a\u00020 2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020$H\u0016J\u001b\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0096\u0002J\u0010\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0'H\u0016R \u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000bX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001b\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000b\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/core/tuple/StandaloneTuple;", "Lorg/vitrivr/cottontail/core/tuple/MutableTuple;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "column", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "(JLorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/core/types/Value;)V", "columns", "", "values", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;[Lorg/vitrivr/cottontail/core/types/Value;)V", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getTupleId", "()J", "setTupleId", "(J)V", "getValues", "()[Lorg/vitrivr/cottontail/core/types/Value;", "[Lorg/vitrivr/cottontail/core/types/Value;", "copy", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "equals", "", "other", "", "get", "index", "", "has", "hashCode", "indexOf", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "set", "", "", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nStandaloneTuple.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandaloneTuple.kt\norg/vitrivr/cottontail/core/tuple/StandaloneTuple\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n1#2:120\n1627#3,6:121\n*S KotlinDebug\n*F\n+ 1 StandaloneTuple.kt\norg/vitrivr/cottontail/core/tuple/StandaloneTuple\n*L\n67#1:121,6\n*E\n"})
public final class StandaloneTuple
implements MutableTuple {
    private long tupleId;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Value[] values;

    public StandaloneTuple(long tupleId, @NotNull ColumnDef<?>[] columns, @NotNull Value[] values) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tupleId = tupleId;
        this.columns = columns;
        this.values = values;
        if (!(this.getColumns().length == this.values.length)) {
            boolean bl = false;
            String string = "Number of values and number of columns must be the same.";
            throw new IllegalArgumentException(string.toString());
        }
        for (Pair pair : ArraysKt.zip((Object[])this.getColumns(), (Object[])this.values)) {
            ColumnDef c = (ColumnDef)pair.component1();
            Value v = (Value)pair.component2();
            if (v == null && c.getNullable() || v != null && Intrinsics.areEqual(c.getType(), v.getType())) continue;
            boolean bl = false;
            String string = "Value " + v + " is incompatible with column " + c + ".";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ StandaloneTuple(long l, ColumnDef[] columnDefArray, Value[] valueArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            valueArray = new Value[columnDefArray.length];
        }
        this(l, columnDefArray, valueArray);
    }

    @Override
    public long getTupleId() {
        return this.tupleId;
    }

    public void setTupleId(long l) {
        this.tupleId = l;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public final Value[] getValues() {
        return this.values;
    }

    public StandaloneTuple(long tupleId, @NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Object[] objectArray = new ColumnDef[]{column};
        ColumnDef[] columnDefArray = objectArray;
        objectArray = new Value[]{value};
        this(tupleId, columnDefArray, (Value[])objectArray);
    }

    @Override
    @NotNull
    public Tuple copy() {
        long l = this.getTupleId();
        ColumnDef<?>[] columnDefArray = this.getColumns();
        Value[] valueArray = Arrays.copyOf(this.values, this.values.length);
        Intrinsics.checkNotNullExpressionValue((Object)valueArray, (String)"copyOf(...)");
        return new StandaloneTuple(l, columnDefArray, valueArray);
    }

    @Override
    public boolean has(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.contains((Object[])this.getColumns(), column);
    }

    @Override
    public int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.getColumns(), column);
    }

    @Override
    public int indexOf(@NotNull Name.ColumnName column) {
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            ColumnDef<?>[] $this$indexOfFirst$iv = this.getColumns();
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length;
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                ColumnDef<?> it = $this$indexOfFirst$iv[index$iv];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)column)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    @Override
    @Nullable
    public Value get(int index) {
        return this.values[index];
    }

    @Override
    @NotNull
    public List<Value> values() {
        return ArraysKt.toList((Object[])this.values);
    }

    @Override
    public void set(int index, @Nullable Value value) {
        ColumnDef<?> column = this.getColumns()[index];
        if (!(value == null && column.getNullable() || value != null && Intrinsics.areEqual(value.getType(), column.getType()))) {
            boolean bl = false;
            String string = "Provided value " + value + " is incompatible with column " + this.getColumns()[index] + ".";
            throw new IllegalArgumentException(string.toString());
        }
        this.values[index] = value;
    }

    public boolean equals(@Nullable Object other) {
        Object[] objectArray;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Tuple)) {
            return false;
        }
        if (this.getTupleId() != ((Tuple)other).getTupleId()) {
            return false;
        }
        Object[] objectArray2 = this.getColumns();
        if (ArraysKt.contentDeepEquals((Object[])objectArray2, (Object[])(objectArray = ((Tuple)other).getColumns()))) {
            return false;
        }
        int n = this.getColumns().length;
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)this.get(i), (Object)((Tuple)other).get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Long.hashCode(this.getTupleId());
        result = 31 * result + this.getColumns().hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public int indexOf(@NotNull String column) {
        return MutableTuple.DefaultImpls.indexOf((MutableTuple)this, column);
    }

    @Override
    @Nullable
    public Value get(@NotNull ColumnDef<?> column) {
        return MutableTuple.DefaultImpls.get((MutableTuple)this, column);
    }

    @Override
    @Nullable
    public Value get(@NotNull Name.ColumnName column) {
        return MutableTuple.DefaultImpls.get((MutableTuple)this, column);
    }

    @Override
    @Nullable
    public Value get(@NotNull String column) {
        return MutableTuple.DefaultImpls.get((MutableTuple)this, column);
    }

    @Override
    public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
        MutableTuple.DefaultImpls.set((MutableTuple)this, column, value);
    }

    @Override
    public void set(@NotNull Name.ColumnName column, @Nullable Value value) {
        MutableTuple.DefaultImpls.set((MutableTuple)this, column, value);
    }

    @Override
    public void set(@NotNull String column, @Nullable Value value) {
        MutableTuple.DefaultImpls.set((MutableTuple)this, column, value);
    }

    @Override
    public int getSize() {
        return MutableTuple.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public Name.ColumnName nameForIndex(int index) {
        return MutableTuple.DefaultImpls.nameForIndex(this, index);
    }

    @Override
    @NotNull
    public String fqnForIndex(int index) {
        return MutableTuple.DefaultImpls.fqnForIndex(this, index);
    }

    @Override
    @NotNull
    public String simpleNameForIndex(int index) {
        return MutableTuple.DefaultImpls.simpleNameForIndex(this, index);
    }

    @Override
    @NotNull
    public List<Types<?>> types() {
        return MutableTuple.DefaultImpls.types(this);
    }

    @Override
    @NotNull
    public Types<?> type(int index) {
        return MutableTuple.DefaultImpls.type((MutableTuple)this, index);
    }

    @Override
    @NotNull
    public Types<?> type(@NotNull Name.ColumnName name) {
        return MutableTuple.DefaultImpls.type((MutableTuple)this, name);
    }

    @Override
    @NotNull
    public Types<?> type(@NotNull String name) {
        return MutableTuple.DefaultImpls.type((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public BooleanValue asBooleanValue-1OalM1U(int index) {
        return MutableTuple.DefaultImpls.asBooleanValue-1OalM1U((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public BooleanValue asBooleanValue-1OalM1U(@NotNull String name) {
        return MutableTuple.DefaultImpls.asBooleanValue-1OalM1U((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Boolean asBoolean(int index) {
        return MutableTuple.DefaultImpls.asBoolean((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Boolean asBoolean(@NotNull String name) {
        return MutableTuple.DefaultImpls.asBoolean((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public ByteValue asByteValue-NuVS9b8(int index) {
        return MutableTuple.DefaultImpls.asByteValue-NuVS9b8((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public ByteValue asByteValue-NuVS9b8(@NotNull String name) {
        return MutableTuple.DefaultImpls.asByteValue-NuVS9b8((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Byte asByte(int index) {
        return MutableTuple.DefaultImpls.asByte((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Byte asByte(@NotNull String name) {
        return MutableTuple.DefaultImpls.asByte((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public ShortValue asShortValue-f20-H9w(int index) {
        return MutableTuple.DefaultImpls.asShortValue-f20-H9w((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public ShortValue asShortValue-f20-H9w(@NotNull String name) {
        return MutableTuple.DefaultImpls.asShortValue-f20-H9w((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Short asShort(int index) {
        return MutableTuple.DefaultImpls.asShort((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Short asShort(@NotNull String name) {
        return MutableTuple.DefaultImpls.asShort((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public IntValue asIntValue-yZMVbvg(int index) {
        return MutableTuple.DefaultImpls.asIntValue-yZMVbvg((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public IntValue asIntValue-yZMVbvg(@NotNull String name) {
        return MutableTuple.DefaultImpls.asIntValue-yZMVbvg((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Integer asInt(int index) {
        return MutableTuple.DefaultImpls.asInt((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Integer asInt(@NotNull String name) {
        return MutableTuple.DefaultImpls.asInt((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public LongValue asLongValue-CNcmMjI(int index) {
        return MutableTuple.DefaultImpls.asLongValue-CNcmMjI((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public LongValue asLongValue-CNcmMjI(@NotNull String name) {
        return MutableTuple.DefaultImpls.asLongValue-CNcmMjI((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Long asLong(int index) {
        return MutableTuple.DefaultImpls.asLong((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Long asLong(@NotNull String name) {
        return MutableTuple.DefaultImpls.asLong((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public FloatValue asFloatValue-z8PsB-c(int index) {
        return MutableTuple.DefaultImpls.asFloatValue-z8PsB-c((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public FloatValue asFloatValue-z8PsB-c(@NotNull String name) {
        return MutableTuple.DefaultImpls.asFloatValue-z8PsB-c((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Float asFloat(int index) {
        return MutableTuple.DefaultImpls.asFloat((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Float asFloat(@NotNull String name) {
        return MutableTuple.DefaultImpls.asFloat((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public DoubleValue asDoubleValue-qx1rvJE(int index) {
        return MutableTuple.DefaultImpls.asDoubleValue-qx1rvJE((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public DoubleValue asDoubleValue-qx1rvJE(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDoubleValue-qx1rvJE((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Double asDouble(int index) {
        return MutableTuple.DefaultImpls.asDouble((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Double asDouble(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDouble((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public boolean[] asBooleanVectorValue-iuwxMNg(int index) {
        return MutableTuple.DefaultImpls.asBooleanVectorValue-iuwxMNg((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public boolean[] asBooleanVectorValue-iuwxMNg(@NotNull String name) {
        return MutableTuple.DefaultImpls.asBooleanVectorValue-iuwxMNg((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public boolean[] asBooleanVector(int index) {
        return MutableTuple.DefaultImpls.asBooleanVector((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public boolean[] asBooleanVector(@NotNull String name) {
        return MutableTuple.DefaultImpls.asBooleanVector((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public int[] asIntVectorValue-Q8dlA04(int index) {
        return MutableTuple.DefaultImpls.asIntVectorValue-Q8dlA04((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public int[] asIntVectorValue-Q8dlA04(@NotNull String name) {
        return MutableTuple.DefaultImpls.asIntVectorValue-Q8dlA04((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public int[] asIntVector(int index) {
        return MutableTuple.DefaultImpls.asIntVector((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public int[] asIntVector(@NotNull String name) {
        return MutableTuple.DefaultImpls.asIntVector((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public long[] asLongVectorValue-2nsrhKc(int index) {
        return MutableTuple.DefaultImpls.asLongVectorValue-2nsrhKc((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public long[] asLongVectorValue-2nsrhKc(@NotNull String name) {
        return MutableTuple.DefaultImpls.asLongVectorValue-2nsrhKc((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public long[] asLongVector(int index) {
        return MutableTuple.DefaultImpls.asLongVector((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public long[] asLongVector(@NotNull String name) {
        return MutableTuple.DefaultImpls.asLongVector((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public float[] asFloatVectorValue-JSSEiYU(int index) {
        return MutableTuple.DefaultImpls.asFloatVectorValue-JSSEiYU((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public float[] asFloatVectorValue-JSSEiYU(@NotNull String name) {
        return MutableTuple.DefaultImpls.asFloatVectorValue-JSSEiYU((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public float[] asFloatVector(int index) {
        return MutableTuple.DefaultImpls.asFloatVector((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public float[] asFloatVector(@NotNull String name) {
        return MutableTuple.DefaultImpls.asFloatVector((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public double[] asDoubleVectorValue-4MSoHV4(int index) {
        return MutableTuple.DefaultImpls.asDoubleVectorValue-4MSoHV4((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public double[] asDoubleVectorValue-4MSoHV4(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDoubleVectorValue-4MSoHV4((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public double[] asDoubleVector(int index) {
        return MutableTuple.DefaultImpls.asDoubleVector((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public double[] asDoubleVector(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDoubleVector((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public String asStringValue-20uZBUg(int index) {
        return MutableTuple.DefaultImpls.asStringValue-20uZBUg((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public String asStringValue-20uZBUg(@NotNull String name) {
        return MutableTuple.DefaultImpls.asStringValue-20uZBUg((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public UUID asUuidValue-I4cHxZI(int index) {
        return MutableTuple.DefaultImpls.asUuidValue-I4cHxZI((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public UUID asUuidValue-I4cHxZI(@NotNull String name) {
        return MutableTuple.DefaultImpls.asUuidValue-I4cHxZI((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public String asString(int index) {
        return MutableTuple.DefaultImpls.asString((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public String asString(@NotNull String name) {
        return MutableTuple.DefaultImpls.asString((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public DateValue asDateValue-fSwC0cY(int index) {
        return MutableTuple.DefaultImpls.asDateValue-fSwC0cY((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public DateValue asDateValue-fSwC0cY(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDateValue-fSwC0cY((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public Date asDate(int index) {
        return MutableTuple.DefaultImpls.asDate((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public Date asDate(@NotNull String name) {
        return MutableTuple.DefaultImpls.asDate((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public byte[] asByteStringValue-vFcFNtk(int index) {
        return MutableTuple.DefaultImpls.asByteStringValue-vFcFNtk((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public byte[] asByteStringValue-vFcFNtk(@NotNull String name) {
        return MutableTuple.DefaultImpls.asByteStringValue-vFcFNtk((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public byte[] asByteArray(int index) {
        return MutableTuple.DefaultImpls.asByteArray(this, index);
    }

    @Override
    @Nullable
    public float[] asComplex32Value-PGJHCcI(int index) {
        return MutableTuple.DefaultImpls.asComplex32Value-PGJHCcI((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public float[] asComplex32Value-PGJHCcI(@NotNull String name) {
        return MutableTuple.DefaultImpls.asComplex32Value-PGJHCcI((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public double[] asComplex64Value-9by7ZfM(int index) {
        return MutableTuple.DefaultImpls.asComplex64Value-9by7ZfM((MutableTuple)this, index);
    }

    @Override
    @Nullable
    public double[] asComplex64Value-9by7ZfM(@NotNull String name) {
        return MutableTuple.DefaultImpls.asComplex64Value-9by7ZfM((MutableTuple)this, name);
    }

    @Override
    @Nullable
    public float[] asComplex32VectorValue-mz4DNGM(int index) {
        return MutableTuple.DefaultImpls.asComplex32VectorValue-mz4DNGM(this, index);
    }

    @Override
    @Nullable
    public double[] asComplex64VectorValue-JfuYN9c(int index) {
        return MutableTuple.DefaultImpls.asComplex64VectorValue-JfuYN9c(this, index);
    }
}

