/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.serialization.SerializationExtensionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016R\u001d\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/serialization/TupleSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)V", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "elementSerializers", "", "Lorg/vitrivr/cottontail/core/values/PublicValue;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nTupleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TupleSerializer.kt\norg/vitrivr/cottontail/serialization/TupleSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n11065#2:70\n11400#2,3:71\n11065#2:74\n11400#2,3:75\n*S KotlinDebug\n*F\n+ 1 TupleSerializer.kt\norg/vitrivr/cottontail/serialization/TupleSerializer\n*L\n26#1:70\n26#1:71,3\n33#1:74\n33#1:75,3\n*E\n"})
public final class TupleSerializer
implements KSerializer<Tuple> {
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final List<KSerializer<PublicValue>> elementSerializers;

    public TupleSerializer(@NotNull ColumnDef<?>[] columns) {
        ColumnDef<?> it;
        Collection collection;
        ColumnDef<?>[] $this$mapTo$iv$iv;
        ColumnDef<?>[] $this$map$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        ColumnDef<?>[] columnDefArray = this.columns = columns;
        TupleSerializer tupleSerializer = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (ColumnDef<?> item$iv$iv : $this$mapTo$iv$iv) {
            void var10_11 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        tupleSerializer.descriptor = SerialDescriptorsKt.buildClassSerialDescriptor((String)("Tuple[" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]"), (SerialDescriptor[])new SerialDescriptor[0], (Function1)((Function1)new Function1<ClassSerialDescriptorBuilder, Unit>(this){
            final /* synthetic */ TupleSerializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassSerialDescriptorBuilder $this$buildClassSerialDescriptor) {
                Intrinsics.checkNotNullParameter((Object)$this$buildClassSerialDescriptor, (String)"$this$buildClassSerialDescriptor");
                for (ColumnDef<?> c : this.this$0.getColumns()) {
                    ClassSerialDescriptorBuilder.element$default((ClassSerialDescriptorBuilder)$this$buildClassSerialDescriptor, (String)c.getName().getSimple(), (SerialDescriptor)SerializationExtensionKt.serializer(c.getType()).getDescriptor(), null, (boolean)false, (int)12, null);
                }
            }
        }));
        $this$map$iv = this.columns;
        tupleSerializer = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            ColumnDef<?> item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SerializationExtensionKt.serializer(it.getType()));
        }
        tupleSerializer.elementSerializers = (List)destination$iv$iv;
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public Tuple deserialize(@NotNull Decoder decoder) {
        int index;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        int n = 0;
        int n2 = this.columns.length;
        Value[] valueArray = new Value[n2];
        while (n < n2) {
            int n3 = n++;
            valueArray[n3] = null;
        }
        Value[] values = valueArray;
        CompositeDecoder dec = decoder.beginStructure(this.getDescriptor());
        while ((index = dec.decodeElementIndex(this.getDescriptor())) != -1) {
            values[index] = CompositeDecoder.DefaultImpls.decodeNullableSerializableElement$default((CompositeDecoder)dec, (SerialDescriptor)this.getDescriptor(), (int)index, (DeserializationStrategy)((DeserializationStrategy)this.elementSerializers.get(index)), null, (int)8, null);
        }
        dec.endStructure(this.getDescriptor());
        return new StandaloneTuple(0L, this.columns, values);
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Tuple value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CompositeEncoder enc = encoder.beginStructure(this.getDescriptor());
        int index = 0;
        for (Pair pair : CollectionsKt.zip((Iterable)this.elementSerializers, (Iterable)value.values())) {
            KSerializer s = (KSerializer)pair.component1();
            Value v = (Value)pair.component2();
            enc.encodeNullableSerializableElement(this.getDescriptor(), index++, (SerializationStrategy)s, (Object)(v instanceof PublicValue ? (PublicValue)v : null));
        }
        enc.endStructure(this.getDescriptor());
    }
}

