/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.BooleanCompanionObject;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.ShortCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.DescriptionExtensionsKt;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.core.values.ByteStringValue;
import org.vitrivr.cottontail.core.values.ByteValue;
import org.vitrivr.cottontail.core.values.Complex32Value;
import org.vitrivr.cottontail.core.values.Complex32VectorValue;
import org.vitrivr.cottontail.core.values.Complex64Value;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.core.values.DateValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.core.values.ShortValue;
import org.vitrivr.cottontail.core.values.ShortVectorValue;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.core.values.UuidValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016R\u001d\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/serialization/TupleSimpleSerializer;", "Lkotlinx/serialization/KSerializer;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)V", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "types", "", "Lorg/vitrivr/cottontail/core/types/Types;", "Lorg/vitrivr/cottontail/core/types/Value;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nTupleSimpleSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TupleSimpleSerializer.kt\norg/vitrivr/cottontail/serialization/TupleSimpleSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Encoding.kt\nkotlinx/serialization/encoding/EncodingKt\n*L\n1#1,112:1\n11065#2:113\n11400#2,3:114\n11065#2:117\n11400#2,3:118\n37#3,2:121\n475#4,4:123\n*S KotlinDebug\n*F\n+ 1 TupleSimpleSerializer.kt\norg/vitrivr/cottontail/serialization/TupleSimpleSerializer\n*L\n28#1:113\n28#1:114,3\n44#1:117\n44#1:118,3\n85#1:121,2\n95#1:123,4\n*E\n"})
public final class TupleSimpleSerializer
implements KSerializer<Tuple> {
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final List<Types<? extends Value>> types;

    public TupleSimpleSerializer(@NotNull ColumnDef<?>[] columns) {
        ColumnDef<?> it;
        Collection collection;
        ColumnDef<?>[] $this$mapTo$iv$iv;
        ColumnDef<?>[] $this$map$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        ColumnDef<?>[] columnDefArray = this.columns = columns;
        TupleSimpleSerializer tupleSimpleSerializer = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (ColumnDef<?> item$iv$iv : $this$mapTo$iv$iv) {
            void var10_11 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        tupleSimpleSerializer.descriptor = SerialDescriptorsKt.buildClassSerialDescriptor((String)("SimpleTuple[" + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]"), (SerialDescriptor[])new SerialDescriptor[0], (Function1)((Function1)new Function1<ClassSerialDescriptorBuilder, Unit>(this){
            final /* synthetic */ TupleSimpleSerializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassSerialDescriptorBuilder $this$buildClassSerialDescriptor) {
                Intrinsics.checkNotNullParameter((Object)$this$buildClassSerialDescriptor, (String)"$this$buildClassSerialDescriptor");
                for (ColumnDef<?> c : this.this$0.getColumns()) {
                    Types<?> types;
                    ClassSerialDescriptorBuilder.element$default((ClassSerialDescriptorBuilder)$this$buildClassSerialDescriptor, (String)c.getName().getSimple(), (SerialDescriptor)(Intrinsics.areEqual(types = c.getType(), (Object)Types.Boolean.INSTANCE) ? BuiltinSerializersKt.serializer((BooleanCompanionObject)BooleanCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE) ? BuiltinSerializersKt.serializer((ByteCompanionObject)ByteCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE) ? BuiltinSerializersKt.serializer((DoubleCompanionObject)DoubleCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE) ? BuiltinSerializersKt.serializer((FloatCompanionObject)FloatCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE) ? BuiltinSerializersKt.serializer((IntCompanionObject)IntCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE) ? BuiltinSerializersKt.serializer((LongCompanionObject)LongCompanionObject.INSTANCE).getDescriptor() : (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE) ? BuiltinSerializersKt.serializer((ShortCompanionObject)ShortCompanionObject.INSTANCE).getDescriptor() : BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor()))))))), null, (boolean)false, (int)12, null);
                }
            }
        }));
        $this$map$iv = this.columns;
        tupleSimpleSerializer = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n = $this$mapTo$iv$iv.length;
        for (int i = 0; i < n; ++i) {
            ColumnDef<?> item$iv$iv;
            it = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        tupleSimpleSerializer.types = (List)destination$iv$iv;
    }

    @NotNull
    public final ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public Tuple deserialize(@NotNull Decoder decoder) {
        int index;
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        ArrayList<BooleanValue> list = new ArrayList<BooleanValue>(this.columns.length);
        CompositeDecoder dec = decoder.beginStructure(this.getDescriptor());
        while ((index = dec.decodeElementIndex(this.getDescriptor())) != -1) {
            PublicValue publicValue;
            Types<? extends Value> types = this.types.get(index);
            if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
                publicValue = BooleanValue.box-impl(BooleanValue.constructor-impl(dec.decodeBooleanElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
                publicValue = ByteValue.box-impl(ByteValue.constructor-impl(dec.decodeByteElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
                publicValue = DoubleValue.box-impl(DoubleValue.constructor-impl(dec.decodeDoubleElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
                publicValue = FloatValue.box-impl(FloatValue.constructor-impl(dec.decodeFloatElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
                publicValue = IntValue.box-impl(IntValue.constructor-impl(dec.decodeIntElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
                publicValue = LongValue.box-impl(LongValue.constructor-impl(dec.decodeLongElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
                publicValue = ShortValue.box-impl(ShortValue.constructor-impl(dec.decodeShortElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
                publicValue = StringValue.box-impl(StringValue.constructor-impl(dec.decodeStringElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Uuid.INSTANCE)) {
                UUID uUID = UUID.fromString(dec.decodeStringElement(this.getDescriptor(), index));
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                publicValue = UuidValue.box-impl(UuidValue.constructor-impl(uUID));
            } else if (Intrinsics.areEqual(types, (Object)Types.ByteString.INSTANCE)) {
                publicValue = ByteStringValue.box-impl(ByteStringValue.Companion.fromBase64-4tEES3k(dec.decodeStringElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
                publicValue = DateValue.box-impl(DateValue.constructor-impl(dec.decodeLongElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
                publicValue = Complex32Value.box-impl(DescriptionExtensionsKt.parseComplex32Description(dec.decodeStringElement(this.getDescriptor(), index)));
            } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
                publicValue = Complex64Value.box-impl(DescriptionExtensionsKt.parseComplex64Description(dec.decodeStringElement(this.getDescriptor(), index)));
            } else if (types instanceof Types.BooleanVector) {
                publicValue = BooleanVectorValue.box-impl(DescriptionExtensionsKt.parseBooleanVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.DoubleVector) {
                publicValue = DoubleVectorValue.box-impl(DescriptionExtensionsKt.parseDoubleVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.HalfVector ? true : types instanceof Types.FloatVector) {
                publicValue = FloatVectorValue.box-impl(DescriptionExtensionsKt.parseFloatVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.IntVector) {
                publicValue = IntVectorValue.box-impl(DescriptionExtensionsKt.parseIntVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.LongVector) {
                publicValue = LongVectorValue.box-impl(DescriptionExtensionsKt.parseLongVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.Complex32Vector) {
                publicValue = Complex32VectorValue.box-impl(DescriptionExtensionsKt.parseComplex32VectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.Complex64Vector) {
                publicValue = Complex64VectorValue.box-impl(DescriptionExtensionsKt.parseComplex64VectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else if (types instanceof Types.ShortVector) {
                publicValue = ShortVectorValue.box-impl(DescriptionExtensionsKt.parseShortVectorValue$default(dec.decodeStringElement(this.getDescriptor(), index), null, 2, null));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            BooleanValue value = publicValue;
            list.add(value);
        }
        dec.endStructure(this.getDescriptor());
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new StandaloneTuple(0L, this.columns, thisCollection$iv.toArray(new Value[0]));
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(@NotNull Encoder encoder, @NotNull Tuple value) {
        void $this$encodeStructure$iv;
        CompositeEncoder composite$iv;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Encoder encoder2 = encoder;
        SerialDescriptor descriptor$iv = this.getDescriptor();
        boolean $i$f$encodeStructure = false;
        CompositeEncoder $this$serialize_u24lambda_u242 = composite$iv = $this$encodeStructure$iv.beginStructure(descriptor$iv);
        boolean bl = false;
        int index = 0;
        for (Value v : value.values()) {
            PublicValue cast = v instanceof PublicValue ? (PublicValue)v : null;
            if (cast == null) continue;
            if (cast instanceof BooleanValue) {
                $this$serialize_u24lambda_u242.encodeBooleanElement(this.getDescriptor(), index++, ((BooleanValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof ByteValue) {
                $this$serialize_u24lambda_u242.encodeByteElement(this.getDescriptor(), index++, ((ByteValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof DoubleValue) {
                $this$serialize_u24lambda_u242.encodeDoubleElement(this.getDescriptor(), index++, ((DoubleValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof FloatValue) {
                $this$serialize_u24lambda_u242.encodeFloatElement(this.getDescriptor(), index++, ((FloatValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof IntValue) {
                $this$serialize_u24lambda_u242.encodeIntElement(this.getDescriptor(), index++, ((IntValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof LongValue) {
                $this$serialize_u24lambda_u242.encodeLongElement(this.getDescriptor(), index++, ((LongValue)cast).unbox-impl());
                continue;
            }
            if (cast instanceof ShortValue) {
                $this$serialize_u24lambda_u242.encodeShortElement(this.getDescriptor(), index++, ((ShortValue)cast).unbox-impl());
                continue;
            }
            $this$serialize_u24lambda_u242.encodeStringElement(this.getDescriptor(), index++, DescriptionExtensionsKt.toDescription$default(cast, null, 0, 3, null));
        }
        composite$iv.endStructure(descriptor$iv);
    }
}

