/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.client.iterators;

import io.grpc.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.core.DataExtensionsKt;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.tuple.StandaloneTuple;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.core.values.ByteValue;
import org.vitrivr.cottontail.core.values.DateValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.FloatValue;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.core.values.ShortValue;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010$\u001a\u00020%H\u0016J\t\u0010&\u001a\u00020'H\u0096\u0002J\t\u0010(\u001a\u00020\fH\u0096\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u0006*"}, d2={"Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl;", "Lorg/vitrivr/cottontail/client/iterators/TupleIterator;", "result", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "context", "Lio/grpc/Context$CancellableContext;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;Lio/grpc/Context$CancellableContext;)V", "results", "", "(Ljava/util/Iterator;Lio/grpc/Context$CancellableContext;)V", "buffer", "Ljava/util/LinkedList;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "numberOfColumns", "", "getNumberOfColumns", "()I", "planDuration", "", "getPlanDuration", "()J", "queryDuration", "getQueryDuration", "queryId", "", "getQueryId", "()Ljava/lang/String;", "rowIndex", "transactionId", "getTransactionId", "close", "", "hasNext", "", "next", "IteratorTuple", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nTupleIteratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TupleIteratorImpl.kt\norg/vitrivr/cottontail/client/iterators/TupleIteratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1855#2,2:129\n1549#2:131\n1620#2,3:132\n*S KotlinDebug\n*F\n+ 1 TupleIteratorImpl.kt\norg/vitrivr/cottontail/client/iterators/TupleIteratorImpl\n*L\n71#1:129,2\n103#1:131\n103#1:132,3\n*E\n"})
public final class TupleIteratorImpl
implements TupleIterator {
    @NotNull
    private final Iterator<CottontailGrpc.QueryResponseMessage> results;
    @NotNull
    private final Context.CancellableContext context;
    @NotNull
    private final LinkedList<Tuple> buffer;
    private final long transactionId;
    @NotNull
    private final String queryId;
    private final long planDuration;
    private final long queryDuration;
    @NotNull
    private final ColumnDef<?>[] columns;
    private long rowIndex;

    public TupleIteratorImpl(@NotNull Iterator<CottontailGrpc.QueryResponseMessage> results, @NotNull Context.CancellableContext context) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.results = results;
        this.context = context;
        this.buffer = new LinkedList();
        CottontailGrpc.QueryResponseMessage next = this.results.next();
        this.transactionId = next.getMetadata().getTransactionId();
        String string = next.getMetadata().getQueryId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQueryId(...)");
        this.queryId = string;
        this.planDuration = next.getMetadata().getPlanDuration();
        this.queryDuration = next.getMetadata().getQueryDuration();
        int n = 0;
        int n2 = next.getColumnsList().size();
        ColumnDef[] columnDefArray = new ColumnDef[n2];
        TupleIteratorImpl tupleIteratorImpl = this;
        while (n < n2) {
            int n3 = n++;
            CottontailGrpc.ColumnDefinition c = next.getColumnsList().get(n3);
            CottontailGrpc.ColumnName columnName = c.getName();
            Intrinsics.checkNotNullExpressionValue((Object)columnName, (String)"getName(...)");
            Name.ColumnName columnName2 = NameExtensionsKt.parse(columnName);
            CottontailGrpc.Type type = c.getType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"getType(...)");
            columnDefArray[n3] = new ColumnDef(columnName2, DataExtensionsKt.toType(type, c.getLength()), c.getNullable(), c.getPrimary(), c.getAutoIncrement());
        }
        tupleIteratorImpl.columns = columnDefArray;
        List<CottontailGrpc.QueryResponseMessage.Tuple> list = next.getTuplesList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTuplesList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CottontailGrpc.QueryResponseMessage.Tuple t = (CottontailGrpc.QueryResponseMessage.Tuple)element$iv;
            boolean bl = false;
            int n4 = 0;
            int n5 = this.getNumberOfColumns();
            Value[] valueArray = new Value[n5];
            TupleIteratorImpl tupleIteratorImpl2 = this;
            LinkedList<Tuple> linkedList = this.buffer;
            while (n4 < n5) {
                int n6 = n4++;
                CottontailGrpc.Literal literal = t.getDataList().get(n6);
                Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"get(...)");
                valueArray[n6] = DataExtensionsKt.toValue(literal);
            }
            Value[] valueArray2 = valueArray;
            TupleIteratorImpl tupleIteratorImpl3 = tupleIteratorImpl2;
            linkedList.add(tupleIteratorImpl3.new IteratorTuple(valueArray2));
        }
        if (!this.results.hasNext()) {
            this.context.close();
        }
    }

    public TupleIteratorImpl(@NotNull CottontailGrpc.QueryResponseMessage result, @NotNull Context.CancellableContext context) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new CottontailGrpc.QueryResponseMessage[]{result};
        this(SequencesKt.sequenceOf((Object[])objectArray).iterator(), context);
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    @NotNull
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public long getPlanDuration() {
        return this.planDuration;
    }

    @Override
    public long getQueryDuration() {
        return this.queryDuration;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @Override
    public int getNumberOfColumns() {
        return this.getColumns().length;
    }

    @Override
    public boolean hasNext() {
        if (!((Collection)this.buffer).isEmpty()) {
            return true;
        }
        if (!this.results.hasNext()) {
            this.context.close();
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Tuple next() {
        if (this.buffer.isEmpty()) {
            void $this$mapTo$iv$iv;
            if (!this.results.hasNext()) {
                this.context.close();
                throw new IllegalArgumentException("TupleIterator has been drained and no more elements can be loaded. Call hasNext() to ensure that elements are available before calling next().");
            }
            List<CottontailGrpc.QueryResponseMessage.Tuple> list = this.results.next().getTuplesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTuplesList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CottontailGrpc.QueryResponseMessage.Tuple tuple = (CottontailGrpc.QueryResponseMessage.Tuple)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int n = 0;
                int n2 = this.getNumberOfColumns();
                Value[] valueArray = new Value[n2];
                TupleIteratorImpl tupleIteratorImpl = this;
                LinkedList<Tuple> linkedList = this.buffer;
                while (n < n2) {
                    void t;
                    int n3 = n++;
                    CottontailGrpc.Literal literal = t.getDataList().get(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"get(...)");
                    valueArray[n3] = DataExtensionsKt.toValue(literal);
                }
                Value[] valueArray2 = valueArray;
                TupleIteratorImpl tupleIteratorImpl2 = tupleIteratorImpl;
                collection.add(linkedList.add(tupleIteratorImpl2.new IteratorTuple(valueArray2)));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        Tuple tuple = this.buffer.poll();
        Intrinsics.checkNotNull((Object)tuple);
        return tuple;
    }

    @Override
    public void close() {
        this.context.cancel((Throwable)new CancellationException("TupleIterator has been prematurely closed by user."));
    }

    @Override
    @NotNull
    public List<Tuple> toList() {
        return TupleIterator.DefaultImpls.toList(this);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0010 \n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0001H\u0016J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\u0010\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0016H\u0016R\u001e\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl$IteratorTuple;", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "values", "", "Lorg/vitrivr/cottontail/core/types/Value;", "(Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl;[Lorg/vitrivr/cottontail/core/types/Value;)V", "columns", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "getTupleId", "()J", "getValues", "()[Lorg/vitrivr/cottontail/core/types/Value;", "[Lorg/vitrivr/cottontail/core/types/Value;", "copy", "get", "index", "", "", "cottontaildb-client"})
    public final class IteratorTuple
    implements Tuple {
        @NotNull
        private final Value[] values;
        private final long tupleId;

        public IteratorTuple(Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            this.values = values;
            TupleIteratorImpl tupleIteratorImpl = TupleIteratorImpl.this;
            long l = tupleIteratorImpl.rowIndex;
            tupleIteratorImpl.rowIndex = l + 1L;
            this.tupleId = l;
        }

        @NotNull
        public final Value[] getValues() {
            return this.values;
        }

        @Override
        public long getTupleId() {
            return this.tupleId;
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return TupleIteratorImpl.this.getColumns();
        }

        @Override
        @NotNull
        public Tuple copy() {
            long l = this.getTupleId();
            ColumnDef<?>[] columnDefArray = this.getColumns();
            Value[] valueArray = Arrays.copyOf(this.values, this.values.length);
            Intrinsics.checkNotNullExpressionValue((Object)valueArray, (String)"copyOf(...)");
            return new StandaloneTuple(l, columnDefArray, valueArray);
        }

        @Override
        @Nullable
        public Value get(int index) {
            return this.values[index];
        }

        @Override
        @NotNull
        public List<Value> values() {
            return ArraysKt.toList((Object[])this.values);
        }

        @Override
        @Nullable
        public Value get(@NotNull ColumnDef<?> column) {
            return Tuple.DefaultImpls.get((Tuple)this, column);
        }

        @Override
        @Nullable
        public Value get(@NotNull Name.ColumnName column) {
            return Tuple.DefaultImpls.get((Tuple)this, column);
        }

        @Override
        @Nullable
        public Value get(@NotNull String column) {
            return Tuple.DefaultImpls.get((Tuple)this, column);
        }

        @Override
        public int getSize() {
            return Tuple.DefaultImpls.getSize(this);
        }

        @Override
        public boolean has(@NotNull ColumnDef<?> column) {
            return Tuple.DefaultImpls.has(this, column);
        }

        @Override
        public int indexOf(@NotNull ColumnDef<?> column) {
            return Tuple.DefaultImpls.indexOf((Tuple)this, column);
        }

        @Override
        public int indexOf(@NotNull Name.ColumnName column) {
            return Tuple.DefaultImpls.indexOf((Tuple)this, column);
        }

        @Override
        public int indexOf(@NotNull String column) {
            return Tuple.DefaultImpls.indexOf((Tuple)this, column);
        }

        @Override
        @NotNull
        public Name.ColumnName nameForIndex(int index) {
            return Tuple.DefaultImpls.nameForIndex(this, index);
        }

        @Override
        @NotNull
        public String fqnForIndex(int index) {
            return Tuple.DefaultImpls.fqnForIndex(this, index);
        }

        @Override
        @NotNull
        public String simpleNameForIndex(int index) {
            return Tuple.DefaultImpls.simpleNameForIndex(this, index);
        }

        @Override
        @NotNull
        public List<Types<?>> types() {
            return Tuple.DefaultImpls.types(this);
        }

        @Override
        @NotNull
        public Types<?> type(int index) {
            return Tuple.DefaultImpls.type((Tuple)this, index);
        }

        @Override
        @NotNull
        public Types<?> type(@NotNull Name.ColumnName name) {
            return Tuple.DefaultImpls.type((Tuple)this, name);
        }

        @Override
        @NotNull
        public Types<?> type(@NotNull String name) {
            return Tuple.DefaultImpls.type((Tuple)this, name);
        }

        @Override
        @Nullable
        public BooleanValue asBooleanValue-1OalM1U(int index) {
            return Tuple.DefaultImpls.asBooleanValue-1OalM1U((Tuple)this, index);
        }

        @Override
        @Nullable
        public BooleanValue asBooleanValue-1OalM1U(@NotNull String name) {
            return Tuple.DefaultImpls.asBooleanValue-1OalM1U((Tuple)this, name);
        }

        @Override
        @Nullable
        public Boolean asBoolean(int index) {
            return Tuple.DefaultImpls.asBoolean((Tuple)this, index);
        }

        @Override
        @Nullable
        public Boolean asBoolean(@NotNull String name) {
            return Tuple.DefaultImpls.asBoolean((Tuple)this, name);
        }

        @Override
        @Nullable
        public ByteValue asByteValue-NuVS9b8(int index) {
            return Tuple.DefaultImpls.asByteValue-NuVS9b8((Tuple)this, index);
        }

        @Override
        @Nullable
        public ByteValue asByteValue-NuVS9b8(@NotNull String name) {
            return Tuple.DefaultImpls.asByteValue-NuVS9b8((Tuple)this, name);
        }

        @Override
        @Nullable
        public Byte asByte(int index) {
            return Tuple.DefaultImpls.asByte((Tuple)this, index);
        }

        @Override
        @Nullable
        public Byte asByte(@NotNull String name) {
            return Tuple.DefaultImpls.asByte((Tuple)this, name);
        }

        @Override
        @Nullable
        public ShortValue asShortValue-f20-H9w(int index) {
            return Tuple.DefaultImpls.asShortValue-f20-H9w((Tuple)this, index);
        }

        @Override
        @Nullable
        public ShortValue asShortValue-f20-H9w(@NotNull String name) {
            return Tuple.DefaultImpls.asShortValue-f20-H9w((Tuple)this, name);
        }

        @Override
        @Nullable
        public Short asShort(int index) {
            return Tuple.DefaultImpls.asShort((Tuple)this, index);
        }

        @Override
        @Nullable
        public Short asShort(@NotNull String name) {
            return Tuple.DefaultImpls.asShort((Tuple)this, name);
        }

        @Override
        @Nullable
        public IntValue asIntValue-yZMVbvg(int index) {
            return Tuple.DefaultImpls.asIntValue-yZMVbvg((Tuple)this, index);
        }

        @Override
        @Nullable
        public IntValue asIntValue-yZMVbvg(@NotNull String name) {
            return Tuple.DefaultImpls.asIntValue-yZMVbvg((Tuple)this, name);
        }

        @Override
        @Nullable
        public Integer asInt(int index) {
            return Tuple.DefaultImpls.asInt((Tuple)this, index);
        }

        @Override
        @Nullable
        public Integer asInt(@NotNull String name) {
            return Tuple.DefaultImpls.asInt((Tuple)this, name);
        }

        @Override
        @Nullable
        public LongValue asLongValue-CNcmMjI(int index) {
            return Tuple.DefaultImpls.asLongValue-CNcmMjI((Tuple)this, index);
        }

        @Override
        @Nullable
        public LongValue asLongValue-CNcmMjI(@NotNull String name) {
            return Tuple.DefaultImpls.asLongValue-CNcmMjI((Tuple)this, name);
        }

        @Override
        @Nullable
        public Long asLong(int index) {
            return Tuple.DefaultImpls.asLong((Tuple)this, index);
        }

        @Override
        @Nullable
        public Long asLong(@NotNull String name) {
            return Tuple.DefaultImpls.asLong((Tuple)this, name);
        }

        @Override
        @Nullable
        public FloatValue asFloatValue-z8PsB-c(int index) {
            return Tuple.DefaultImpls.asFloatValue-z8PsB-c((Tuple)this, index);
        }

        @Override
        @Nullable
        public FloatValue asFloatValue-z8PsB-c(@NotNull String name) {
            return Tuple.DefaultImpls.asFloatValue-z8PsB-c((Tuple)this, name);
        }

        @Override
        @Nullable
        public Float asFloat(int index) {
            return Tuple.DefaultImpls.asFloat((Tuple)this, index);
        }

        @Override
        @Nullable
        public Float asFloat(@NotNull String name) {
            return Tuple.DefaultImpls.asFloat((Tuple)this, name);
        }

        @Override
        @Nullable
        public DoubleValue asDoubleValue-qx1rvJE(int index) {
            return Tuple.DefaultImpls.asDoubleValue-qx1rvJE((Tuple)this, index);
        }

        @Override
        @Nullable
        public DoubleValue asDoubleValue-qx1rvJE(@NotNull String name) {
            return Tuple.DefaultImpls.asDoubleValue-qx1rvJE((Tuple)this, name);
        }

        @Override
        @Nullable
        public Double asDouble(int index) {
            return Tuple.DefaultImpls.asDouble((Tuple)this, index);
        }

        @Override
        @Nullable
        public Double asDouble(@NotNull String name) {
            return Tuple.DefaultImpls.asDouble((Tuple)this, name);
        }

        @Override
        @Nullable
        public boolean[] asBooleanVectorValue-iuwxMNg(int index) {
            return Tuple.DefaultImpls.asBooleanVectorValue-iuwxMNg((Tuple)this, index);
        }

        @Override
        @Nullable
        public boolean[] asBooleanVectorValue-iuwxMNg(@NotNull String name) {
            return Tuple.DefaultImpls.asBooleanVectorValue-iuwxMNg((Tuple)this, name);
        }

        @Override
        @Nullable
        public boolean[] asBooleanVector(int index) {
            return Tuple.DefaultImpls.asBooleanVector((Tuple)this, index);
        }

        @Override
        @Nullable
        public boolean[] asBooleanVector(@NotNull String name) {
            return Tuple.DefaultImpls.asBooleanVector((Tuple)this, name);
        }

        @Override
        @Nullable
        public int[] asIntVectorValue-Q8dlA04(int index) {
            return Tuple.DefaultImpls.asIntVectorValue-Q8dlA04((Tuple)this, index);
        }

        @Override
        @Nullable
        public int[] asIntVectorValue-Q8dlA04(@NotNull String name) {
            return Tuple.DefaultImpls.asIntVectorValue-Q8dlA04((Tuple)this, name);
        }

        @Override
        @Nullable
        public int[] asIntVector(int index) {
            return Tuple.DefaultImpls.asIntVector((Tuple)this, index);
        }

        @Override
        @Nullable
        public int[] asIntVector(@NotNull String name) {
            return Tuple.DefaultImpls.asIntVector((Tuple)this, name);
        }

        @Override
        @Nullable
        public long[] asLongVectorValue-2nsrhKc(int index) {
            return Tuple.DefaultImpls.asLongVectorValue-2nsrhKc((Tuple)this, index);
        }

        @Override
        @Nullable
        public long[] asLongVectorValue-2nsrhKc(@NotNull String name) {
            return Tuple.DefaultImpls.asLongVectorValue-2nsrhKc((Tuple)this, name);
        }

        @Override
        @Nullable
        public long[] asLongVector(int index) {
            return Tuple.DefaultImpls.asLongVector((Tuple)this, index);
        }

        @Override
        @Nullable
        public long[] asLongVector(@NotNull String name) {
            return Tuple.DefaultImpls.asLongVector((Tuple)this, name);
        }

        @Override
        @Nullable
        public float[] asFloatVectorValue-JSSEiYU(int index) {
            return Tuple.DefaultImpls.asFloatVectorValue-JSSEiYU((Tuple)this, index);
        }

        @Override
        @Nullable
        public float[] asFloatVectorValue-JSSEiYU(@NotNull String name) {
            return Tuple.DefaultImpls.asFloatVectorValue-JSSEiYU((Tuple)this, name);
        }

        @Override
        @Nullable
        public float[] asFloatVector(int index) {
            return Tuple.DefaultImpls.asFloatVector((Tuple)this, index);
        }

        @Override
        @Nullable
        public float[] asFloatVector(@NotNull String name) {
            return Tuple.DefaultImpls.asFloatVector((Tuple)this, name);
        }

        @Override
        @Nullable
        public double[] asDoubleVectorValue-4MSoHV4(int index) {
            return Tuple.DefaultImpls.asDoubleVectorValue-4MSoHV4((Tuple)this, index);
        }

        @Override
        @Nullable
        public double[] asDoubleVectorValue-4MSoHV4(@NotNull String name) {
            return Tuple.DefaultImpls.asDoubleVectorValue-4MSoHV4((Tuple)this, name);
        }

        @Override
        @Nullable
        public double[] asDoubleVector(int index) {
            return Tuple.DefaultImpls.asDoubleVector((Tuple)this, index);
        }

        @Override
        @Nullable
        public double[] asDoubleVector(@NotNull String name) {
            return Tuple.DefaultImpls.asDoubleVector((Tuple)this, name);
        }

        @Override
        @Nullable
        public String asStringValue-20uZBUg(int index) {
            return Tuple.DefaultImpls.asStringValue-20uZBUg((Tuple)this, index);
        }

        @Override
        @Nullable
        public String asStringValue-20uZBUg(@NotNull String name) {
            return Tuple.DefaultImpls.asStringValue-20uZBUg((Tuple)this, name);
        }

        @Override
        @Nullable
        public UUID asUuidValue-I4cHxZI(int index) {
            return Tuple.DefaultImpls.asUuidValue-I4cHxZI((Tuple)this, index);
        }

        @Override
        @Nullable
        public UUID asUuidValue-I4cHxZI(@NotNull String name) {
            return Tuple.DefaultImpls.asUuidValue-I4cHxZI((Tuple)this, name);
        }

        @Override
        @Nullable
        public String asString(int index) {
            return Tuple.DefaultImpls.asString((Tuple)this, index);
        }

        @Override
        @Nullable
        public String asString(@NotNull String name) {
            return Tuple.DefaultImpls.asString((Tuple)this, name);
        }

        @Override
        @Nullable
        public DateValue asDateValue-fSwC0cY(int index) {
            return Tuple.DefaultImpls.asDateValue-fSwC0cY((Tuple)this, index);
        }

        @Override
        @Nullable
        public DateValue asDateValue-fSwC0cY(@NotNull String name) {
            return Tuple.DefaultImpls.asDateValue-fSwC0cY((Tuple)this, name);
        }

        @Override
        @Nullable
        public Date asDate(int index) {
            return Tuple.DefaultImpls.asDate((Tuple)this, index);
        }

        @Override
        @Nullable
        public Date asDate(@NotNull String name) {
            return Tuple.DefaultImpls.asDate((Tuple)this, name);
        }

        @Override
        @Nullable
        public byte[] asByteStringValue-vFcFNtk(int index) {
            return Tuple.DefaultImpls.asByteStringValue-vFcFNtk((Tuple)this, index);
        }

        @Override
        @Nullable
        public byte[] asByteStringValue-vFcFNtk(@NotNull String name) {
            return Tuple.DefaultImpls.asByteStringValue-vFcFNtk((Tuple)this, name);
        }

        @Override
        @Nullable
        public byte[] asByteArray(int index) {
            return Tuple.DefaultImpls.asByteArray(this, index);
        }

        @Override
        @Nullable
        public float[] asComplex32Value-PGJHCcI(int index) {
            return Tuple.DefaultImpls.asComplex32Value-PGJHCcI((Tuple)this, index);
        }

        @Override
        @Nullable
        public float[] asComplex32Value-PGJHCcI(@NotNull String name) {
            return Tuple.DefaultImpls.asComplex32Value-PGJHCcI((Tuple)this, name);
        }

        @Override
        @Nullable
        public double[] asComplex64Value-9by7ZfM(int index) {
            return Tuple.DefaultImpls.asComplex64Value-9by7ZfM((Tuple)this, index);
        }

        @Override
        @Nullable
        public double[] asComplex64Value-9by7ZfM(@NotNull String name) {
            return Tuple.DefaultImpls.asComplex64Value-9by7ZfM((Tuple)this, name);
        }

        @Override
        @Nullable
        public float[] asComplex32VectorValue-mz4DNGM(int index) {
            return Tuple.DefaultImpls.asComplex32VectorValue-mz4DNGM(this, index);
        }

        @Override
        @Nullable
        public double[] asComplex64VectorValue-JfuYN9c(int index) {
            return Tuple.DefaultImpls.asComplex64VectorValue-JfuYN9c(this, index);
        }
    }
}

