package org.vitrivr.cottontail.grpc

import com.google.protobuf.Empty
import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.String
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.flow.Flow
import org.vitrivr.cottontail.grpc.DDLGrpc.getServiceDescriptor as dDLGrpcGetServiceDescriptor
import org.vitrivr.cottontail.grpc.DMLGrpc.getServiceDescriptor as dMLGrpcGetServiceDescriptor
import org.vitrivr.cottontail.grpc.DQLGrpc.getServiceDescriptor as dQLGrpcGetServiceDescriptor
import org.vitrivr.cottontail.grpc.TXNGrpc.getServiceDescriptor as tXNGrpcGetServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DDL.
 */
public object DDLGrpcKt {
  public const val SERVICE_NAME: String = DDLGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = dDLGrpcGetServiceDescriptor()

  public val listSchemasMethod:
      MethodDescriptor<CottontailGrpc.ListSchemaMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getListSchemasMethod()

  public val createSchemaMethod:
      MethodDescriptor<CottontailGrpc.CreateSchemaMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateSchemaMethod()

  public val dropSchemaMethod:
      MethodDescriptor<CottontailGrpc.DropSchemaMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropSchemaMethod()

  public val listEntitiesMethod:
      MethodDescriptor<CottontailGrpc.ListEntityMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getListEntitiesMethod()

  public val entityDetailsMethod:
      MethodDescriptor<CottontailGrpc.EntityDetailsMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getEntityDetailsMethod()

  public val entityStatisticsMethod:
      MethodDescriptor<CottontailGrpc.EntityDetailsMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getEntityStatisticsMethod()

  public val indexDetailsMethod:
      MethodDescriptor<CottontailGrpc.IndexDetailsMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getIndexDetailsMethod()

  public val createEntityMethod:
      MethodDescriptor<CottontailGrpc.CreateEntityMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateEntityMethod()

  public val dropEntityMethod:
      MethodDescriptor<CottontailGrpc.DropEntityMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropEntityMethod()

  public val truncateEntityMethod:
      MethodDescriptor<CottontailGrpc.TruncateEntityMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getTruncateEntityMethod()

  public val analyzeEntityMethod:
      MethodDescriptor<CottontailGrpc.AnalyzeEntityMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getAnalyzeEntityMethod()

  public val createIndexMethod:
      MethodDescriptor<CottontailGrpc.CreateIndexMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateIndexMethod()

  public val dropIndexMethod:
      MethodDescriptor<CottontailGrpc.DropIndexMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropIndexMethod()

  public val rebuildIndexMethod:
      MethodDescriptor<CottontailGrpc.RebuildIndexMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getRebuildIndexMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DDL service as suspending
   * coroutines.
   */
  @StubFor(DDLGrpc::class)
  public class DDLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<DDLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DDLCoroutineStub =
        DDLCoroutineStub(channel, callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun listSchemas(request: CottontailGrpc.ListSchemaMessage, headers: Metadata =
        Metadata()): Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DDLGrpc.getListSchemasMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun createSchema(request: CottontailGrpc.CreateSchemaMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateSchemaMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun dropSchema(request: CottontailGrpc.DropSchemaMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropSchemaMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun listEntities(request: CottontailGrpc.ListEntityMessage, headers: Metadata =
        Metadata()): Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DDLGrpc.getListEntitiesMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun entityDetails(request: CottontailGrpc.EntityDetailsMessage, headers: Metadata
        = Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getEntityDetailsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun entityStatistics(request: CottontailGrpc.EntityDetailsMessage,
        headers: Metadata = Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getEntityStatisticsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun indexDetails(request: CottontailGrpc.IndexDetailsMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getIndexDetailsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun createEntity(request: CottontailGrpc.CreateEntityMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateEntityMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun dropEntity(request: CottontailGrpc.DropEntityMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropEntityMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun truncateEntity(request: CottontailGrpc.TruncateEntityMessage,
        headers: Metadata = Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getTruncateEntityMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun analyzeEntity(request: CottontailGrpc.AnalyzeEntityMessage, headers: Metadata
        = Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getAnalyzeEntityMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun createIndex(request: CottontailGrpc.CreateIndexMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateIndexMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun dropIndex(request: CottontailGrpc.DropIndexMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropIndexMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun rebuildIndex(request: CottontailGrpc.RebuildIndexMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getRebuildIndexMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DDL service based on Kotlin
   * coroutines.
   */
  public abstract class DDLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DDL.ListSchemas.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun listSchemas(request: CottontailGrpc.ListSchemaMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.ListSchemas is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateSchema.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun createSchema(request: CottontailGrpc.CreateSchemaMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateSchema is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropSchema.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun dropSchema(request: CottontailGrpc.DropSchemaMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropSchema is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DDL.ListEntities.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun listEntities(request: CottontailGrpc.ListEntityMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.ListEntities is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.EntityDetails.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun entityDetails(request: CottontailGrpc.EntityDetailsMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.EntityDetails is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.EntityStatistics.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun entityStatistics(request: CottontailGrpc.EntityDetailsMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.EntityStatistics is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.IndexDetails.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun indexDetails(request: CottontailGrpc.IndexDetailsMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.IndexDetails is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun createEntity(request: CottontailGrpc.CreateEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun dropEntity(request: CottontailGrpc.DropEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.TruncateEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun truncateEntity(request: CottontailGrpc.TruncateEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.TruncateEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.AnalyzeEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun analyzeEntity(request: CottontailGrpc.AnalyzeEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.AnalyzeEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun createIndex(request: CottontailGrpc.CreateIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateIndex is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun dropIndex(request: CottontailGrpc.DropIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropIndex is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.RebuildIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun rebuildIndex(request: CottontailGrpc.RebuildIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.RebuildIndex is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(dDLGrpcGetServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getListSchemasMethod(),
      implementation = ::listSchemas
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateSchemaMethod(),
      implementation = ::createSchema
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropSchemaMethod(),
      implementation = ::dropSchema
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getListEntitiesMethod(),
      implementation = ::listEntities
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getEntityDetailsMethod(),
      implementation = ::entityDetails
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getEntityStatisticsMethod(),
      implementation = ::entityStatistics
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getIndexDetailsMethod(),
      implementation = ::indexDetails
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateEntityMethod(),
      implementation = ::createEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropEntityMethod(),
      implementation = ::dropEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getTruncateEntityMethod(),
      implementation = ::truncateEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getAnalyzeEntityMethod(),
      implementation = ::analyzeEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateIndexMethod(),
      implementation = ::createIndex
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropIndexMethod(),
      implementation = ::dropIndex
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getRebuildIndexMethod(),
      implementation = ::rebuildIndex
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DML.
 */
public object DMLGrpcKt {
  public const val SERVICE_NAME: String = DMLGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = dMLGrpcGetServiceDescriptor()

  public val insertMethod:
      MethodDescriptor<CottontailGrpc.InsertMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getInsertMethod()

  public val insertBatchMethod:
      MethodDescriptor<CottontailGrpc.BatchInsertMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getInsertBatchMethod()

  public val updateMethod:
      MethodDescriptor<CottontailGrpc.UpdateMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getUpdateMethod()

  public val deleteMethod:
      MethodDescriptor<CottontailGrpc.DeleteMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getDeleteMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DML service as suspending
   * coroutines.
   */
  @StubFor(DMLGrpc::class)
  public class DMLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<DMLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DMLCoroutineStub =
        DMLCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun insert(request: CottontailGrpc.InsertMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DMLGrpc.getInsertMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun insertBatch(request: CottontailGrpc.BatchInsertMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DMLGrpc.getInsertBatchMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun update(request: CottontailGrpc.UpdateMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DMLGrpc.getUpdateMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun delete(request: CottontailGrpc.DeleteMessage, headers: Metadata =
        Metadata()): CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DMLGrpc.getDeleteMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DML service based on Kotlin
   * coroutines.
   */
  public abstract class DMLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Insert.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun insert(request: CottontailGrpc.InsertMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Insert is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.InsertBatch.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun insertBatch(request: CottontailGrpc.BatchInsertMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.InsertBatch is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Update.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun update(request: CottontailGrpc.UpdateMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Update is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Delete.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun delete(request: CottontailGrpc.DeleteMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Delete is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(dMLGrpcGetServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getInsertMethod(),
      implementation = ::insert
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getInsertBatchMethod(),
      implementation = ::insertBatch
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getUpdateMethod(),
      implementation = ::update
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getDeleteMethod(),
      implementation = ::delete
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DQL.
 */
public object DQLGrpcKt {
  public const val SERVICE_NAME: String = DQLGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = dQLGrpcGetServiceDescriptor()

  public val explainMethod:
      MethodDescriptor<CottontailGrpc.QueryMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DQLGrpc.getExplainMethod()

  public val queryMethod:
      MethodDescriptor<CottontailGrpc.QueryMessage, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DQLGrpc.getQueryMethod()

  public val pingMethod: MethodDescriptor<Empty, Empty>
    @JvmStatic
    get() = DQLGrpc.getPingMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DQL service as suspending
   * coroutines.
   */
  @StubFor(DQLGrpc::class)
  public class DQLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<DQLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DQLCoroutineStub =
        DQLCoroutineStub(channel, callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun explain(request: CottontailGrpc.QueryMessage, headers: Metadata = Metadata()):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DQLGrpc.getExplainMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun query(request: CottontailGrpc.QueryMessage, headers: Metadata = Metadata()):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DQLGrpc.getQueryMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun ping(request: Empty, headers: Metadata = Metadata()): Empty = unaryRpc(
      channel,
      DQLGrpc.getPingMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DQL service based on Kotlin
   * coroutines.
   */
  public abstract class DQLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DQL.Explain.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun explain(request: CottontailGrpc.QueryMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Explain is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DQL.Query.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun query(request: CottontailGrpc.QueryMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Query is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DQL.Ping.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun ping(request: Empty): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Ping is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(dQLGrpcGetServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getExplainMethod(),
      implementation = ::explain
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getQueryMethod(),
      implementation = ::query
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getPingMethod(),
      implementation = ::ping
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.TXN.
 */
public object TXNGrpcKt {
  public const val SERVICE_NAME: String = TXNGrpc.SERVICE_NAME

  @JvmStatic
  public val serviceDescriptor: ServiceDescriptor
    get() = tXNGrpcGetServiceDescriptor()

  public val beginMethod:
      MethodDescriptor<CottontailGrpc.BeginTransaction, CottontailGrpc.ResponseMetadata>
    @JvmStatic
    get() = TXNGrpc.getBeginMethod()

  public val commitMethod: MethodDescriptor<CottontailGrpc.RequestMetadata, Empty>
    @JvmStatic
    get() = TXNGrpc.getCommitMethod()

  public val rollbackMethod: MethodDescriptor<CottontailGrpc.RequestMetadata, Empty>
    @JvmStatic
    get() = TXNGrpc.getRollbackMethod()

  public val killMethod: MethodDescriptor<CottontailGrpc.RequestMetadata, Empty>
    @JvmStatic
    get() = TXNGrpc.getKillMethod()

  public val listTransactionsMethod: MethodDescriptor<Empty, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = TXNGrpc.getListTransactionsMethod()

  public val listLocksMethod: MethodDescriptor<Empty, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = TXNGrpc.getListLocksMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.TXN service as suspending
   * coroutines.
   */
  @StubFor(TXNGrpc::class)
  public class TXNCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT,
  ) : AbstractCoroutineStub<TXNCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): TXNCoroutineStub =
        TXNCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun begin(request: CottontailGrpc.BeginTransaction, headers: Metadata =
        Metadata()): CottontailGrpc.ResponseMetadata = unaryRpc(
      channel,
      TXNGrpc.getBeginMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun commit(request: CottontailGrpc.RequestMetadata, headers: Metadata =
        Metadata()): Empty = unaryRpc(
      channel,
      TXNGrpc.getCommitMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun rollback(request: CottontailGrpc.RequestMetadata, headers: Metadata =
        Metadata()): Empty = unaryRpc(
      channel,
      TXNGrpc.getRollbackMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][io.grpc.Status].  If the RPC completes with another status, a
     * corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return The single response from the server.
     */
    public suspend fun kill(request: CottontailGrpc.RequestMetadata, headers: Metadata =
        Metadata()): Empty = unaryRpc(
      channel,
      TXNGrpc.getKillMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun listTransactions(request: Empty, headers: Metadata = Metadata()):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      TXNGrpc.getListTransactionsMethod(),
      request,
      callOptions,
      headers
    )

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][io.grpc.Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @param headers Metadata to attach to the request.  Most users will not need this.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    public fun listLocks(request: Empty, headers: Metadata = Metadata()):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      TXNGrpc.getListLocksMethod(),
      request,
      callOptions,
      headers
    )
  }

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.TXN service based on Kotlin
   * coroutines.
   */
  public abstract class TXNCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext,
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Begin.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun begin(request: CottontailGrpc.BeginTransaction):
        CottontailGrpc.ResponseMetadata = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Begin is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Commit.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun commit(request: CottontailGrpc.RequestMetadata): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Commit is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Rollback.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun rollback(request: CottontailGrpc.RequestMetadata): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Rollback is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Kill.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [io.grpc.Status].  If this method fails with a [java.util.concurrent.CancellationException],
     * the RPC will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open suspend fun kill(request: CottontailGrpc.RequestMetadata): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Kill is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.TXN.ListTransactions.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun listTransactions(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.ListTransactions is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.TXN.ListLocks.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [io.grpc.Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    public open fun listLocks(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.ListLocks is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(tXNGrpcGetServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getBeginMethod(),
      implementation = ::begin
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getCommitMethod(),
      implementation = ::commit
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getRollbackMethod(),
      implementation = ::rollback
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getKillMethod(),
      implementation = ::kill
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getListTransactionsMethod(),
      implementation = ::listTransactions
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getListLocksMethod(),
      implementation = ::listLocks
    )).build()
  }
}
