/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values;

import kotlin.Metadata;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.NumericValue;
import org.vitrivr.cottontail.core.types.RealValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.ByteValue;
import org.vitrivr.cottontail.core.values.Complex32Value;
import org.vitrivr.cottontail.core.values.Complex64Value;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.FloatValue$;
import org.vitrivr.cottontail.core.values.IntValue;
import org.vitrivr.cottontail.core.values.LongValue;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.core.values.ShortValue;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
@SerialName(value="Float")
@JvmInline
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0087@\u0018\u0000 s2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002rsB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB\u0015\b\u0016\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u000f\u0012\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\rJ\u0015\u0010\u001d\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001e\u0010\rJ\u0015\u0010\u001f\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010#\u001a\u00020$H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010'\u001a\u00020(H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010+\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u0010\rJ\u0015\u00101\u001a\u000202H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b3\u0010\u0014J\u0015\u00104\u001a\u000205H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b6\u00107J\u0015\u00108\u001a\u000209H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010<\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b=\u0010.J\u0018\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020@H\u0096\u0002\u00a2\u0006\u0004\bA\u0010BJ\u0015\u0010C\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bD\u0010.J\"\u0010E\u001a\u00020\u00002\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bF\u0010GJ\u001a\u0010H\u001a\u00020I2\b\u0010?\u001a\u0004\u0018\u00010JH\u00d6\u0003\u00a2\u0006\u0004\bK\u0010LJ\u0015\u0010M\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bN\u0010.J\u0010\u0010O\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\bP\u0010\u0014J\u0017\u0010Q\u001a\u00020I2\u0006\u0010?\u001a\u00020@H\u0016\u00a2\u0006\u0004\bR\u0010SJ\u0015\u0010T\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bU\u0010.J\"\u0010V\u001a\u00020\u00002\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bW\u0010GJ\"\u0010X\u001a\u00020\u00002\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bY\u0010GJ\u001d\u0010Z\u001a\u00020,2\u0006\u0010[\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\\\u0010]J\u001d\u0010Z\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0012H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b^\u0010_J\u0015\u0010`\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\ba\u0010.J\u0015\u0010b\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bc\u0010\rJ\u0015\u0010d\u001a\u00020,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\be\u0010.J\"\u0010f\u001a\u00020\u00002\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\nH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bg\u0010GJ\u000f\u0010h\u001a\u00020iH\u0016\u00a2\u0006\u0004\bj\u0010kJ\u0010\u0010l\u001a\u00020mH\u00d6\u0001\u00a2\u0006\u0004\bn\u0010oJ\u0016\u0010p\u001a\u00020\u0000H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bq\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0018\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u0088\u0001\f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006t"}, d2={"Lorg/vitrivr/cottontail/core/values/FloatValue;", "Lorg/vitrivr/cottontail/core/types/RealValue;", "", "Lorg/vitrivr/cottontail/core/values/PublicValue;", "number", "", "constructor-impl", "(D)F", "", "(Ljava/lang/Number;)F", "Lorg/vitrivr/cottontail/core/types/NumericValue;", "(Lorg/vitrivr/cottontail/core/types/NumericValue;)F", "value", "(F)F", "imaginary", "getImaginary-impl", "(F)Lorg/vitrivr/cottontail/core/types/RealValue;", "logicalSize", "", "getLogicalSize-impl", "(F)I", "real", "getReal-impl", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType-impl", "(F)Lorg/vitrivr/cottontail/core/types/Types;", "getValue", "()Ljava/lang/Float;", "abs", "abs-ZzhhcUg", "asByte", "Lorg/vitrivr/cottontail/core/values/ByteValue;", "asByte-CjcRDk4", "(F)B", "asComplex32", "Lorg/vitrivr/cottontail/core/values/Complex32Value;", "asComplex32-PIsl-yU", "(F)[F", "asComplex64", "Lorg/vitrivr/cottontail/core/values/Complex64Value;", "asComplex64-3djj_bw", "(F)[D", "asDouble", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "asDouble-5B6OyQQ", "(F)D", "asFloat", "asFloat-ZzhhcUg", "asInt", "Lorg/vitrivr/cottontail/core/values/IntValue;", "asInt-XzlYvWs", "asLong", "Lorg/vitrivr/cottontail/core/values/LongValue;", "asLong-hRrSGgQ", "(F)J", "asShort", "Lorg/vitrivr/cottontail/core/values/ShortValue;", "asShort-JzDwKSg", "(F)S", "atan", "atan-5B6OyQQ", "compareTo", "other", "Lorg/vitrivr/cottontail/core/types/Value;", "compareTo-impl", "(FLorg/vitrivr/cottontail/core/types/Value;)I", "cos", "cos-5B6OyQQ", "div", "div-PgYoAEc", "(FLorg/vitrivr/cottontail/core/types/NumericValue;)F", "equals", "", "", "equals-impl", "(FLjava/lang/Object;)Z", "exp", "exp-5B6OyQQ", "hashCode", "hashCode-impl", "isEqual", "isEqual-impl", "(FLorg/vitrivr/cottontail/core/types/Value;)Z", "ln", "ln-5B6OyQQ", "minus", "minus-PgYoAEc", "plus", "plus-PgYoAEc", "pow", "x", "pow-iEH02FE", "(FD)D", "pow-PgYoAEc", "(FI)F", "sin", "sin-5B6OyQQ", "sqrt", "sqrt-ZzhhcUg", "tan", "tan-5B6OyQQ", "times", "times-PgYoAEc", "toGrpc", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Literal;", "toGrpc-impl", "(F)Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Literal;", "toString", "", "toString-impl", "(F)Ljava/lang/String;", "unaryMinus", "unaryMinus-ZzhhcUg", "$serializer", "Companion", "cottontaildb-client"})
public final class FloatValue
implements RealValue<Float>,
PublicValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;
    private static final float MIN_VALUE = FloatValue.constructor-impl(2.8E-45f);
    private static final float MAX_VALUE = FloatValue.constructor-impl(Float.MAX_VALUE);
    private static final float ZERO = FloatValue.constructor-impl(0.0f);
    private static final float ONE = FloatValue.constructor-impl(1.0f);
    private static final float NaN = FloatValue.constructor-impl(Float.NaN);
    private static final float INF = FloatValue.constructor-impl(Float.POSITIVE_INFINITY);

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    public static float constructor-impl(double number) {
        return FloatValue.constructor-impl(Float.parseFloat(String.valueOf(number)));
    }

    public static float constructor-impl(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return FloatValue.constructor-impl(number.floatValue());
    }

    public static float constructor-impl(@NotNull NumericValue<?> number) {
        Intrinsics.checkNotNullParameter(number, (String)"number");
        return FloatValue.constructor-impl(((Number)number.getValue()).floatValue());
    }

    public static int getLogicalSize-impl(float arg0) {
        return 1;
    }

    @Override
    public int getLogicalSize() {
        return FloatValue.getLogicalSize-impl(this.value);
    }

    @NotNull
    public static Types<?> getType-impl(float arg0) {
        return Types.Float.INSTANCE;
    }

    @Override
    @NotNull
    public Types<?> getType() {
        return FloatValue.getType-impl(this.value);
    }

    @NotNull
    public static RealValue<Float> getReal-impl(float arg0) {
        return FloatValue.box-impl(arg0);
    }

    @Override
    @NotNull
    public RealValue<Float> getReal() {
        return FloatValue.getReal-impl(this.value);
    }

    @NotNull
    public static RealValue<Float> getImaginary-impl(float arg0) {
        return FloatValue.box-impl(ZERO);
    }

    @Override
    @NotNull
    public RealValue<Float> getImaginary() {
        return FloatValue.getImaginary-impl(this.value);
    }

    public static int compareTo-impl(float arg0, @NotNull Value other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Value value = other;
        if (value instanceof ByteValue) {
            n = Float.compare(arg0, ((ByteValue)other).unbox-impl());
        } else if (value instanceof ShortValue) {
            n = Float.compare(arg0, ((ShortValue)other).unbox-impl());
        } else if (value instanceof IntValue) {
            n = Float.compare(arg0, ((IntValue)other).unbox-impl());
        } else if (value instanceof LongValue) {
            n = Float.compare(arg0, ((LongValue)other).unbox-impl());
        } else if (value instanceof DoubleValue) {
            n = Double.compare(arg0, ((DoubleValue)other).unbox-impl());
        } else if (value instanceof FloatValue) {
            n = Float.compare(arg0, ((FloatValue)other).unbox-impl());
        } else if (value instanceof Complex32Value) {
            n = Float.compare(arg0, ((Complex32Value)other).unbox-impl()[0]);
        } else if (value instanceof Complex64Value) {
            n = Double.compare(arg0, ((Complex64Value)other).unbox-impl()[0]);
        } else {
            throw new IllegalArgumentException("LongValues can only be compared to other numeric values.");
        }
        return n;
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatValue.compareTo-impl(this.value, other);
    }

    public static boolean isEqual-impl(float arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof FloatValue && ((FloatValue)other).unbox-impl() == arg0;
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatValue.isEqual-impl(this.value, other);
    }

    @NotNull
    public static CottontailGrpc.Literal toGrpc-impl(float arg0) {
        CottontailGrpc.Literal literal = CottontailGrpc.Literal.newBuilder().setFloatData(arg0).build();
        Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"build(...)");
        return literal;
    }

    @Override
    @NotNull
    public CottontailGrpc.Literal toGrpc() {
        return FloatValue.toGrpc-impl(this.value);
    }

    public static double asDouble-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((double)arg0);
    }

    @Override
    public double asDouble-5B6OyQQ() {
        return FloatValue.asDouble-5B6OyQQ(this.value);
    }

    public static float asFloat-ZzhhcUg(float arg0) {
        return arg0;
    }

    @Override
    public float asFloat-ZzhhcUg() {
        return FloatValue.asFloat-ZzhhcUg(this.value);
    }

    public static int asInt-XzlYvWs(float arg0) {
        return IntValue.constructor-impl((int)arg0);
    }

    @Override
    public int asInt-XzlYvWs() {
        return FloatValue.asInt-XzlYvWs(this.value);
    }

    public static long asLong-hRrSGgQ(float arg0) {
        return LongValue.constructor-impl((long)arg0);
    }

    @Override
    public long asLong-hRrSGgQ() {
        return FloatValue.asLong-hRrSGgQ(this.value);
    }

    public static short asShort-JzDwKSg(float arg0) {
        return ShortValue.constructor-impl((short)arg0);
    }

    @Override
    public short asShort-JzDwKSg() {
        return FloatValue.asShort-JzDwKSg(this.value);
    }

    public static byte asByte-CjcRDk4(float arg0) {
        return ByteValue.constructor-impl((byte)arg0);
    }

    @Override
    public byte asByte-CjcRDk4() {
        return FloatValue.asByte-CjcRDk4(this.value);
    }

    @NotNull
    public static float[] asComplex32-PIsl-yU(float arg0) {
        return Complex32Value.constructor-impl(FloatValue.box-impl(FloatValue.asFloat-ZzhhcUg(arg0)), FloatValue.box-impl(FloatValue.constructor-impl(0.0f)));
    }

    @Override
    @NotNull
    public float[] asComplex32-PIsl-yU() {
        return FloatValue.asComplex32-PIsl-yU(this.value);
    }

    @NotNull
    public static double[] asComplex64-3djj_bw(float arg0) {
        return Complex64Value.constructor-impl(DoubleValue.box-impl(FloatValue.asDouble-5B6OyQQ(arg0)), DoubleValue.box-impl(DoubleValue.constructor-impl(0.0)));
    }

    @Override
    @NotNull
    public double[] asComplex64-3djj_bw() {
        return FloatValue.asComplex64-3djj_bw(this.value);
    }

    public static float unaryMinus-ZzhhcUg(float arg0) {
        return FloatValue.constructor-impl(-arg0);
    }

    public float unaryMinus-ZzhhcUg() {
        return FloatValue.unaryMinus-ZzhhcUg(this.value);
    }

    public static float plus-PgYoAEc(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 + ((Number)other.getValue()).floatValue());
    }

    public float plus-PgYoAEc(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.plus-PgYoAEc(this.value, other);
    }

    public static float minus-PgYoAEc(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 - ((Number)other.getValue()).floatValue());
    }

    public float minus-PgYoAEc(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.minus-PgYoAEc(this.value, other);
    }

    public static float times-PgYoAEc(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 * ((Number)other.getValue()).floatValue());
    }

    public float times-PgYoAEc(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.times-PgYoAEc(this.value, other);
    }

    public static float div-PgYoAEc(float arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.constructor-impl(arg0 / ((Number)other.getValue()).floatValue());
    }

    public float div-PgYoAEc(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatValue.div-PgYoAEc(this.value, other);
    }

    public static float abs-ZzhhcUg(float arg0) {
        return FloatValue.constructor-impl(Math.abs(arg0));
    }

    public float abs-ZzhhcUg() {
        return FloatValue.abs-ZzhhcUg(this.value);
    }

    public static double pow-iEH02FE(float arg0, double x) {
        return DoubleValue.constructor-impl((float)Math.pow(arg0, (float)x));
    }

    public double pow-iEH02FE(double x) {
        return FloatValue.pow-iEH02FE(this.value, x);
    }

    public static float pow-PgYoAEc(float arg0, int x) {
        return FloatValue.constructor-impl((float)Math.pow(arg0, x));
    }

    public float pow-PgYoAEc(int x) {
        return FloatValue.pow-PgYoAEc(this.value, x);
    }

    public static float sqrt-ZzhhcUg(float arg0) {
        return FloatValue.constructor-impl((float)Math.sqrt(arg0));
    }

    public float sqrt-ZzhhcUg() {
        return FloatValue.sqrt-ZzhhcUg(this.value);
    }

    public static double exp-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.exp(arg0));
    }

    public double exp-5B6OyQQ() {
        return FloatValue.exp-5B6OyQQ(this.value);
    }

    public static double ln-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.log(arg0));
    }

    public double ln-5B6OyQQ() {
        return FloatValue.ln-5B6OyQQ(this.value);
    }

    public static double cos-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.cos(arg0));
    }

    public double cos-5B6OyQQ() {
        return FloatValue.cos-5B6OyQQ(this.value);
    }

    public static double sin-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.sin(arg0));
    }

    public double sin-5B6OyQQ() {
        return FloatValue.sin-5B6OyQQ(this.value);
    }

    public static double tan-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.tan(arg0));
    }

    public double tan-5B6OyQQ() {
        return FloatValue.tan-5B6OyQQ(this.value);
    }

    public static double atan-5B6OyQQ(float arg0) {
        return DoubleValue.constructor-impl((float)Math.atan(arg0));
    }

    public double atan-5B6OyQQ() {
        return FloatValue.atan-5B6OyQQ(this.value);
    }

    public static String toString-impl(float arg0) {
        return "FloatValue(value=" + arg0 + ")";
    }

    public String toString() {
        return FloatValue.toString-impl(this.value);
    }

    public static int hashCode-impl(float arg0) {
        return Float.hashCode(arg0);
    }

    public int hashCode() {
        return FloatValue.hashCode-impl(this.value);
    }

    public static boolean equals-impl(float arg0, Object other) {
        if (!(other instanceof FloatValue)) {
            return false;
        }
        float f = ((FloatValue)other).unbox-impl();
        return Float.compare(arg0, f) == 0;
    }

    public boolean equals(Object other) {
        return FloatValue.equals-impl(this.value, other);
    }

    private /* synthetic */ FloatValue(float value) {
        this.value = value;
    }

    public static float constructor-impl(float value) {
        return value;
    }

    public static final /* synthetic */ FloatValue box-impl(float v) {
        return new FloatValue(v);
    }

    public final /* synthetic */ float unbox-impl() {
        return this.value;
    }

    public static final boolean equals-impl0(float p1, float p2) {
        return Float.compare(p1, p2) == 0;
    }

    @JvmStatic
    public static final float of-PgYoAEc(float value) {
        return Companion.of-PgYoAEc(value);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u00c6\u0001R\u0019\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\b\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\t\u0010\u0006R\u0019\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000b\u0010\u0006R\u0019\u0010\f\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\r\u0010\u0006R\u0019\u0010\u000e\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000f\u0010\u0006R\u0019\u0010\u0010\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0011\u0010\u0006\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/core/values/FloatValue$Companion;", "", "()V", "INF", "Lorg/vitrivr/cottontail/core/values/FloatValue;", "getINF-ZzhhcUg", "()F", "F", "MAX_VALUE", "getMAX_VALUE-ZzhhcUg", "MIN_VALUE", "getMIN_VALUE-ZzhhcUg", "NaN", "getNaN-ZzhhcUg", "ONE", "getONE-ZzhhcUg", "ZERO", "getZERO-ZzhhcUg", "of", "value", "", "of-PgYoAEc", "(F)F", "serializer", "Lkotlinx/serialization/KSerializer;", "cottontaildb-client"})
    public static final class Companion {
        private Companion() {
        }

        public final float getMIN_VALUE-ZzhhcUg() {
            return MIN_VALUE;
        }

        public final float getMAX_VALUE-ZzhhcUg() {
            return MAX_VALUE;
        }

        public final float getZERO-ZzhhcUg() {
            return ZERO;
        }

        public final float getONE-ZzhhcUg() {
            return ONE;
        }

        public final float getNaN-ZzhhcUg() {
            return NaN;
        }

        public final float getINF-ZzhhcUg() {
            return INF;
        }

        @JvmStatic
        public final float of-PgYoAEc(float value) {
            return FloatValue.constructor-impl(value);
        }

        @NotNull
        public final KSerializer<FloatValue> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

