/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.types.NumericValue;
import org.vitrivr.cottontail.core.types.RealValue;
import org.vitrivr.cottontail.core.types.RealVectorValue;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.FloatValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue$;
import org.vitrivr.cottontail.core.values.PublicValue;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Serializable
@SerialName(value="FloatVector")
@JvmInline
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0087@\u0018\u0000 |2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002{|B\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\u0007\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0007\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0007\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0007\u0010\u0014B\u000f\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0017J\u0015\u0010&\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b'\u0010\u0017J\u000f\u0010(\u001a\u00020)H\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020)H\u0016\u00a2\u0006\u0004\b-\u0010+J\u0018\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0096\u0002\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u0010\u0017J\"\u00105\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000306H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b7\u00108J\"\u00105\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b7\u0010:J\"\u0010;\u001a\u00020<2\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b=\u0010>J\u001a\u0010?\u001a\u00020)2\b\u0010/\u001a\u0004\u0018\u00010@H\u00d6\u0003\u00a2\u0006\u0004\bA\u0010BJ\u001e\u0010C\u001a\u00020<2\u0006\u0010D\u001a\u00020\u001fH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010G\u001a\u00020)2\u0006\u0010D\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\bH\u0010IJ\"\u0010J\u001a\u00020<2\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bK\u0010>J\u0010\u0010L\u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\bM\u0010!J\u0017\u0010N\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0016\u00a2\u0006\u0004\bO\u0010PJ\"\u0010Q\u001a\u00020R2\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bS\u0010TJ\"\u0010U\u001a\u00020R2\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bV\u0010TJ)\u0010W\u001a\u00020R2\n\u0010/\u001a\u0006\u0012\u0002\b\u0003092\u0006\u0010X\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bY\u0010ZJ\"\u0010[\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000306H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\\\u00108J\"\u0010[\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\\\u0010:J\u0015\u0010]\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b^\u0010\u0017J\u0015\u0010_\u001a\u00020<H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b`\u0010aJ\"\u0010b\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000306H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bc\u00108J\"\u0010b\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bc\u0010:J\u001d\u0010d\u001a\u00020\u00002\u0006\u0010e\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bf\u0010gJ%\u0010h\u001a\u00020\u00002\u0006\u0010i\u001a\u00020\u001f2\u0006\u0010j\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bk\u0010lJ\u0015\u0010m\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bn\u0010\u0017J\u0015\u0010o\u001a\u00020<H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bp\u0010aJ\"\u0010q\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000306H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\br\u00108J\"\u0010q\u001a\u00020\u00002\n\u0010/\u001a\u0006\u0012\u0002\b\u000309H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\br\u0010:J\u000f\u0010s\u001a\u00020tH\u0016\u00a2\u0006\u0004\bu\u0010vJ\u0010\u0010w\u001a\u00020xH\u00d6\u0001\u00a2\u0006\u0004\by\u0010zR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\u0006\u0012\u0002\b\u00030#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u0088\u0001\u0015\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006}"}, d2={"Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "Lorg/vitrivr/cottontail/core/types/RealVectorValue;", "", "Lorg/vitrivr/cottontail/core/values/PublicValue;", "input", "", "", "constructor-impl", "(Ljava/util/List;)[F", "", "([Ljava/lang/Number;)[F", "", "([D)[F", "", "([J)[F", "", "([I)[F", "Ljava/nio/FloatBuffer;", "(Ljava/nio/FloatBuffer;)[F", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)[F", "data", "", "([F)[F", "getData", "()[F", "indices", "Lkotlin/ranges/IntRange;", "getIndices-impl", "([F)Lkotlin/ranges/IntRange;", "logicalSize", "", "getLogicalSize-impl", "([F)I", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType-impl", "([F)Lorg/vitrivr/cottontail/core/types/Types;", "abs", "abs-JdBqzJc", "allOnes", "", "allOnes-impl", "([F)Z", "allZeros", "allZeros-impl", "compareTo", "other", "Lorg/vitrivr/cottontail/core/types/Value;", "compareTo-impl", "([FLorg/vitrivr/cottontail/core/types/Value;)I", "copy", "copy-JdBqzJc", "div", "Lorg/vitrivr/cottontail/core/types/NumericValue;", "div-_dZwee4", "([FLorg/vitrivr/cottontail/core/types/NumericValue;)[F", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "([FLorg/vitrivr/cottontail/core/types/VectorValue;)[F", "dot", "Lorg/vitrivr/cottontail/core/values/FloatValue;", "dot-PgYoAEc", "([FLorg/vitrivr/cottontail/core/types/VectorValue;)F", "equals", "", "equals-impl", "([FLjava/lang/Object;)Z", "get", "i", "get-PgYoAEc", "([FI)F", "getAsBool", "getAsBool-impl", "([FI)Z", "hamming", "hamming-PgYoAEc", "hashCode", "hashCode-impl", "isEqual", "isEqual-impl", "([FLorg/vitrivr/cottontail/core/types/Value;)Z", "l1", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "l1-iEH02FE", "([FLorg/vitrivr/cottontail/core/types/VectorValue;)D", "l2", "l2-iEH02FE", "lp", "p", "lp-hmZlhvs", "([FLorg/vitrivr/cottontail/core/types/VectorValue;I)D", "minus", "minus-_dZwee4", "new", "new-JdBqzJc", "norm2", "norm2-ZzhhcUg", "([F)F", "plus", "plus-_dZwee4", "pow", "x", "pow-_dZwee4", "([FI)[F", "slice", "start", "length", "slice-c1F3drA", "([FII)[F", "sqrt", "sqrt-JdBqzJc", "sum", "sum-ZzhhcUg", "times", "times-_dZwee4", "toGrpc", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Literal;", "toGrpc-impl", "([F)Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Literal;", "toString", "", "toString-impl", "([F)Ljava/lang/String;", "$serializer", "Companion", "cottontaildb-client"})
@SourceDebugExtension(value={"SMAP\nFloatVectorValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloatVectorValue.kt\norg/vitrivr/cottontail/core/values/FloatVectorValue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,307:1\n1#2:308\n1549#3:309\n1620#3,3:310\n12341#4,2:313\n12341#4,2:315\n*S KotlinDebug\n*F\n+ 1 FloatVectorValue.kt\norg/vitrivr/cottontail/core/values/FloatVectorValue\n*L\n75#1:309\n75#1:310,3\n117#1:313,2\n124#1:315,2\n*E\n"})
public final class FloatVectorValue
implements RealVectorValue<Float>,
PublicValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] data;

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull List<? extends Number> input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        int n = 0;
        int n2 = input.size();
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = input.get(n3).floatValue();
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull Number[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = 0;
        int n2 = input.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = input[n3].floatValue();
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull double[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = 0;
        int n2 = input.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)input[n3];
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull long[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = 0;
        int n2 = input.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = input[n3];
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull int[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = 0;
        int n2 = input.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = input[n3];
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull FloatBuffer input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int n = 0;
        int n2 = input.remaining();
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = input.get(n3);
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public static float[] constructor-impl(@NotNull ByteBuffer input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        FloatBuffer floatBuffer = input.asFloatBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"asFloatBuffer(...)");
        return FloatVectorValue.constructor-impl(floatBuffer);
    }

    public static int getLogicalSize-impl(float[] arg0) {
        return arg0.length;
    }

    @Override
    public int getLogicalSize() {
        return FloatVectorValue.getLogicalSize-impl(this.data);
    }

    @NotNull
    public static Types<?> getType-impl(float[] arg0) {
        return new Types.FloatVector(FloatVectorValue.getLogicalSize-impl(arg0));
    }

    @Override
    @NotNull
    public Types<?> getType() {
        return FloatVectorValue.getType-impl(this.data);
    }

    public static int compareTo-impl(float[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof FloatVectorValue)) {
            boolean bl = false;
            String string = "FloatVectorValue can only be compared to another FloatVectorValue. This is a programmer's error!";
            throw new IllegalArgumentException(string.toString());
        }
        return Arrays.compare(arg0, ((FloatVectorValue)other).unbox-impl());
    }

    @Override
    public int compareTo(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatVectorValue.compareTo-impl(this.data, other);
    }

    public static boolean isEqual-impl(float[] arg0, @NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof FloatVectorValue && Arrays.equals(arg0, ((FloatVectorValue)other).unbox-impl());
    }

    @Override
    public boolean isEqual(@NotNull Value other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return FloatVectorValue.isEqual-impl(this.data, other);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static CottontailGrpc.Literal toGrpc-impl(float[] arg0) {
        Collection<Float> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FloatVectorValue floatVectorValue = FloatVectorValue.box-impl(arg0);
        CottontailGrpc.FloatVector.Builder builder = CottontailGrpc.FloatVector.newBuilder();
        CottontailGrpc.Vector.Builder builder2 = CottontailGrpc.Vector.newBuilder();
        CottontailGrpc.Literal.Builder builder3 = CottontailGrpc.Literal.newBuilder();
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RealValue realValue = (RealValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(((Number)it.getValue()).floatValue()));
        }
        collection = (List)destination$iv$iv;
        CottontailGrpc.Literal literal = builder3.setVectorData(builder2.setFloat(builder.addAllVector((Iterable<? extends Float>)collection))).build();
        Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"build(...)");
        return literal;
    }

    @Override
    @NotNull
    public CottontailGrpc.Literal toGrpc() {
        return FloatVectorValue.toGrpc-impl(this.data);
    }

    @NotNull
    public static IntRange getIndices-impl(float[] arg0) {
        return ArraysKt.getIndices((float[])arg0);
    }

    @Override
    @NotNull
    public IntRange getIndices() {
        return FloatVectorValue.getIndices-impl(this.data);
    }

    public static float get-PgYoAEc(float[] arg0, int i) {
        return FloatValue.constructor-impl(arg0[i]);
    }

    public float get-PgYoAEc(int i) {
        return FloatVectorValue.get-PgYoAEc(this.data, i);
    }

    @NotNull
    public static float[] slice-c1F3drA(float[] arg0, int start, int length) {
        float[] fArray = arg0;
        int n = start + length;
        return FloatVectorValue.constructor-impl(ArraysKt.copyOfRange((float[])fArray, (int)start, (int)n));
    }

    @NotNull
    public float[] slice-c1F3drA(int start, int length) {
        return FloatVectorValue.slice-c1F3drA(this.data, start, length);
    }

    public static boolean getAsBool-impl(float[] arg0, int i) {
        return !(arg0[i] == 0.0f);
    }

    @Override
    public boolean getAsBool(int i) {
        return FloatVectorValue.getAsBool-impl(this.data, i);
    }

    public static boolean allZeros-impl(float[] arg0) {
        boolean bl;
        block1: {
            float[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                float element$iv;
                float it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == 0.0f) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allZeros() {
        return FloatVectorValue.allZeros-impl(this.data);
    }

    public static boolean allOnes-impl(float[] arg0) {
        boolean bl;
        block1: {
            float[] $this$all$iv = arg0;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                float element$iv;
                float it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == 1.0f) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean allOnes() {
        return FloatVectorValue.allOnes-impl(this.data);
    }

    @NotNull
    public static float[] copy-JdBqzJc(float[] arg0) {
        float[] fArray = Arrays.copyOf(arg0, arg0.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] copy-JdBqzJc() {
        return FloatVectorValue.copy-JdBqzJc(this.data);
    }

    @NotNull
    public static float[] new-JdBqzJc(float[] arg0) {
        return FloatVectorValue.constructor-impl(new float[arg0.length]);
    }

    @NotNull
    public float[] new-JdBqzJc() {
        return FloatVectorValue.new-JdBqzJc(this.data);
    }

    @NotNull
    public static float[] plus-_dZwee4(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            int n = 0;
            int n2 = arg0.length;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] + ((FloatVectorValue)other).unbox-impl()[n3];
            }
            fArray = FloatVectorValue.constructor-impl(fArray2);
        } else {
            int n = 0;
            int n4 = arg0.length;
            float[] fArray3 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray3[n5] = arg0[n5] + other.get(n5).asFloat-ZzhhcUg();
            }
            fArray = FloatVectorValue.constructor-impl(fArray3);
        }
        return fArray;
    }

    @NotNull
    public float[] plus-_dZwee4(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.plus-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] minus-_dZwee4(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            int n = 0;
            int n2 = arg0.length;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] - ((FloatVectorValue)other).unbox-impl()[n3];
            }
            fArray = FloatVectorValue.constructor-impl(fArray2);
        } else {
            int n = 0;
            int n4 = arg0.length;
            float[] fArray3 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray3[n5] = arg0[n5] - other.get(n5).asFloat-ZzhhcUg();
            }
            fArray = FloatVectorValue.constructor-impl(fArray3);
        }
        return fArray;
    }

    @NotNull
    public float[] minus-_dZwee4(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.minus-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] times-_dZwee4(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            int n = 0;
            int n2 = arg0.length;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] * ((FloatVectorValue)other).unbox-impl()[n3];
            }
            fArray = FloatVectorValue.constructor-impl(fArray2);
        } else {
            int n = 0;
            int n4 = arg0.length;
            float[] fArray3 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray3[n5] = arg0[n5] * other.get(n5).asFloat-ZzhhcUg();
            }
            fArray = FloatVectorValue.constructor-impl(fArray3);
        }
        return fArray;
    }

    @NotNull
    public float[] times-_dZwee4(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.times-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] div-_dZwee4(float[] arg0, @NotNull VectorValue<?> other) {
        float[] fArray;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            int n = 0;
            int n2 = arg0.length;
            float[] fArray2 = new float[n2];
            while (n < n2) {
                int n3 = n++;
                fArray2[n3] = arg0[n3] / ((FloatVectorValue)other).unbox-impl()[n3];
            }
            fArray = FloatVectorValue.constructor-impl(fArray2);
        } else {
            int n = 0;
            int n4 = arg0.length;
            float[] fArray3 = new float[n4];
            while (n < n4) {
                int n5 = n++;
                fArray3[n5] = arg0[n5] / other.get(n5).asFloat-ZzhhcUg();
            }
            fArray = FloatVectorValue.constructor-impl(fArray3);
        }
        return fArray;
    }

    @NotNull
    public float[] div-_dZwee4(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.div-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] plus-_dZwee4(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        float otherAsFloat = other.asFloat-ZzhhcUg();
        int n = 0;
        int n2 = FloatVectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[n3] + otherAsFloat;
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] plus-_dZwee4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.plus-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] minus-_dZwee4(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        float otherAsFloat = other.asFloat-ZzhhcUg();
        int n = 0;
        int n2 = FloatVectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[n3] - otherAsFloat;
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] minus-_dZwee4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.minus-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] times-_dZwee4(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        float otherAsFloat = other.asFloat-ZzhhcUg();
        int n = 0;
        int n2 = FloatVectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[n3] * otherAsFloat;
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] times-_dZwee4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.times-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] div-_dZwee4(float[] arg0, @NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        float otherAsFloat = other.asFloat-ZzhhcUg();
        int n = 0;
        int n2 = FloatVectorValue.getLogicalSize-impl(arg0);
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = arg0[n3] / otherAsFloat;
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] div-_dZwee4(@NotNull NumericValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.div-_dZwee4(this.data, other);
    }

    @NotNull
    public static float[] pow-_dZwee4(float[] arg0, int x) {
        int n = 0;
        int n2 = arg0.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)Math.pow(arg0[n3], x);
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] pow-_dZwee4(int x) {
        return FloatVectorValue.pow-_dZwee4(this.data, x);
    }

    @NotNull
    public static float[] sqrt-JdBqzJc(float[] arg0) {
        int n = 0;
        int n2 = arg0.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = (float)Math.sqrt(arg0[n3]);
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] sqrt-JdBqzJc() {
        return FloatVectorValue.sqrt-JdBqzJc(this.data);
    }

    @NotNull
    public static float[] abs-JdBqzJc(float[] arg0) {
        int n = 0;
        int n2 = arg0.length;
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = Math.abs(arg0[n3]);
        }
        return FloatVectorValue.constructor-impl(fArray);
    }

    @NotNull
    public float[] abs-JdBqzJc() {
        return FloatVectorValue.abs-JdBqzJc(this.data);
    }

    public static float sum-ZzhhcUg(float[] arg0) {
        return FloatValue.constructor-impl(ArraysKt.sum((float[])arg0));
    }

    public float sum-ZzhhcUg() {
        return FloatVectorValue.sum-ZzhhcUg(this.data);
    }

    public static float norm2-ZzhhcUg(float[] arg0) {
        int n;
        float sum = 0.0f;
        IntRange intRange = FloatVectorValue.getIndices-impl(arg0);
        int i = intRange.getFirst();
        if (i <= (n = intRange.getLast())) {
            while (true) {
                sum += (float)Math.pow(arg0[i], 2);
                if (i == n) break;
                ++i;
            }
        }
        return FloatValue.constructor-impl((float)Math.sqrt(sum));
    }

    public float norm2-ZzhhcUg() {
        return FloatVectorValue.norm2-ZzhhcUg(this.data);
    }

    public static float dot-PgYoAEc(float[] arg0, @NotNull VectorValue<?> other) {
        float f;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            float sum = 0.0f;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum = Math.fma(arg0[i], ((FloatVectorValue)other).unbox-impl()[i], sum);
            }
            f = FloatValue.constructor-impl(sum);
        } else {
            float sum = 0.0f;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += Math.fma(arg0[i], ((Number)other.get(i).getValue()).floatValue(), sum);
            }
            f = FloatValue.constructor-impl(sum);
        }
        return f;
    }

    public float dot-PgYoAEc(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.dot-PgYoAEc(this.data, other);
    }

    public static double l1-iEH02FE(float[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += (double)Math.abs(arg0[i] - ((FloatVectorValue)other).unbox-impl()[i]);
            }
            d = DoubleValue.constructor-impl(sum);
        } else {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += Math.abs((double)arg0[i] - ((Number)other.get(i).getValue()).doubleValue());
            }
            d = DoubleValue.constructor-impl(sum);
        }
        return d;
    }

    public double l1-iEH02FE(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.l1-iEH02FE(this.data, other);
    }

    public static double l2-iEH02FE(float[] arg0, @NotNull VectorValue<?> other) {
        double d;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += (double)((float)Math.pow(arg0[i] - ((FloatVectorValue)other).unbox-impl()[i], 2));
            }
            d = DoubleValue.constructor-impl(Math.sqrt(sum));
        } else {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += Math.pow((double)arg0[i] - ((Number)other.get(i).getValue()).doubleValue(), 2);
            }
            d = DoubleValue.constructor-impl(Math.sqrt(sum));
        }
        return d;
    }

    public double l2-iEH02FE(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.l2-iEH02FE(this.data, other);
    }

    public static double lp-hmZlhvs(float[] arg0, @NotNull VectorValue<?> other, int p) {
        double d;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += (double)((float)Math.pow(Math.abs(arg0[i] - ((FloatVectorValue)other).unbox-impl()[i]), p));
            }
            d = DoubleValue.constructor-impl(Math.pow(sum, 1.0 / (double)p));
        } else {
            double sum = 0.0;
            int n = arg0.length;
            for (int i = 0; i < n; ++i) {
                sum += Math.pow(Math.abs((double)arg0[i] - ((Number)other.get(i).getValue()).doubleValue()), p);
            }
            d = DoubleValue.constructor-impl(Math.pow(sum, 1.0 / (double)p));
        }
        return d;
    }

    public double lp-hmZlhvs(@NotNull VectorValue<?> other, int p) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.lp-hmZlhvs(this.data, other, p);
    }

    public static float hamming-PgYoAEc(float[] arg0, @NotNull VectorValue<?> other) {
        float f;
        Intrinsics.checkNotNullParameter(other, (String)"other");
        if (other instanceof FloatVectorValue) {
            int start;
            float sum = 0.0f;
            int n = ((FloatVectorValue)other).unbox-impl().length;
            for (int i = start = Arrays.mismatch(arg0, ((FloatVectorValue)other).unbox-impl()); i < n; ++i) {
                if (arg0[i] == ((FloatVectorValue)other).unbox-impl()[i]) continue;
                sum += 1.0f;
            }
            f = FloatValue.constructor-impl(sum);
        } else {
            f = FloatValue.constructor-impl((Number)arg0.length);
        }
        return f;
    }

    public float hamming-PgYoAEc(@NotNull VectorValue<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return FloatVectorValue.hamming-PgYoAEc(this.data, other);
    }

    @NotNull
    public static Iterator<RealValue<Float>> iterator-impl(float[] arg0) {
        return FloatVectorValue.box-impl(arg0).iterator();
    }

    @Override
    @NotNull
    public Iterator<RealValue<Float>> iterator() {
        return RealVectorValue.DefaultImpls.iterator(this);
    }

    public static String toString-impl(float[] arg0) {
        return "FloatVectorValue(data=" + Arrays.toString(arg0) + ")";
    }

    public String toString() {
        return FloatVectorValue.toString-impl(this.data);
    }

    public static int hashCode-impl(float[] arg0) {
        return Arrays.hashCode(arg0);
    }

    public int hashCode() {
        return FloatVectorValue.hashCode-impl(this.data);
    }

    public static boolean equals-impl(float[] arg0, Object other) {
        if (!(other instanceof FloatVectorValue)) {
            return false;
        }
        return Intrinsics.areEqual((Object)arg0, (Object)((FloatVectorValue)other).unbox-impl());
    }

    public boolean equals(Object other) {
        return FloatVectorValue.equals-impl(this.data, other);
    }

    private /* synthetic */ FloatVectorValue(float[] data) {
        this.data = data;
    }

    @NotNull
    public static float[] constructor-impl(@NotNull float[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data;
    }

    public static final /* synthetic */ FloatVectorValue box-impl(float[] v) {
        return new FloatVectorValue(v);
    }

    public final /* synthetic */ float[] unbox-impl() {
        return this.data;
    }

    public static final boolean equals-impl0(float[] p1, float[] p2) {
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    @JvmStatic
    @NotNull
    public static final float[] of-_dZwee4(@NotNull float[] array) {
        return Companion.of-_dZwee4(array);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0001\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/core/values/FloatVectorValue$Companion;", "", "()V", "of", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "array", "", "of-_dZwee4", "([F)[F", "serializer", "Lkotlinx/serialization/KSerializer;", "cottontaildb-client"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final float[] of-_dZwee4(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return FloatVectorValue.constructor-impl(array);
        }

        @NotNull
        public final KSerializer<FloatVectorValue> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

