/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.queries.functions;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H&J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H&J\b\u0010\u0007\u001a\u00020\bH&\u0082\u0001\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "", "isCompatible", "", "argument", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "toOpen", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "Numeric", "Open", "Scalar", "Typed", "Vector", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Typed;", "cottontaildb-core"})
public interface Argument {
    public boolean isCompatible(@NotNull Argument var1);

    public boolean isCompatible(@Nullable Value var1);

    @NotNull
    public Open toOpen();

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument$Numeric;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "()V", "isCompatible", "", "argument", "Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "toString", "", "cottontaildb-core"})
    public static final class Numeric
    implements Open {
        @NotNull
        public static final Numeric INSTANCE = new Numeric();

        private Numeric() {
        }

        @Override
        public boolean isCompatible(@NotNull Argument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return argument instanceof Typed && ((Typed)argument).getType() instanceof Types.Numeric;
        }

        @Override
        public boolean isCompatible(@Nullable Value value) {
            return value == null || value.getType() instanceof Types.Numeric;
        }

        @NotNull
        public String toString() {
            return "Open[Numeric]";
        }

        @Override
        @NotNull
        public Open toOpen() {
            return Open.DefaultImpls.toOpen(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0000H\u0016\u0082\u0001\u0003\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "toOpen", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Numeric;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Scalar;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Vector;", "cottontaildb-core"})
    public static interface Open
    extends Argument {
        @Override
        @NotNull
        public Open toOpen();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static Open toOpen(@NotNull Open $this) {
                return $this;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument$Scalar;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "()V", "isCompatible", "", "argument", "Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "toString", "", "cottontaildb-core"})
    public static final class Scalar
    implements Open {
        @NotNull
        public static final Scalar INSTANCE = new Scalar();

        private Scalar() {
        }

        @Override
        public boolean isCompatible(@NotNull Argument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return argument instanceof Typed && ((Typed)argument).getType() instanceof Types.Scalar;
        }

        @Override
        public boolean isCompatible(@Nullable Value value) {
            return value == null || value.getType() instanceof Types.Scalar;
        }

        @NotNull
        public String toString() {
            return "Open[Scalar]";
        }

        @Override
        @NotNull
        public Open toOpen() {
            return Open.DefaultImpls.toOpen(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument$Typed;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "(Lorg/vitrivr/cottontail/core/types/Types;)V", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isCompatible", "argument", "value", "toOpen", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "toString", "", "cottontaildb-core"})
    public static final class Typed<T extends Value>
    implements Argument {
        @NotNull
        private final Types<T> type;

        public Typed(@NotNull Types<T> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final Types<T> getType() {
            return this.type;
        }

        @Override
        public boolean isCompatible(@NotNull Argument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return Intrinsics.areEqual((Object)this, (Object)argument);
        }

        @Override
        public boolean isCompatible(@Nullable Value value) {
            return value == null || Intrinsics.areEqual((Object)value.getType(), this.type);
        }

        @Override
        @NotNull
        public Open toOpen() {
            Open open;
            Types<T> types = this.type;
            if (types instanceof Types.Vector) {
                open = Vector.INSTANCE;
            } else if (types instanceof Types.Numeric) {
                open = Numeric.INSTANCE;
            } else if (types instanceof Types.Scalar) {
                open = Scalar.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return open;
        }

        @NotNull
        public String toString() {
            return "Typed[" + this.type + "]";
        }

        @NotNull
        public final Types<T> component1() {
            return this.type;
        }

        @NotNull
        public final Typed<T> copy(@NotNull Types<T> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            return new Typed<T>(type);
        }

        public static /* synthetic */ Typed copy$default(Typed typed, Types types, int n, Object object) {
            if ((n & 1) != 0) {
                types = typed.type;
            }
            return typed.copy(types);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Typed)) {
                return false;
            }
            Typed typed = (Typed)other;
            return Intrinsics.areEqual(this.type, typed.type);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/Argument$Vector;", "Lorg/vitrivr/cottontail/core/queries/functions/Argument$Open;", "()V", "isCompatible", "", "argument", "Lorg/vitrivr/cottontail/core/queries/functions/Argument;", "value", "Lorg/vitrivr/cottontail/core/types/Value;", "toString", "", "cottontaildb-core"})
    public static final class Vector
    implements Open {
        @NotNull
        public static final Vector INSTANCE = new Vector();

        private Vector() {
        }

        @Override
        public boolean isCompatible(@NotNull Argument argument) {
            Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
            return argument instanceof Typed && ((Typed)argument).getType() instanceof Types.Vector;
        }

        @Override
        public boolean isCompatible(@Nullable Value value) {
            return value == null || value.getType() instanceof Types.Vector;
        }

        @NotNull
        public String toString() {
            return "Open[Vector]";
        }

        @Override
        @NotNull
        public Open toOpen() {
            return Open.DefaultImpls.toOpen(this);
        }
    }
}

