/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.queries.functions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.FunctionGenerator;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.exception.FunctionNotFoundException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fJ\u0012\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000b\u001a\u00020\u0005J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tJ\u0018\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u00122\u0006\u0010\u000b\u001a\u00020\bJ\u0012\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000b\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "", "()V", "functions", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$SemiClosed;", "Lorg/vitrivr/cottontail/core/queries/functions/Function;", "generators", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Open;", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionGenerator;", "obtain", "signature", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "register", "", "function", "generator", "resolve", "", "cottontaildb-core"})
@SourceDebugExtension(value={"SMAP\nFunctionRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionRegistry.kt\norg/vitrivr/cottontail/core/queries/functions/FunctionRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1#2:100\n1747#3,3:101\n*S KotlinDebug\n*F\n+ 1 FunctionRegistry.kt\norg/vitrivr/cottontail/core/queries/functions/FunctionRegistry\n*L\n51#1:101,3\n*E\n"})
public final class FunctionRegistry {
    @NotNull
    private final Map<Signature.Open, FunctionGenerator<?>> generators = new LinkedHashMap();
    @NotNull
    private final Map<Signature.SemiClosed, Function<?>> functions = new LinkedHashMap();

    public final void register(@NotNull Function<?> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Signature.SemiClosed semiClosed = function.getSignature().toSemiClosed();
        Signature.Open open = semiClosed.toOpen();
        if (!(!this.functions.containsKey(semiClosed))) {
            boolean $i$a$-check-FunctionRegistry$register$32 = false;
            String $i$a$-check-FunctionRegistry$register$32 = "Function for signature " + function.getSignature() + " collides with existing function.";
            throw new IllegalStateException($i$a$-check-FunctionRegistry$register$32.toString());
        }
        if (!(!this.generators.containsKey(open))) {
            boolean bl = false;
            String string = "Function for signature " + function.getSignature() + " collides with existing generator.";
            throw new IllegalStateException(string.toString());
        }
        this.functions.put(semiClosed, function);
    }

    public final void register(@NotNull FunctionGenerator<?> generator) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            if (!(!this.generators.containsKey(generator.getSignature()))) {
                boolean $i$a$-check-FunctionRegistry$register$42 = false;
                String $i$a$-check-FunctionRegistry$register$42 = "Function generator for signature " + generator.getSignature() + " collides with existing generator.";
                throw new IllegalStateException($i$a$-check-FunctionRegistry$register$42.toString());
            }
            Iterable $this$any$iv = this.functions.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Signature.SemiClosed it = (Signature.SemiClosed)element$iv;
                    boolean bl2 = false;
                    if (!generator.getSignature().collides(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (!(!bl)) {
            boolean bl3 = false;
            String string = "Function generator for signature " + generator.getSignature() + " collides with existing generator.";
            throw new IllegalStateException(string.toString());
        }
        this.generators.put(generator.getSignature(), generator);
    }

    @NotNull
    public final List<Signature.Closed<?>> resolve(@NotNull Signature.Open signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        FunctionGenerator<?> functionGenerator = this.generators.get(signature);
        if (functionGenerator == null) {
            throw new FunctionNotFoundException(signature);
        }
        FunctionGenerator<?> generator = functionGenerator;
        return generator.resolve(signature);
    }

    @NotNull
    public final Signature.Closed<?> resolve(@NotNull Signature.SemiClosed signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Function<?> function = this.functions.get(signature);
        if (function != null) {
            return function.getSignature();
        }
        FunctionGenerator<?> functionGenerator = this.generators.get(signature.toOpen());
        if (functionGenerator == null) {
            throw new FunctionNotFoundException(signature);
        }
        FunctionGenerator<?> generator = functionGenerator;
        return generator.resolve(signature);
    }

    @NotNull
    public final Function<?> obtain(@NotNull Signature.SemiClosed signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Function<?> function = this.functions.get(signature);
        if (function != null) {
            return function;
        }
        FunctionGenerator<?> functionGenerator = this.generators.get(signature.toOpen());
        if (functionGenerator == null) {
            throw new FunctionNotFoundException(signature);
        }
        FunctionGenerator<?> generator = functionGenerator;
        return generator.obtain(signature);
    }

    @NotNull
    public final Function<?> obtain(@NotNull Signature.Closed<?> signature) {
        Intrinsics.checkNotNullParameter(signature, (String)"signature");
        return this.obtain(signature.toSemiClosed());
    }
}

