/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.queries.functions.math.distance.binary;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Argument;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.FunctionGenerator;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.exception.FunctionNotSupportedException;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.types.VectorValue;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u0011*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0011\u0012\u0013\u0014\u0015B\u0019\b\u0004\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0004R\u001a\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0004\u0016\u0017\u0018\u0019\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance;", "T", "Lorg/vitrivr/cottontail/core/types/VectorValue;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "type", "Lorg/vitrivr/cottontail/core/types/Types$Vector;", "(Lorg/vitrivr/cottontail/core/types/Types$Vector;)V", "cost", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "getCost-7CRCzCo", "()[F", "haversine", "", "aLat", "aLon", "bLat", "bLon", "Companion", "DoubleVector", "FloatVector", "IntVector", "LongVector", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$DoubleVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$FloatVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$IntVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$LongVector;", "cottontaildb-core"})
public abstract class HaversineDistance<T extends VectorValue<?>>
extends VectorDistance<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Name.FunctionName FUNCTION_NAME = Name.FunctionName.Companion.create("haversine");
    public static final double RADIUS_EARTH = 6371000.0;

    private HaversineDistance(Types.Vector<T, ?> type) {
        super(type, null);
    }

    @Override
    @NotNull
    public float[] getCost-7CRCzCo() {
        return Cost.times-7eHliGg(Cost.plus-wQ19W7k(Cost.times-7eHliGg(Cost.Companion.getFLOP-7CRCzCo(), Float.valueOf(27.0f)), Cost.times-7eHliGg(Cost.Companion.getMEMORY_ACCESS-7CRCzCo(), Float.valueOf(22.0f))), this.getVectorSize());
    }

    protected final double haversine(double aLat, double aLon, double bLat, double bLon) {
        double phi1 = StrictMath.toRadians(aLat);
        double phi2 = StrictMath.toRadians(bLat);
        double deltaPhi = StrictMath.toRadians(bLat - aLat);
        double deltaLambda = StrictMath.toRadians(bLon - aLon);
        double c = Math.sin(deltaPhi / 2.0) * Math.sin(deltaPhi / 2.0) + Math.cos(phi1) * Math.cos(phi2) * Math.sin(deltaLambda / 2.0) * Math.sin(deltaLambda / 2.0);
        double d = 2.0 * Math.atan2(Math.sqrt(c), Math.sqrt(1.0 - c));
        return 6371000.0 * d;
    }

    public /* synthetic */ HaversineDistance(Types.Vector type, DefaultConstructorMarker $constructor_marker) {
        this(type);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$Companion;", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionGenerator;", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "()V", "FUNCTION_NAME", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getFUNCTION_NAME", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "RADIUS_EARTH", "", "signature", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Open;", "getSignature", "()Lorg/vitrivr/cottontail/core/queries/functions/Signature$Open;", "obtain", "Lorg/vitrivr/cottontail/core/queries/functions/Function;", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$SemiClosed;", "resolve", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "cottontaildb-core"})
    @SourceDebugExtension(value={"SMAP\nHaversineDistance.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HaversineDistance.kt\norg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n1#2:132\n12474#3,2:133\n*S KotlinDebug\n*F\n+ 1 HaversineDistance.kt\norg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$Companion\n*L\n37#1:133,2\n*E\n"})
    public static final class Companion
    implements FunctionGenerator<DoubleValue> {
        private Companion() {
        }

        @NotNull
        public final Name.FunctionName getFUNCTION_NAME() {
            return FUNCTION_NAME;
        }

        @Override
        @NotNull
        public Signature.Open getSignature() {
            Argument.Open[] openArray = new Argument.Open[]{Argument.Vector.INSTANCE, Argument.Vector.INSTANCE};
            return new Signature.Open(this.getFUNCTION_NAME(), openArray);
        }

        @Override
        @NotNull
        public Function<DoubleValue> obtain(@NotNull Signature.SemiClosed signature) {
            Function function;
            boolean bl;
            block11: {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                if (!Companion.getSignature().collides(signature)) {
                    boolean $i$a$-check-HaversineDistance$Companion$obtain$22 = false;
                    String $i$a$-check-HaversineDistance$Companion$obtain$22 = "Provided signature " + signature + " is incompatible with generator signature " + Companion.getSignature() + ". This is a programmer's error!";
                    throw new IllegalStateException($i$a$-check-HaversineDistance$Companion$obtain$22.toString());
                }
                Argument.Typed<?>[] $this$any$iv = signature.getArguments();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    Argument.Typed<?> element$iv;
                    Argument.Typed<?> it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it, signature.getArguments()[0]))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
            if (bl) {
                throw new FunctionNotSupportedException("Function generator " + Companion.getSignature() + " cannot generate function with signature " + signature + ".");
            }
            Types<?> type = signature.getArguments()[0].getType();
            if (type instanceof Types.DoubleVector) {
                function = new DoubleVector((Types.Vector<DoubleVectorValue, ?>)((Types.Vector)type));
            } else if (type instanceof Types.FloatVector) {
                function = new FloatVector((Types.Vector<FloatVectorValue, ?>)((Types.Vector)type));
            } else if (type instanceof Types.LongVector) {
                function = new LongVector((Types.Vector<LongVectorValue, ?>)((Types.Vector)type));
            } else if (type instanceof Types.IntVector) {
                function = new IntVector((Types.Vector<IntVectorValue, ?>)((Types.Vector)type));
            } else {
                throw new FunctionNotSupportedException("Function generator " + Companion.getSignature() + " cannot generate function with signature " + signature + ".");
            }
            return function;
        }

        @Override
        @NotNull
        public List<Signature.Closed<?>> resolve(@NotNull Signature.Open signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            if (!Intrinsics.areEqual((Object)Companion.getSignature(), (Object)signature)) {
                throw new FunctionNotSupportedException("Function generator " + Companion.getSignature() + " cannot generate function with signature " + signature + ".");
            }
            Object[] objectArray = new Signature.Closed[]{new DoubleVector((Types.Vector<DoubleVectorValue, ?>)((Types.Vector)new Types.DoubleVector(2))).getSignature(), new FloatVector((Types.Vector<FloatVectorValue, ?>)((Types.Vector)new Types.FloatVector(2))).getSignature(), new LongVector((Types.Vector<LongVectorValue, ?>)((Types.Vector)new Types.LongVector(2))).getSignature(), new IntVector((Types.Vector<IntVectorValue, ?>)((Types.Vector)new Types.IntVector(2))).getSignature()};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public Function<DoubleValue> obtain(@NotNull Signature.Closed<DoubleValue> signature) {
            return FunctionGenerator.DefaultImpls.obtain(this, signature);
        }

        @Override
        @NotNull
        public Signature.Closed<?> resolve(@NotNull Signature.SemiClosed signature) {
            return FunctionGenerator.DefaultImpls.resolve(this, signature);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$DoubleVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance;", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "type", "Lorg/vitrivr/cottontail/core/types/Types$Vector;", "(Lorg/vitrivr/cottontail/core/types/Types$Vector;)V", "name", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "copy", "d", "", "invoke", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/core/types/Value;", "invoke-iEH02FE", "([Lorg/vitrivr/cottontail/core/types/Value;)D", "cottontaildb-core"})
    public static final class DoubleVector
    extends HaversineDistance<DoubleVectorValue> {
        @NotNull
        private final Name.FunctionName name;

        public DoubleVector(@NotNull Types.Vector<DoubleVectorValue, ?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type, null);
            this.name = Companion.getFUNCTION_NAME();
        }

        @Override
        @NotNull
        public Name.FunctionName getName() {
            return this.name;
        }

        public double invoke-iEH02FE(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleVectorValue");
            double[] probing = ((DoubleVectorValue)value).unbox-impl();
            Value value2 = arguments[1];
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.DoubleVectorValue");
            double[] query = ((DoubleVectorValue)value2).unbox-impl();
            return DoubleValue.constructor-impl((double)this.haversine(query[0], query[1], probing[0], probing[1]));
        }

        @NotNull
        public DoubleVector copy(int d) {
            return new DoubleVector((Types.Vector<DoubleVectorValue, ?>)((Types.Vector)new Types.DoubleVector(d)));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$FloatVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance;", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "type", "Lorg/vitrivr/cottontail/core/types/Types$Vector;", "(Lorg/vitrivr/cottontail/core/types/Types$Vector;)V", "name", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "copy", "d", "", "invoke", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/core/types/Value;", "invoke-iEH02FE", "([Lorg/vitrivr/cottontail/core/types/Value;)D", "cottontaildb-core"})
    public static final class FloatVector
    extends HaversineDistance<FloatVectorValue> {
        @NotNull
        private final Name.FunctionName name;

        public FloatVector(@NotNull Types.Vector<FloatVectorValue, ?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type, null);
            this.name = Companion.getFUNCTION_NAME();
        }

        @Override
        @NotNull
        public Name.FunctionName getName() {
            return this.name;
        }

        public double invoke-iEH02FE(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.FloatVectorValue");
            float[] probing = ((FloatVectorValue)value).unbox-impl();
            Value value2 = arguments[1];
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.FloatVectorValue");
            float[] query = ((FloatVectorValue)value2).unbox-impl();
            return DoubleValue.constructor-impl((double)this.haversine(query[0], query[1], probing[0], probing[1]));
        }

        @NotNull
        public FloatVector copy(int d) {
            return new FloatVector((Types.Vector<FloatVectorValue, ?>)((Types.Vector)new Types.FloatVector(d)));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$IntVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance;", "Lorg/vitrivr/cottontail/core/values/IntVectorValue;", "type", "Lorg/vitrivr/cottontail/core/types/Types$Vector;", "(Lorg/vitrivr/cottontail/core/types/Types$Vector;)V", "name", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "copy", "d", "", "invoke", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/core/types/Value;", "invoke-iEH02FE", "([Lorg/vitrivr/cottontail/core/types/Value;)D", "cottontaildb-core"})
    public static final class IntVector
    extends HaversineDistance<IntVectorValue> {
        @NotNull
        private final Name.FunctionName name;

        public IntVector(@NotNull Types.Vector<IntVectorValue, ?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type, null);
            this.name = Companion.getFUNCTION_NAME();
        }

        @Override
        @NotNull
        public Name.FunctionName getName() {
            return this.name;
        }

        public double invoke-iEH02FE(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.IntVectorValue");
            int[] probing = ((IntVectorValue)value).unbox-impl();
            Value value2 = arguments[1];
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.IntVectorValue");
            int[] query = ((IntVectorValue)value2).unbox-impl();
            return DoubleValue.constructor-impl((double)this.haversine(query[0], query[1], probing[0], probing[1]));
        }

        @NotNull
        public IntVector copy(int d) {
            return new IntVector((Types.Vector<IntVectorValue, ?>)((Types.Vector)new Types.IntVector(d)));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u0010\"\u0004\u0018\u00010\u0011H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance$LongVector;", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/HaversineDistance;", "Lorg/vitrivr/cottontail/core/values/LongVectorValue;", "type", "Lorg/vitrivr/cottontail/core/types/Types$Vector;", "(Lorg/vitrivr/cottontail/core/types/Types$Vector;)V", "name", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "copy", "d", "", "invoke", "Lorg/vitrivr/cottontail/core/values/DoubleValue;", "arguments", "", "Lorg/vitrivr/cottontail/core/types/Value;", "invoke-iEH02FE", "([Lorg/vitrivr/cottontail/core/types/Value;)D", "cottontaildb-core"})
    public static final class LongVector
    extends HaversineDistance<LongVectorValue> {
        @NotNull
        private final Name.FunctionName name;

        public LongVector(@NotNull Types.Vector<LongVectorValue, ?> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            super(type, null);
            this.name = Companion.getFUNCTION_NAME();
        }

        @Override
        @NotNull
        public Name.FunctionName getName() {
            return this.name;
        }

        public double invoke-iEH02FE(Value ... arguments) {
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            Value value = arguments[0];
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.LongVectorValue");
            long[] probing = ((LongVectorValue)value).unbox-impl();
            Value value2 = arguments[1];
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.LongVectorValue");
            long[] query = ((LongVectorValue)value2).unbox-impl();
            return DoubleValue.constructor-impl((double)this.haversine(query[0], query[1], probing[0], probing[1]));
        }

        @NotNull
        public LongVector copy(int d) {
            return new LongVector((Types.Vector<LongVectorValue, ?>)((Types.Vector)new Types.LongVector(d)));
        }
    }
}

