/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values.tablets;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.utilities.math.BitUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0004J\u0015\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0005H$\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J \u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/core/values/tablets/AbstractTablet;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "size", "", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "direct", "", "(ILorg/vitrivr/cottontail/core/types/Types;Z)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getSize", "()I", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "get", "index", "(I)Lorg/vitrivr/cottontail/core/types/Value;", "indexToPosition", "internalGet", "internalSet", "", "value", "(ILorg/vitrivr/cottontail/core/types/Value;)V", "isNull", "set", "cottontaildb-core"})
@SourceDebugExtension(value={"SMAP\nAbstractTablet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTablet.kt\norg/vitrivr/cottontail/core/values/tablets/AbstractTablet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public abstract class AbstractTablet<T extends Value>
implements Tablet<T> {
    private final int size;
    @NotNull
    private final Types<T> type;
    @NotNull
    private final ByteBuffer buffer;

    public AbstractTablet(int size, @NotNull Types<T> type, boolean direct) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.size = size;
        this.type = type;
        if (!(this.size % 32 == 0)) {
            boolean bl = false;
            String string = "Tablet size must be a multiple of 32.";
            throw new IllegalArgumentException(string.toString());
        }
        if (direct) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((this.size >> 3) + this.size * this.type.getPhysicalSize());
            Intrinsics.checkNotNull((Object)byteBuffer2);
            byteBuffer = byteBuffer2;
        } else {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate((this.size >> 3) + this.size * this.type.getPhysicalSize());
            Intrinsics.checkNotNull((Object)byteBuffer3);
            byteBuffer = byteBuffer3;
        }
        this.buffer = byteBuffer;
    }

    @Override
    public final int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public final Types<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isNull(int index) {
        if (!(index < this.size)) {
            boolean $i$a$-require-AbstractTablet$isNull$22 = false;
            String $i$a$-require-AbstractTablet$isNull$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-AbstractTablet$isNull$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        return !BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt(wordIndex), bitPosition);
    }

    @Override
    @Nullable
    public T get(int index) {
        if (this.isNull(index)) {
            return null;
        }
        return this.internalGet(index);
    }

    @Override
    public void set(int index, @Nullable T value) {
        if (!(index < this.size)) {
            boolean $i$a$-require-AbstractTablet$set$22 = false;
            String $i$a$-require-AbstractTablet$set$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-AbstractTablet$set$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        if (value == null) {
            this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.unsetBit(this.getBuffer().getInt(wordIndex), bitPosition));
            return;
        }
        this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.setBit(this.getBuffer().getInt(wordIndex), bitPosition));
        this.internalSet(index, value);
    }

    protected final int indexToPosition(int index) {
        if (!(index < this.size)) {
            boolean bl = false;
            String string = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException(string.toString());
        }
        return (this.size >> 3) + index * this.type.getPhysicalSize();
    }

    @NotNull
    protected abstract T internalGet(int var1);

    public abstract void internalSet(int var1, @NotNull T var2);
}

