/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values.tablets;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanValue;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.utilities.math.BitUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00f8\u0001\u0001\u00a2\u0006\u0002\b\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/core/values/tablets/BooleanTablet;", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "Lorg/vitrivr/cottontail/core/values/BooleanValue;", "size", "", "direct", "", "(IZ)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getSize", "()I", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "get", "index", "get-1OalM1U", "isNull", "set", "", "value", "set-3Y5jbWA", "cottontaildb-core"})
@SourceDebugExtension(value={"SMAP\nBooleanTablet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanTablet.kt\norg/vitrivr/cottontail/core/values/tablets/BooleanTablet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class BooleanTablet
implements Tablet<BooleanValue> {
    private final int size;
    @NotNull
    private final Types<BooleanValue> type;
    @NotNull
    private final ByteBuffer buffer;

    public BooleanTablet(int size, boolean direct) {
        ByteBuffer byteBuffer;
        this.size = size;
        if (!(this.getSize() % 32 == 0)) {
            boolean bl = false;
            String string = "Tablet size must be a multiple of 32.";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = (Types)Types.Boolean.INSTANCE;
        if (direct) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(2 * (this.getSize() >> 3));
            Intrinsics.checkNotNull((Object)byteBuffer2);
            byteBuffer = byteBuffer2;
        } else {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate(2 * (this.getSize() >> 3));
            Intrinsics.checkNotNull((Object)byteBuffer3);
            byteBuffer = byteBuffer3;
        }
        this.buffer = byteBuffer;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Types<BooleanValue> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isNull(int index) {
        if (!(index < this.getSize())) {
            boolean $i$a$-require-BooleanTablet$isNull$22 = false;
            String $i$a$-require-BooleanTablet$isNull$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-BooleanTablet$isNull$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        return !BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt(wordIndex), bitPosition);
    }

    @Nullable
    public BooleanValue get-1OalM1U(int index) {
        if (!(index < this.getSize())) {
            boolean $i$a$-require-BooleanTablet$get$22 = false;
            String $i$a$-require-BooleanTablet$get$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-BooleanTablet$get$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        return BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt(wordIndex), bitPosition) ? BooleanValue.box-impl((boolean)BooleanValue.constructor-impl((boolean)BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt((this.getSize() >> 3) + wordIndex), bitPosition))) : null;
    }

    public void set-3Y5jbWA(int index, @Nullable BooleanValue value) {
        if (!(index < this.getSize())) {
            boolean $i$a$-require-BooleanTablet$set$22 = false;
            String $i$a$-require-BooleanTablet$set$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-BooleanTablet$set$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        BooleanValue booleanValue = value;
        if (booleanValue == null) {
            this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.unsetBit(this.getBuffer().getInt(wordIndex), bitPosition));
        } else {
            boolean bl = BooleanValue.Companion.getTRUE-Y95bUhg();
            if (BooleanValue.equals-impl0((boolean)booleanValue.unbox-impl(), (boolean)bl)) {
                this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.setBit(this.getBuffer().getInt(wordIndex), bitPosition));
                this.getBuffer().putInt((this.getSize() >> 3) + wordIndex, BitUtil.INSTANCE.setBit(this.getBuffer().getInt((this.getSize() >> 3) + wordIndex), bitPosition));
            } else {
                bl = BooleanValue.Companion.getFALSE-Y95bUhg();
                if (BooleanValue.equals-impl0((boolean)booleanValue.unbox-impl(), (boolean)bl)) {
                    this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.setBit(this.getBuffer().getInt(wordIndex), bitPosition));
                    this.getBuffer().putInt((this.getSize() >> 3) + wordIndex, BitUtil.INSTANCE.unsetBit(this.getBuffer().getInt((this.getSize() >> 3) + wordIndex), bitPosition));
                }
            }
        }
    }
}

