/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values.tablets;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.core.values.tablets.Tablet;
import org.vitrivr.cottontail.utilities.math.BitUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/core/values/tablets/BooleanVectorTablet;", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "size", "", "logicalSize", "direct", "", "(IIZ)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getSize", "()I", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "get", "index", "get-iuwxMNg", "(I)[Z", "isNull", "set", "", "value", "set-ncYszEA", "(I[Z)V", "cottontaildb-core"})
@SourceDebugExtension(value={"SMAP\nBooleanVectorTablet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanVectorTablet.kt\norg/vitrivr/cottontail/core/values/tablets/BooleanVectorTablet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n1#2:74\n13444#3,3:75\n*S KotlinDebug\n*F\n+ 1 BooleanVectorTablet.kt\norg/vitrivr/cottontail/core/values/tablets/BooleanVectorTablet\n*L\n61#1:75,3\n*E\n"})
public final class BooleanVectorTablet
implements Tablet<BooleanVectorValue> {
    private final int size;
    @NotNull
    private final Types<BooleanVectorValue> type;
    @NotNull
    private final ByteBuffer buffer;

    public BooleanVectorTablet(int size, int logicalSize, boolean direct) {
        ByteBuffer byteBuffer;
        this.size = size;
        if (!(this.getSize() % 32 == 0)) {
            boolean bl = false;
            String string = "Tablet size must be a multiple of 32.";
            throw new IllegalArgumentException(string.toString());
        }
        this.type = (Types)new Types.BooleanVector(logicalSize);
        if (direct) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((this.getSize() >> 3) + (this.getSize() * logicalSize >> 3) + 4);
            Intrinsics.checkNotNull((Object)byteBuffer2);
            byteBuffer = byteBuffer2;
        } else {
            ByteBuffer byteBuffer3 = ByteBuffer.allocate((this.getSize() >> 3) + (this.getSize() * logicalSize >> 3) + 4);
            Intrinsics.checkNotNull((Object)byteBuffer3);
            byteBuffer = byteBuffer3;
        }
        this.buffer = byteBuffer;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Types<BooleanVectorValue> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isNull(int index) {
        if (!(index < this.getSize())) {
            boolean $i$a$-require-BooleanVectorTablet$isNull$22 = false;
            String $i$a$-require-BooleanVectorTablet$isNull$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-BooleanVectorTablet$isNull$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        return !BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt(wordIndex), bitPosition);
    }

    @Nullable
    public boolean[] get-iuwxMNg(int index) {
        if (!(index < this.getSize())) {
            boolean bl = false;
            String string = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.isNull(index)) {
            return null;
        }
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        boolean[] blArray = new boolean[n2];
        while (n < n2) {
            int n3 = n++;
            int bit = this.getType().getLogicalSize() * index + n3;
            int word = (this.getSize() >> 3) + 4 * (bit >> 5);
            int pos = bit % 32;
            blArray[n3] = BitUtil.INSTANCE.isBitSet(this.getBuffer().getInt(word), pos);
        }
        return BooleanVectorValue.constructor-impl((boolean[])blArray);
    }

    /*
     * WARNING - void declaration
     */
    public void set-ncYszEA(int index, @Nullable boolean[] value) {
        if (!(index < this.getSize())) {
            boolean $i$a$-require-BooleanVectorTablet$set$22 = false;
            String $i$a$-require-BooleanVectorTablet$set$22 = "Provided index " + index + " is out of bounds for this tablet.";
            throw new IllegalArgumentException($i$a$-require-BooleanVectorTablet$set$22.toString());
        }
        int bitIndex = index >> 5;
        int bitPosition = index % 32;
        int wordIndex = bitIndex * 4;
        if (value == null) {
            this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.unsetBit(this.getBuffer().getInt(wordIndex), bitPosition));
        } else {
            this.getBuffer().putInt(wordIndex, BitUtil.INSTANCE.setBit(this.getBuffer().getInt(wordIndex), bitPosition));
            boolean[] $this$forEachIndexed$iv = value;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (boolean item$iv : $this$forEachIndexed$iv) {
                void b;
                int n = index$iv++;
                boolean bl = item$iv;
                int i = n;
                boolean bl2 = false;
                int bit = this.getType().getLogicalSize() * index + i;
                int word = (this.getSize() >> 3) + 4 * (bit >> 5);
                int pos = bit % 32;
                if (b != false) {
                    this.getBuffer().putInt(word, BitUtil.INSTANCE.setBit(this.getBuffer().getInt(word), pos));
                    continue;
                }
                this.getBuffer().putInt(word, BitUtil.INSTANCE.unsetBit(this.getBuffer().getInt(word), pos));
            }
        }
    }
}

