/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.core.values.tablets;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.types.Types;
import org.vitrivr.cottontail.core.types.Value;
import org.vitrivr.cottontail.core.values.tablets.BooleanTablet;
import org.vitrivr.cottontail.core.values.tablets.BooleanVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.ByteTablet;
import org.vitrivr.cottontail.core.values.tablets.Complex32Tablet;
import org.vitrivr.cottontail.core.values.tablets.Complex32VectorTablet;
import org.vitrivr.cottontail.core.values.tablets.Complex64Tablet;
import org.vitrivr.cottontail.core.values.tablets.Complex64VectorTablet;
import org.vitrivr.cottontail.core.values.tablets.DateTablet;
import org.vitrivr.cottontail.core.values.tablets.DoubleTablet;
import org.vitrivr.cottontail.core.values.tablets.DoubleVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.FloatTablet;
import org.vitrivr.cottontail.core.values.tablets.FloatVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.HalfVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.IntTablet;
import org.vitrivr.cottontail.core.values.tablets.IntVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.LongTablet;
import org.vitrivr.cottontail.core.values.tablets.LongVectorTablet;
import org.vitrivr.cottontail.core.values.tablets.ShortTablet;
import org.vitrivr.cottontail.core.values.tablets.UuidTablet;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0019J\u0018\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\tH\u00a6\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\tH&J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u00a6\u0002\u00a2\u0006\u0002\u0010\u0018R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u0082\u0001\u0003\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "size", "", "getSize", "()I", "type", "Lorg/vitrivr/cottontail/core/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/types/Types;", "get", "index", "(I)Lorg/vitrivr/cottontail/core/types/Value;", "isNull", "", "set", "", "value", "(ILorg/vitrivr/cottontail/core/types/Value;)V", "Companion", "Lorg/vitrivr/cottontail/core/values/tablets/AbstractTablet;", "Lorg/vitrivr/cottontail/core/values/tablets/BooleanTablet;", "Lorg/vitrivr/cottontail/core/values/tablets/BooleanVectorTablet;", "cottontaildb-core"})
public interface Tablet<T extends Value> {
    @NotNull
    public static final Companion Companion = org.vitrivr.cottontail.core.values.tablets.Tablet$Companion.$$INSTANCE;

    public int getSize();

    @NotNull
    public Types<T> getType();

    @NotNull
    public ByteBuffer getBuffer();

    public boolean isNull(int var1);

    @Nullable
    public T get(int var1);

    public void set(int var1, @Nullable T var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00050\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/core/values/tablets/Tablet$Companion;", "", "()V", "of", "Lorg/vitrivr/cottontail/core/values/tablets/Tablet;", "T", "Lorg/vitrivr/cottontail/core/types/Value;", "size", "", "types", "Lorg/vitrivr/cottontail/core/types/Types;", "direct", "", "cottontaildb-core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final <T extends Value> Tablet<T> of(int size, @NotNull Types<T> types, boolean direct) {
            Tablet tablet;
            Intrinsics.checkNotNullParameter(types, (String)"types");
            Types<T> types2 = types;
            if (Intrinsics.areEqual(types2, (Object)Types.Boolean.INSTANCE)) {
                tablet = new BooleanTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Date.INSTANCE)) {
                tablet = new DateTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Byte.INSTANCE)) {
                tablet = new ByteTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Complex32.INSTANCE)) {
                tablet = new Complex32Tablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Complex64.INSTANCE)) {
                tablet = new Complex64Tablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Double.INSTANCE)) {
                tablet = new DoubleTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Float.INSTANCE)) {
                tablet = new FloatTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Int.INSTANCE)) {
                tablet = new IntTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Long.INSTANCE)) {
                tablet = new LongTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Short.INSTANCE)) {
                tablet = new ShortTablet(size, direct);
            } else if (Intrinsics.areEqual(types2, (Object)Types.Uuid.INSTANCE)) {
                tablet = new UuidTablet(size, direct);
            } else if (types2 instanceof Types.BooleanVector) {
                tablet = new BooleanVectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.Complex32Vector) {
                tablet = new Complex32VectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.Complex64Vector) {
                tablet = new Complex64VectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.DoubleVector) {
                tablet = new DoubleVectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.FloatVector) {
                tablet = new FloatVectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.HalfVector) {
                tablet = new HalfVectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.IntVector) {
                tablet = new IntVectorTablet(size, types.getLogicalSize(), direct);
            } else if (types2 instanceof Types.LongVector) {
                tablet = new LongVectorTablet(size, types.getLogicalSize(), direct);
            } else {
                throw new UnsupportedOperationException("The type " + types + " cannot be represented in a tablet.");
            }
            return tablet;
        }

        public static /* synthetic */ Tablet of$default(Companion companion, int n, Types types, boolean bl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            return companion.of(n, types, bl);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

