/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.hashing;

import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.tuple.Tuple;
import org.vitrivr.cottontail.utilities.hashing.ValueFunnel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/utilities/hashing/RecordHasher;", "", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "seed", "", "(Ljava/util/List;J)V", "getColumns", "()Ljava/util/List;", "hashers", "", "Lcom/google/common/hash/HashFunction;", "[Lcom/google/common/hash/HashFunction;", "getSeed", "()J", "hash", "", "tuple", "Lorg/vitrivr/cottontail/core/tuple/Tuple;", "cottontaildb-core"})
@SourceDebugExtension(value={"SMAP\nRecordHasher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecordHasher.kt\norg/vitrivr/cottontail/utilities/hashing/RecordHasher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,34:1\n1549#2:35\n1620#2,3:36\n37#3,2:39\n*S KotlinDebug\n*F\n+ 1 RecordHasher.kt\norg/vitrivr/cottontail/utilities/hashing/RecordHasher\n*L\n18#1:35\n18#1:36,3\n18#1:39,2\n*E\n"})
public final class RecordHasher {
    @NotNull
    private final List<ColumnDef<?>> columns;
    private final long seed;
    @NotNull
    private final HashFunction[] hashers;

    /*
     * WARNING - void declaration
     */
    public RecordHasher(@NotNull List<? extends ColumnDef<?>> columns, long seed) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
        this.seed = seed;
        Iterable iterable = this.columns;
        RecordHasher recordHasher = this;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ColumnDef columnDef = (ColumnDef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Hashing.murmur3_128((int)((int)this.seed)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        recordHasher.hashers = thisCollection$iv.toArray(new HashFunction[0]);
    }

    public /* synthetic */ RecordHasher(List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        this(list, l);
    }

    @NotNull
    public final List<ColumnDef<?>> getColumns() {
        return this.columns;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final byte[] hash(@NotNull Tuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        ByteBuffer buffer = ByteBuffer.allocate(16 * this.hashers.length);
        Iterator<ColumnDef<?>> iterator = this.columns.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ColumnDef<?> c = iterator.next();
            HashCode code = this.hashers[i].hashObject((Object)tuple.get(c), (Funnel)ValueFunnel.INSTANCE);
            buffer.put(code.asBytes());
        }
        byte[] byArray = buffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        return byArray;
    }
}

