package org.vitrivr.cottontail.grpc

import com.google.protobuf.Empty
import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.MethodDescriptor
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.ServiceDescriptor
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.flow.Flow
import org.vitrivr.cottontail.grpc.DDLGrpc.getServiceDescriptor

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DDL.
 */
object DDLGrpcKt {
  @JvmStatic
  val serviceDescriptor: ServiceDescriptor
    get() = DDLGrpc.getServiceDescriptor()

  val listSchemasMethod: MethodDescriptor<CottontailGrpc.ListSchemaMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getListSchemasMethod()

  val createSchemaMethod: MethodDescriptor<CottontailGrpc.CreateSchemaMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateSchemaMethod()

  val dropSchemaMethod: MethodDescriptor<CottontailGrpc.DropSchemaMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropSchemaMethod()

  val listEntitiesMethod: MethodDescriptor<CottontailGrpc.ListEntityMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getListEntitiesMethod()

  val entityDetailsMethod: MethodDescriptor<CottontailGrpc.EntityDetailsMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getEntityDetailsMethod()

  val createEntityMethod: MethodDescriptor<CottontailGrpc.CreateEntityMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateEntityMethod()

  val dropEntityMethod: MethodDescriptor<CottontailGrpc.DropEntityMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropEntityMethod()

  val truncateEntityMethod: MethodDescriptor<CottontailGrpc.TruncateEntityMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getTruncateEntityMethod()

  val optimizeEntityMethod: MethodDescriptor<CottontailGrpc.OptimizeEntityMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getOptimizeEntityMethod()

  val createIndexMethod: MethodDescriptor<CottontailGrpc.CreateIndexMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getCreateIndexMethod()

  val dropIndexMethod: MethodDescriptor<CottontailGrpc.DropIndexMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getDropIndexMethod()

  val rebuildIndexMethod: MethodDescriptor<CottontailGrpc.RebuildIndexMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DDLGrpc.getRebuildIndexMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DDL service as suspending
   * coroutines.
   */
  @StubFor(DDLGrpc::class)
  class DDLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT
  ) : AbstractCoroutineStub<DDLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DDLCoroutineStub =
        DDLCoroutineStub(channel, callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun listSchemas(request: CottontailGrpc.ListSchemaMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DDLGrpc.getListSchemasMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun createSchema(request: CottontailGrpc.CreateSchemaMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateSchemaMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun dropSchema(request: CottontailGrpc.DropSchemaMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropSchemaMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun listEntities(request: CottontailGrpc.ListEntityMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DDLGrpc.getListEntitiesMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun entityDetails(request: CottontailGrpc.EntityDetailsMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getEntityDetailsMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun createEntity(request: CottontailGrpc.CreateEntityMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateEntityMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun dropEntity(request: CottontailGrpc.DropEntityMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropEntityMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun truncateEntity(request: CottontailGrpc.TruncateEntityMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getTruncateEntityMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun optimizeEntity(request: CottontailGrpc.OptimizeEntityMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getOptimizeEntityMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun createIndex(request: CottontailGrpc.CreateIndexMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getCreateIndexMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun dropIndex(request: CottontailGrpc.DropIndexMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getDropIndexMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun rebuildIndex(request: CottontailGrpc.RebuildIndexMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DDLGrpc.getRebuildIndexMethod(),
      request,
      callOptions,
      Metadata()
    )}

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DDL service based on Kotlin
   * coroutines.
   */
  abstract class DDLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DDL.ListSchemas.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun listSchemas(request: CottontailGrpc.ListSchemaMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.ListSchemas is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateSchema.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun createSchema(request: CottontailGrpc.CreateSchemaMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateSchema is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropSchema.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun dropSchema(request: CottontailGrpc.DropSchemaMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropSchema is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DDL.ListEntities.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun listEntities(request: CottontailGrpc.ListEntityMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.ListEntities is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.EntityDetails.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun entityDetails(request: CottontailGrpc.EntityDetailsMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.EntityDetails is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun createEntity(request: CottontailGrpc.CreateEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun dropEntity(request: CottontailGrpc.DropEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.TruncateEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun truncateEntity(request: CottontailGrpc.TruncateEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.TruncateEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.OptimizeEntity.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun optimizeEntity(request: CottontailGrpc.OptimizeEntityMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.OptimizeEntity is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.CreateIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun createIndex(request: CottontailGrpc.CreateIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.CreateIndex is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.DropIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun dropIndex(request: CottontailGrpc.DropIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.DropIndex is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DDL.RebuildIndex.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun rebuildIndex(request: CottontailGrpc.RebuildIndexMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DDL.RebuildIndex is unimplemented"))

    final override fun bindService(): ServerServiceDefinition = builder(getServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getListSchemasMethod(),
      implementation = ::listSchemas
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateSchemaMethod(),
      implementation = ::createSchema
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropSchemaMethod(),
      implementation = ::dropSchema
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getListEntitiesMethod(),
      implementation = ::listEntities
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getEntityDetailsMethod(),
      implementation = ::entityDetails
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateEntityMethod(),
      implementation = ::createEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropEntityMethod(),
      implementation = ::dropEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getTruncateEntityMethod(),
      implementation = ::truncateEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getOptimizeEntityMethod(),
      implementation = ::optimizeEntity
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getCreateIndexMethod(),
      implementation = ::createIndex
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getDropIndexMethod(),
      implementation = ::dropIndex
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DDLGrpc.getRebuildIndexMethod(),
      implementation = ::rebuildIndex
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DML.
 */
object DMLGrpcKt {
  @JvmStatic
  val serviceDescriptor: ServiceDescriptor
    get() = DMLGrpc.getServiceDescriptor()

  val insertMethod: MethodDescriptor<CottontailGrpc.InsertMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getInsertMethod()

  val insertBatchMethod: MethodDescriptor<CottontailGrpc.BatchInsertMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getInsertBatchMethod()

  val updateMethod: MethodDescriptor<CottontailGrpc.UpdateMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getUpdateMethod()

  val deleteMethod: MethodDescriptor<CottontailGrpc.DeleteMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DMLGrpc.getDeleteMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DML service as suspending
   * coroutines.
   */
  @StubFor(DMLGrpc::class)
  class DMLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT
  ) : AbstractCoroutineStub<DMLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DMLCoroutineStub =
        DMLCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun insert(request: CottontailGrpc.InsertMessage): CottontailGrpc.QueryResponseMessage =
        unaryRpc(
      channel,
      DMLGrpc.getInsertMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun insertBatch(request: CottontailGrpc.BatchInsertMessage):
        CottontailGrpc.QueryResponseMessage = unaryRpc(
      channel,
      DMLGrpc.getInsertBatchMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun update(request: CottontailGrpc.UpdateMessage): CottontailGrpc.QueryResponseMessage =
        unaryRpc(
      channel,
      DMLGrpc.getUpdateMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun delete(request: CottontailGrpc.DeleteMessage): CottontailGrpc.QueryResponseMessage =
        unaryRpc(
      channel,
      DMLGrpc.getDeleteMethod(),
      request,
      callOptions,
      Metadata()
    )}

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DML service based on Kotlin
   * coroutines.
   */
  abstract class DMLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Insert.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun insert(request: CottontailGrpc.InsertMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Insert is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.InsertBatch.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun insertBatch(request: CottontailGrpc.BatchInsertMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.InsertBatch is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Update.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun update(request: CottontailGrpc.UpdateMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Update is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DML.Delete.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun delete(request: CottontailGrpc.DeleteMessage):
        CottontailGrpc.QueryResponseMessage = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DML.Delete is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(DMLGrpc.getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getInsertMethod(),
      implementation = ::insert
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getInsertBatchMethod(),
      implementation = ::insertBatch
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getUpdateMethod(),
      implementation = ::update
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DMLGrpc.getDeleteMethod(),
      implementation = ::delete
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.DQL.
 */
object DQLGrpcKt {
  @JvmStatic
  val serviceDescriptor: ServiceDescriptor
    get() = DQLGrpc.getServiceDescriptor()

  val explainMethod: MethodDescriptor<CottontailGrpc.QueryMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DQLGrpc.getExplainMethod()

  val queryMethod: MethodDescriptor<CottontailGrpc.QueryMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DQLGrpc.getQueryMethod()

  val batchQueryMethod: MethodDescriptor<CottontailGrpc.BatchedQueryMessage,
      CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = DQLGrpc.getBatchQueryMethod()

  val pingMethod: MethodDescriptor<Empty, Empty>
    @JvmStatic
    get() = DQLGrpc.getPingMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.DQL service as suspending
   * coroutines.
   */
  @StubFor(DQLGrpc::class)
  class DQLCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT
  ) : AbstractCoroutineStub<DQLCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): DQLCoroutineStub =
        DQLCoroutineStub(channel, callOptions)

    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun explain(request: CottontailGrpc.QueryMessage): Flow<CottontailGrpc.QueryResponseMessage> =
        serverStreamingRpc(
      channel,
      DQLGrpc.getExplainMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun query(request: CottontailGrpc.QueryMessage): Flow<CottontailGrpc.QueryResponseMessage> =
        serverStreamingRpc(
      channel,
      DQLGrpc.getQueryMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun batchQuery(request: CottontailGrpc.BatchedQueryMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      DQLGrpc.getBatchQueryMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun ping(request: Empty): Empty = unaryRpc(
      channel,
      DQLGrpc.getPingMethod(),
      request,
      callOptions,
      Metadata()
    )}

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.DQL service based on Kotlin
   * coroutines.
   */
  abstract class DQLCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DQL.Explain.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun explain(request: CottontailGrpc.QueryMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Explain is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DQL.Query.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun query(request: CottontailGrpc.QueryMessage): Flow<CottontailGrpc.QueryResponseMessage>
        = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Query is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.DQL.BatchQuery.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun batchQuery(request: CottontailGrpc.BatchedQueryMessage):
        Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.BatchQuery is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.DQL.Ping.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun ping(request: Empty): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.DQL.Ping is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(DQLGrpc.getServiceDescriptor())
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getExplainMethod(),
      implementation = ::explain
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getQueryMethod(),
      implementation = ::query
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getBatchQueryMethod(),
      implementation = ::batchQuery
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = DQLGrpc.getPingMethod(),
      implementation = ::ping
    )).build()
  }
}

/**
 * Holder for Kotlin coroutine-based client and server APIs for org.vitrivr.cottontail.grpc.TXN.
 */
object TXNGrpcKt {
  @JvmStatic
  val serviceDescriptor: ServiceDescriptor
    get() = TXNGrpc.getServiceDescriptor()

  val beginMethod: MethodDescriptor<Empty, CottontailGrpc.TransactionId>
    @JvmStatic
    get() = TXNGrpc.getBeginMethod()

  val commitMethod: MethodDescriptor<CottontailGrpc.TransactionId, Empty>
    @JvmStatic
    get() = TXNGrpc.getCommitMethod()

  val rollbackMethod: MethodDescriptor<CottontailGrpc.TransactionId, Empty>
    @JvmStatic
    get() = TXNGrpc.getRollbackMethod()

  val listTransactionsMethod: MethodDescriptor<Empty, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = TXNGrpc.getListTransactionsMethod()

  val listLocksMethod: MethodDescriptor<Empty, CottontailGrpc.QueryResponseMessage>
    @JvmStatic
    get() = TXNGrpc.getListLocksMethod()

  /**
   * A stub for issuing RPCs to a(n) org.vitrivr.cottontail.grpc.TXN service as suspending
   * coroutines.
   */
  @StubFor(TXNGrpc::class)
  class TXNCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT
  ) : AbstractCoroutineStub<TXNCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): TXNCoroutineStub =
        TXNCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun begin(request: Empty): CottontailGrpc.TransactionId = unaryRpc(
      channel,
      TXNGrpc.getBeginMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun commit(request: CottontailGrpc.TransactionId): Empty = unaryRpc(
      channel,
      TXNGrpc.getCommitMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun rollback(request: CottontailGrpc.TransactionId): Empty = unaryRpc(
      channel,
      TXNGrpc.getRollbackMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun listTransactions(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> =
        serverStreamingRpc(
      channel,
      TXNGrpc.getListTransactionsMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun listLocks(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> = serverStreamingRpc(
      channel,
      TXNGrpc.getListLocksMethod(),
      request,
      callOptions,
      Metadata()
    )}

  /**
   * Skeletal implementation of the org.vitrivr.cottontail.grpc.TXN service based on Kotlin
   * coroutines.
   */
  abstract class TXNCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Begin.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun begin(request: Empty): CottontailGrpc.TransactionId = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Begin is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Commit.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun commit(request: CottontailGrpc.TransactionId): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Commit is unimplemented"))

    /**
     * Returns the response to an RPC for org.vitrivr.cottontail.grpc.TXN.Rollback.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun rollback(request: CottontailGrpc.TransactionId): Empty = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.Rollback is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.TXN.ListTransactions.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun listTransactions(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.ListTransactions is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for org.vitrivr.cottontail.grpc.TXN.ListLocks.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun listLocks(request: Empty): Flow<CottontailGrpc.QueryResponseMessage> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method org.vitrivr.cottontail.grpc.TXN.ListLocks is unimplemented"))

    final override fun bindService(): ServerServiceDefinition =
        builder(TXNGrpc.getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getBeginMethod(),
      implementation = ::begin
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getCommitMethod(),
      implementation = ::commit
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getRollbackMethod(),
      implementation = ::rollback
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getListTransactionsMethod(),
      implementation = ::listTransactions
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = TXNGrpc.getListLocksMethod(),
      implementation = ::listLocks
    )).build()
  }
}
