/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.client.language.dql;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.language.extensions.And;
import org.vitrivr.cottontail.client.language.extensions.Atomic;
import org.vitrivr.cottontail.client.language.extensions.Or;
import org.vitrivr.cottontail.client.language.extensions.Predicate;
import org.vitrivr.cottontail.client.language.extensions.StringExtensionsKt;
import org.vitrivr.cottontail.client.language.extensions.VectorExtensionKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0000J\u001f\u0010\u000b\u001a\u00020\u00002\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\r\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J2\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J7\u0010\u001a\u001a\u00020\u00002*\u0010\u001b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c0\r\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001c\u00a2\u0006\u0002\u0010\u001dJ;\u0010\u001e\u001a\u00020\u00002.\u0010\f\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c0\r\"\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001c\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u00002\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\r\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/client/language/dql/Query;", "", "entity", "", "(Ljava/lang/String;)V", "builder", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Query$Builder;", "kotlin.jvm.PlatformType", "getBuilder", "()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Query$Builder;", "count", "distinct", "fields", "", "([Ljava/lang/String;)Lorg/vitrivr/cottontail/client/language/dql/Query;", "exists", "from", "query", "knn", "column", "k", "", "distance", "weight", "limit", "", "order", "clauses", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lorg/vitrivr/cottontail/client/language/dql/Query;", "select", "skip", "where", "predicate", "Lorg/vitrivr/cottontail/client/language/extensions/Predicate;", "cottontaildb-proto"})
public final class Query {
    private final CottontailGrpc.Query.Builder builder;

    public final CottontailGrpc.Query.Builder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final Query select(String ... fields) {
        CottontailGrpc.Projection.Builder builder;
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.builder.clearProjection();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Projection.Builder builder3 = builder = builder2.getProjectionBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT);
        for (String field : fields) {
            builder.addColumns(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn(field)));
        }
        return this;
    }

    @NotNull
    public final Query select(Pair<String, String> ... fields) {
        CottontailGrpc.Projection.Builder builder;
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.builder.clearProjection();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Projection.Builder builder3 = builder = builder2.getProjectionBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT);
        for (Pair<String, String> field : fields) {
            CottontailGrpc.Projection.ProjectionElement.Builder c = CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn((String)field.getFirst()));
            if (field.getSecond() != null) {
                CottontailGrpc.Projection.ProjectionElement.Builder builder4 = c;
                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"c");
                Object object = field.getSecond();
                Intrinsics.checkNotNull((Object)object);
                builder4.setAlias(StringExtensionsKt.parseColumn((String)object));
            }
            builder.addColumns(c);
        }
        return this;
    }

    @NotNull
    public final Query distinct(String ... fields) {
        CottontailGrpc.Projection.Builder builder;
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.builder.clearProjection();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Projection.Builder builder3 = builder = builder2.getProjectionBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT_DISTINCT);
        for (String field : fields) {
            builder.addColumns(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn(field)));
        }
        return this;
    }

    @NotNull
    public final Query count() {
        CottontailGrpc.Projection.Builder builder;
        this.builder.clearProjection();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Projection.Builder builder3 = builder = builder2.getProjectionBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setOp(CottontailGrpc.Projection.ProjectionOperation.COUNT);
        builder.addColumns(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn("*")));
        return this;
    }

    @NotNull
    public final Query exists() {
        CottontailGrpc.Projection.Builder builder;
        this.builder.clearProjection();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Projection.Builder builder3 = builder = builder2.getProjectionBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setOp(CottontailGrpc.Projection.ProjectionOperation.EXISTS);
        builder.addColumns(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn("*")));
        return this;
    }

    @NotNull
    public final Query from(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.builder.clearFrom();
        this.builder.setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(StringExtensionsKt.parseEntity(entity))));
        return this;
    }

    @NotNull
    public final Query from(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean bl = Intrinsics.areEqual((Object)query, (Object)this) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "SUB-SELECT query cannot specify itself.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.builder.clearFrom();
        this.builder.setFrom(CottontailGrpc.From.newBuilder().setSubSelect(query.builder));
        return this;
    }

    @NotNull
    public final Query where(@NotNull Predicate predicate) {
        block1: {
            Predicate predicate2;
            CottontailGrpc.Where.Builder builder;
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
                    this.builder.clearWhere();
                    CottontailGrpc.Query.Builder builder2 = this.builder;
                    Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
                    builder = builder2.getWhereBuilder();
                    predicate2 = predicate;
                    if (!(predicate2 instanceof Atomic)) break block0;
                    builder.setAtomic(((Atomic)predicate).toPredicate());
                    break block1;
                }
                if (!(predicate2 instanceof And)) break block2;
                builder.setCompound(((And)predicate).toPredicate());
                break block1;
            }
            if (!(predicate2 instanceof Or)) break block1;
            builder.setCompound(((Or)predicate).toPredicate());
        }
        return this;
    }

    @NotNull
    public final Query knn(@NotNull String column, int k, @NotNull String distance, @NotNull Object query, @Nullable Object weight) {
        CottontailGrpc.Knn.Builder builder;
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.builder.clearKnn();
        CottontailGrpc.Query.Builder builder2 = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"this.builder");
        CottontailGrpc.Knn.Builder builder3 = builder = builder2.getKnnBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder");
        builder3.setAttribute(StringExtensionsKt.parseColumn(column));
        builder.setK(k);
        String string = distance;
        boolean bl = false;
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        builder.setDistance(CottontailGrpc.Knn.Distance.valueOf(string2));
        builder.setQuery(VectorExtensionKt.toVector(query));
        if (weight != null) {
            builder.setWeight(VectorExtensionKt.toVector(weight));
        }
        return this;
    }

    public static /* synthetic */ Query knn$default(Query query, String string, int n, String string2, Object object, Object object2, int n2, Object object3) {
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        return query.knn(string, n, string2, object, object2);
    }

    @NotNull
    public final Query order(Pair<String, String> ... clauses) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        this.builder.clearOrder();
        CottontailGrpc.Query.Builder builder = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"this.builder");
        CottontailGrpc.Order.Builder builder2 = builder.getOrderBuilder();
        for (Pair<String, String> c : clauses) {
            CottontailGrpc.Order.Component.Builder cBuilder;
            CottontailGrpc.Order.Component.Builder builder3 = cBuilder = builder2.addComponentsBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"cBuilder");
            builder3.setColumn(StringExtensionsKt.parseColumn((String)c.getFirst()));
            String string = (String)c.getSecond();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            cBuilder.setDirection(CottontailGrpc.Order.Direction.valueOf(string3));
        }
        return this;
    }

    @NotNull
    public final Query skip(long skip) {
        CottontailGrpc.Query.Builder builder = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"this.builder");
        builder.setSkip(skip);
        return this;
    }

    @NotNull
    public final Query limit(long limit) {
        CottontailGrpc.Query.Builder builder = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"this.builder");
        builder.setLimit(limit);
        return this;
    }

    public Query(@Nullable String entity) {
        this.builder = CottontailGrpc.Query.newBuilder();
        if (entity != null) {
            this.builder.setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(StringExtensionsKt.parseEntity(entity))));
        }
    }

    public /* synthetic */ Query(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public Query() {
        this(null, 1, null);
    }
}

