/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.client.iterators;

import io.grpc.Context;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.basics.Type;
import org.vitrivr.cottontail.client.language.extensions.NameExtensionsKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001*B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\b\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020(H\u0096\u0002J\t\u0010)\u001a\u00020\u0011H\u0096\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006+"}, d2={"Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl;", "Lorg/vitrivr/cottontail/client/iterators/TupleIterator;", "result", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "context", "Lio/grpc/Context$CancellableContext;", "(Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;Lio/grpc/Context$CancellableContext;)V", "results", "", "(Ljava/util/Iterator;Lio/grpc/Context$CancellableContext;)V", "_columns", "Ljava/util/LinkedHashMap;", "", "", "_simple", "buffer", "Ljava/util/LinkedList;", "Lorg/vitrivr/cottontail/client/iterators/Tuple;", "columnNames", "", "getColumnNames", "()Ljava/util/List;", "columnTypes", "Lorg/vitrivr/cottontail/client/language/basics/Type;", "getColumnTypes", "numberOfColumns", "getNumberOfColumns", "()I", "queryId", "getQueryId", "()Ljava/lang/String;", "simpleNames", "getSimpleNames", "transactionId", "", "getTransactionId", "()J", "close", "", "hasNext", "", "next", "TupleImpl", "cottontaildb-proto"})
public final class TupleIteratorImpl
implements TupleIterator {
    @NotNull
    private final Iterator<CottontailGrpc.QueryResponseMessage> results;
    @NotNull
    private final Context.CancellableContext context;
    @NotNull
    private final LinkedList<Tuple> buffer;
    @NotNull
    private final LinkedHashMap<String, Integer> _columns;
    @NotNull
    private final LinkedHashMap<String, Integer> _simple;
    private final long transactionId;
    @NotNull
    private final String queryId;
    @NotNull
    private final List<Type> columnTypes;

    /*
     * WARNING - void declaration
     */
    public TupleIteratorImpl(@NotNull Iterator<CottontailGrpc.QueryResponseMessage> results, @NotNull Context.CancellableContext context) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.results = results;
        this.context = context;
        this.buffer = new LinkedList();
        this._columns = new LinkedHashMap();
        this._simple = new LinkedHashMap();
        this.columnTypes = new LinkedList();
        CottontailGrpc.QueryResponseMessage next = this.results.next();
        this.transactionId = next.getMetadata().getTransactionId();
        Object object = next.getMetadata().getQueryId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next.metadata.queryId");
        this.queryId = object;
        object = next.getTuplesList();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next.tuplesList");
        List<CottontailGrpc.ColumnDefinition> $this$forEach$iv = (List<CottontailGrpc.ColumnDefinition>)object;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            CottontailGrpc.QueryResponseMessage.Tuple it = (CottontailGrpc.QueryResponseMessage.Tuple)t;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.buffer.add(new TupleImpl(it));
        }
        $this$forEach$iv = next.getColumnsList();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"next.columnsList");
        Iterable $this$forEachIndexed$iv = $this$forEach$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void c;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CottontailGrpc.ColumnDefinition columnDefinition = (CottontailGrpc.ColumnDefinition)item$iv;
            int i = n;
            boolean bl2 = false;
            Object object2 = this._columns;
            Object object3 = c.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"c.name");
            object3 = NameExtensionsKt.fqn((CottontailGrpc.ColumnName)object3);
            Integer bl4 = i;
            boolean object4 = false;
            object2.put(object3, bl4);
            LinkedList linkedList = (LinkedList)this.getColumnTypes();
            object2 = c.getType();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"c.type");
            linkedList.add(Type.Companion.of((CottontailGrpc.Type)((Object)object2)));
            object2 = this._simple;
            object3 = c.getName().getName();
            boolean n3 = false;
            Object bl6 = object2;
            boolean bl3 = false;
            if (bl6.containsKey(object3)) continue;
            object2 = this._simple;
            object3 = c.getName().getName();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"c.name.name");
            Integer n2 = i;
            boolean bl5 = false;
            object2.put(object3, n2);
        }
        if (!this.results.hasNext()) {
            this.context.close();
        }
    }

    public TupleIteratorImpl(@NotNull CottontailGrpc.QueryResponseMessage result, @NotNull Context.CancellableContext context) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = new CottontailGrpc.QueryResponseMessage[]{result};
        this(SequencesKt.sequenceOf((Object[])objectArray).iterator(), context);
    }

    @Override
    public long getTransactionId() {
        return this.transactionId;
    }

    @Override
    @NotNull
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    @NotNull
    public List<String> getColumnNames() {
        Set<String> set = this._columns.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"this._columns.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    @Override
    @NotNull
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @Override
    @NotNull
    public List<String> getSimpleNames() {
        Set<String> set = this._simple.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"this._simple.keys");
        return CollectionsKt.toList((Iterable)set);
    }

    @Override
    public int getNumberOfColumns() {
        return this.getColumnNames().size();
    }

    @Override
    public boolean hasNext() {
        Collection collection = this.buffer;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return true;
        }
        if (!this.results.hasNext()) {
            this.context.close();
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Tuple next() {
        if (this.buffer.isEmpty()) {
            if (!this.results.hasNext()) {
                this.context.close();
                throw new IllegalArgumentException("TupleIterator has been drained and no more elements can be loaded. Call hasNext() to ensure that elements are available before calling next().");
            }
            List<CottontailGrpc.QueryResponseMessage.Tuple> list = this.results.next().getTuplesList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"this.results.next().tuplesList");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CottontailGrpc.QueryResponseMessage.Tuple it = (CottontailGrpc.QueryResponseMessage.Tuple)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.buffer.add(new TupleImpl(it));
            }
        }
        Tuple tuple = this.buffer.poll();
        Intrinsics.checkNotNull((Object)tuple);
        return tuple;
    }

    @Override
    public void close() {
        this.context.cancel((Throwable)new CancellationException("TupleIterator has been prematurely closed by user."));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl$TupleImpl;", "Lorg/vitrivr/cottontail/client/iterators/Tuple;", "tuple", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage$Tuple;", "(Lorg/vitrivr/cottontail/client/iterators/TupleIteratorImpl;Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage$Tuple;)V", "asBoolean", "", "name", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "asBooleanVector", "", "asByte", "", "(Ljava/lang/String;)Ljava/lang/Byte;", "asDate", "Ljava/util/Date;", "asDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "asDoubleVector", "", "asFloat", "", "(Ljava/lang/String;)Ljava/lang/Float;", "asFloatVector", "", "asInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "asIntVector", "", "asLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "asLongVector", "", "asShort", "", "(Ljava/lang/String;)Ljava/lang/Short;", "asString", "indexForName", "nameForIndex", "index", "type", "Lorg/vitrivr/cottontail/client/language/basics/Type;", "cottontaildb-proto"})
    public final class TupleImpl
    extends Tuple {
        public TupleImpl(CottontailGrpc.QueryResponseMessage.Tuple tuple) {
            Intrinsics.checkNotNullParameter((Object)TupleIteratorImpl.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
            super(tuple);
        }

        @Override
        @NotNull
        public String nameForIndex(int index) {
            return TupleIteratorImpl.this.getColumnNames().get(index);
        }

        @Override
        public int indexForName(@NotNull String name) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Integer n2 = (Integer)TupleIteratorImpl.this._columns.get(name);
            if (n2 == null) {
                Integer n3 = (Integer)TupleIteratorImpl.this._simple.get(name);
                if (n3 == null) {
                    throw new IllegalArgumentException("Column " + name + " not known to this TupleIterator.");
                }
                n = n3;
            } else {
                n = n2;
            }
            Integer n4 = n;
            return ((Number)n4).intValue();
        }

        @Override
        @NotNull
        public Type type(int index) {
            return TupleIteratorImpl.this.getColumnTypes().get(index);
        }

        @Override
        @NotNull
        public Type type(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return TupleIteratorImpl.this.getColumnTypes().get(this.indexForName(name));
        }

        @Override
        @Nullable
        public Boolean asBoolean(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asBoolean(this.indexForName(name));
        }

        @Override
        @Nullable
        public Byte asByte(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asByte(this.indexForName(name));
        }

        @Override
        @Nullable
        public Short asShort(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asShort(this.indexForName(name));
        }

        @Override
        @Nullable
        public Integer asInt(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asInt(this.indexForName(name));
        }

        @Override
        @Nullable
        public Long asLong(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asLong(this.indexForName(name));
        }

        @Override
        @Nullable
        public Float asFloat(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asFloat(this.indexForName(name));
        }

        @Override
        @Nullable
        public Double asDouble(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asDouble(this.indexForName(name));
        }

        @Override
        @Nullable
        public boolean[] asBooleanVector(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asBooleanVector(this.indexForName(name));
        }

        @Override
        @Nullable
        public int[] asIntVector(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asIntVector(this.indexForName(name));
        }

        @Override
        @Nullable
        public long[] asLongVector(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asLongVector(this.indexForName(name));
        }

        @Override
        @Nullable
        public float[] asFloatVector(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asFloatVector(this.indexForName(name));
        }

        @Override
        @Nullable
        public double[] asDoubleVector(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asDoubleVector(this.indexForName(name));
        }

        @Override
        @Nullable
        public Date asDate(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asDate(this.indexForName(name));
        }

        @Override
        @Nullable
        public String asString(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.asString(this.indexForName(name));
        }
    }
}

