/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.client.language.dql;

import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.language.basics.Direction;
import org.vitrivr.cottontail.client.language.basics.Distances;
import org.vitrivr.cottontail.client.language.basics.LanguageFeature;
import org.vitrivr.cottontail.client.language.extensions.And;
import org.vitrivr.cottontail.client.language.extensions.Atomic;
import org.vitrivr.cottontail.client.language.extensions.Or;
import org.vitrivr.cottontail.client.language.extensions.Predicate;
import org.vitrivr.cottontail.client.language.extensions.StringExtensionsKt;
import org.vitrivr.cottontail.client.language.extensions.VectorExtensionKt;
import org.vitrivr.cottontail.grpc.CottontailGrpc;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0000J\u0006\u0010\u000b\u001a\u00020\u0000J&\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u001a\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\u001e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003J4\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000fH\u0007J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u001dJ\u001a\u0010$\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u001dJ\u0010\u0010&\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u001dH\u0016J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\f\u0010*\u001a\u00020+*\u00020\u000fH\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/client/language/dql/Query;", "Lorg/vitrivr/cottontail/client/language/basics/LanguageFeature;", "entity", "", "(Ljava/lang/String;)V", "builder", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage$Builder;", "kotlin.jvm.PlatformType", "getBuilder", "()Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage$Builder;", "clear", "count", "distance", "probingColumn", "query", "", "Lorg/vitrivr/cottontail/client/language/basics/Distances;", "name", "distinct", "column", "alias", "exists", "from", "fulltext", "knn", "k", "", "weight", "limit", "", "order", "direction", "Lorg/vitrivr/cottontail/client/language/basics/Direction;", "queryId", "sample", "seed", "select", "skip", "txId", "where", "predicate", "Lorg/vitrivr/cottontail/client/language/extensions/Predicate;", "convertAnyToVector", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$Vector;", "cottontaildb-proto"})
public final class Query
extends LanguageFeature {
    private final CottontailGrpc.QueryMessage.Builder builder;

    public Query(@Nullable String entity) {
        this.builder = CottontailGrpc.QueryMessage.newBuilder();
        if (entity != null) {
            this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(StringExtensionsKt.parseEntity(entity))));
        }
    }

    public /* synthetic */ Query(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public final CottontailGrpc.QueryMessage.Builder getBuilder() {
        return this.builder;
    }

    @Override
    @NotNull
    public Query txId(long txId) {
        this.builder.getMetadataBuilder().setTransactionId(txId);
        return this;
    }

    @Override
    @NotNull
    public Query queryId(@NotNull String queryId) {
        Intrinsics.checkNotNullParameter((Object)queryId, (String)"queryId");
        this.builder.getMetadataBuilder().setQueryId(queryId);
        return this;
    }

    @NotNull
    public final Query select(@NotNull String column, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.SELECT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT);
        }
        CottontailGrpc.Projection.ProjectionElement.Builder element = builder.addElementsBuilder();
        element.setColumn(StringExtensionsKt.parseColumn(column));
        if (alias != null) {
            element.setAlias(StringExtensionsKt.parseColumn(alias));
        }
        return this;
    }

    public static /* synthetic */ Query select$default(Query query, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return query.select(string, string2);
    }

    @NotNull
    public final Query distinct(@NotNull String column, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.SELECT_DISTINCT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.SELECT_DISTINCT);
        }
        CottontailGrpc.Projection.ProjectionElement.Builder element = builder.addElementsBuilder();
        element.setColumn(StringExtensionsKt.parseColumn(column));
        if (alias != null) {
            element.setAlias(StringExtensionsKt.parseColumn(alias));
        }
        return this;
    }

    public static /* synthetic */ Query distinct$default(Query query, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return query.distinct(string, string2);
    }

    @NotNull
    public final Query count() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.COUNT) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.COUNT);
        }
        builder.addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn("*")));
        return this;
    }

    @NotNull
    public final Query exists() {
        CottontailGrpc.Projection.Builder builder = this.builder.getQueryBuilder().getProjectionBuilder();
        if (builder.getOp() != CottontailGrpc.Projection.ProjectionOperation.EXISTS) {
            builder.clearElements();
            builder.setOp(CottontailGrpc.Projection.ProjectionOperation.EXISTS);
        }
        builder.addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setColumn(StringExtensionsKt.parseColumn("*")));
        return this;
    }

    @NotNull
    public final Query from(@NotNull String entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setScan(CottontailGrpc.Scan.newBuilder().setEntity(StringExtensionsKt.parseEntity(entity))));
        return this;
    }

    @NotNull
    public final Query sample(@NotNull String entity, long seed) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setSample(CottontailGrpc.Sample.newBuilder().setEntity(StringExtensionsKt.parseEntity(entity)).setSeed(seed)));
        return this;
    }

    public static /* synthetic */ Query sample$default(Query query, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return query.sample(string, l);
    }

    @NotNull
    public final Query from(@NotNull Query query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        boolean bl = !Intrinsics.areEqual((Object)query, (Object)this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "SUB-SELECT query cannot specify itself.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.builder.getQueryBuilder().setFrom(CottontailGrpc.From.newBuilder().setSubSelect(query.builder.getQueryBuilder()));
        return this;
    }

    @NotNull
    public final Query where(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        CottontailGrpc.Where.Builder builder = this.builder.getQueryBuilder().getWhereBuilder();
        Predicate predicate2 = predicate;
        if (predicate2 instanceof Atomic) {
            builder.setAtomic(((Atomic)predicate).toPredicate());
        } else if (predicate2 instanceof And) {
            builder.setCompound(((And)predicate).toPredicate());
        } else if (predicate2 instanceof Or) {
            builder.setCompound(((Or)predicate).toPredicate());
        }
        return this;
    }

    @Deprecated(message="Deprecated since version 0.13.0; use nns() function instead!", replaceWith=@ReplaceWith(expression="nns", imports={}))
    @NotNull
    public final Query knn(@NotNull String column, int k, @NotNull String distance, @NotNull Object query, @Nullable Object weight) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        if (weight != null) {
            throw new UnsupportedOperationException("Weighted NNS is no longer supported by Cottontail DB. Use weighted distance function with respective arguments instead.");
        }
        String string = distance;
        boolean bl = false;
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        this.distance(column, query, Distances.valueOf(string2), "distance");
        this.builder.getQueryBuilder().getOrderBuilder().addComponents(CottontailGrpc.Order.Component.newBuilder().setColumn(CottontailGrpc.ColumnName.newBuilder().setName("distance")).setDirection(Direction.ASC.toGrpc()));
        this.builder.getQueryBuilder().setLimit(k);
        return this;
    }

    public static /* synthetic */ Query knn$default(Query query, String string, int n, String string2, Object object, Object object2, int n2, Object object3) {
        if ((n2 & 0x10) != 0) {
            object2 = null;
        }
        return query.knn(string, n, string2, object, object2);
    }

    @NotNull
    public final Query distance(@NotNull String probingColumn, @NotNull Object query, @NotNull Distances distance, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)probingColumn, (String)"probingColumn");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)distance), (String)"distance");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CottontailGrpc.ColumnName distanceColumn = StringExtensionsKt.parseColumn(name);
        CottontailGrpc.Function.Builder distanceFunction = CottontailGrpc.Function.newBuilder().setName(distance.toGrpc()).addArguments(CottontailGrpc.Expression.newBuilder().setColumn(StringExtensionsKt.parseColumn(probingColumn))).addArguments(CottontailGrpc.Expression.newBuilder().setLiteral(CottontailGrpc.Literal.newBuilder().setVectorData(this.convertAnyToVector(query))));
        this.builder.getQueryBuilder().getProjectionBuilder().addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setAlias(distanceColumn).setFunction(distanceFunction));
        return this;
    }

    @NotNull
    public final Query fulltext(@NotNull String probingColumn, @NotNull String query, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)probingColumn, (String)"probingColumn");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CottontailGrpc.ColumnName scoreColumn = StringExtensionsKt.parseColumn(name);
        CottontailGrpc.Function.Builder fulltextFunction = CottontailGrpc.Function.newBuilder().setName(CottontailGrpc.FunctionName.newBuilder().setName("fulltext")).addArguments(CottontailGrpc.Expression.newBuilder().setColumn(StringExtensionsKt.parseColumn(probingColumn))).addArguments(CottontailGrpc.Expression.newBuilder().setLiteral(CottontailGrpc.Literal.newBuilder().setStringData(query)));
        this.builder.getQueryBuilder().getProjectionBuilder().addElements(CottontailGrpc.Projection.ProjectionElement.newBuilder().setAlias(scoreColumn).setFunction(fulltextFunction));
        return this;
    }

    @NotNull
    public final Query order(@NotNull String column, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        CottontailGrpc.Order.Builder builder = this.builder.getQueryBuilder().getOrderBuilder();
        CottontailGrpc.Order.Component.Builder cBuilder = builder.addComponentsBuilder();
        cBuilder.setColumn(StringExtensionsKt.parseColumn(column));
        cBuilder.setDirection(direction.toGrpc());
        return this;
    }

    @NotNull
    public final Query skip(long skip) {
        this.builder.getQueryBuilder().setSkip(skip);
        return this;
    }

    @NotNull
    public final Query limit(long limit) {
        this.builder.getQueryBuilder().setLimit(limit);
        return this;
    }

    @NotNull
    public final Query clear() {
        this.builder.getQueryBuilder().clear();
        return this;
    }

    private final CottontailGrpc.Vector convertAnyToVector(Object $this$convertAnyToVector) {
        CottontailGrpc.Vector vector;
        Object object = $this$convertAnyToVector;
        if (object instanceof Object[]) {
            boolean bl = ((Object[])$this$convertAnyToVector)[0] instanceof Number;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Only arrays of numbers can be converted to vector literals.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            vector = VectorExtensionKt.toVector((Number[])$this$convertAnyToVector);
        } else if (object instanceof boolean[]) {
            vector = VectorExtensionKt.toVector((boolean[])$this$convertAnyToVector);
        } else if (object instanceof int[]) {
            vector = VectorExtensionKt.toVector((int[])$this$convertAnyToVector);
        } else if (object instanceof long[]) {
            vector = VectorExtensionKt.toVector((long[])$this$convertAnyToVector);
        } else if (object instanceof float[]) {
            vector = VectorExtensionKt.toVector((float[])$this$convertAnyToVector);
        } else if (object instanceof double[]) {
            vector = VectorExtensionKt.toVector((double[])$this$convertAnyToVector);
        } else {
            throw new IllegalStateException("Conversion of " + $this$convertAnyToVector.getClass().getSimpleName() + " to vector element is not supported.");
        }
        return vector;
    }

    public Query() {
        this(null, 1, null);
    }
}

