/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.cli.Cli;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.database.catalogue.Catalogue;
import org.vitrivr.cottontail.execution.ExecutionEngine;
import org.vitrivr.cottontail.server.grpc.CottontailGrpcServer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u000b"}, d2={"embedded", "Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "config", "Lorg/vitrivr/cottontail/config/Config;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "standalone", "cottontaildb"})
public final class CottontailKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExperimentalTime
    public static final void main(@NotNull String[] args) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object object = args;
        boolean bl = false;
        String[] stringArray = object;
        boolean bl2 = false;
        if (!(stringArray.length == 0) && ArraysKt.contains((Object[])new String[]{"prompt", "cli"}, (Object)args[0])) {
            if (args.length < 3) {
                object = "To start the CLI start Cottontail DB use\n$> cli [<host>] [<port>]";
                bl = false;
                System.out.println(object);
                int n = 1;
                bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            object = args[2];
            bl = false;
            Cli.INSTANCE.loop(args[1], Integer.parseInt((String)object));
            return;
        }
        Object object2 = args;
        boolean bl3 = false;
        if (((String[])object2).length == 0) {
            System.err.println("No config path specified; using default config at ./config.json.");
            path = Paths.get("./config.json", new String[0]);
        } else {
            path = Paths.get((String)ArraysKt.first((Object[])args), new String[0]);
        }
        Path configPath = path;
        object2 = Files.newBufferedReader(configPath);
        bl3 = false;
        bl2 = false;
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)object2;
            boolean bl4 = false;
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)Config.Companion.serializer();
            BufferedReader bufferedReader = reader;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"reader");
            Config config = (Config)Json.Default.decodeFromString(deserializationStrategy, TextStreamsKt.readText((Reader)bufferedReader));
            CottontailKt.standalone(config);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }

    @ExperimentalTime
    public static final void standalone(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Catalogue catalogue = new Catalogue(config);
        ExecutionEngine engine = new ExecutionEngine(config.getExecution());
        CottontailGrpcServer server = new CottontailGrpcServer(config.getServer(), catalogue, engine);
        server.start();
        if (config.getCli()) {
            Cli.INSTANCE.setCottontailServer(server);
            Cli.INSTANCE.loop("localhost", config.getServer().getPort());
        } else {
            while (server.isRunning()) {
                Thread.sleep(1000L);
            }
        }
    }

    @ExperimentalTime
    @NotNull
    public static final CottontailGrpcServer embedded(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Catalogue catalogue = new Catalogue(config);
        ExecutionEngine engine = new ExecutionEngine(config.getExecution());
        CottontailGrpcServer server = new CottontailGrpcServer(config.getServer(), catalogue, engine);
        server.start();
        return server;
    }
}

