/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.catalogue;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.catalogue.CatalogueEntry;
import org.vitrivr.cottontail.database.catalogue.CatalogueEntrySerializer;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.database.catalogue.CatalogueHeaderSerializer;
import org.vitrivr.cottontail.database.general.DBO;
import org.vitrivr.cottontail.database.schema.Schema;
import org.vitrivr.cottontail.database.schema.SchemaHeader;
import org.vitrivr.cottontail.database.schema.SchemaHeaderSerializer;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u001fJ\u000e\u0010.\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u001fJ\b\u0010/\u001a\u00020,H\u0004J\u0010\u00100\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00101\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u00102\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u001fR\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/Catalogue;", "Lorg/vitrivr/cottontail/database/general/DBO;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "header", "Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/catalogue/CatalogueHeader;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$RootName;", "parent", "getParent", "()Lorg/vitrivr/cottontail/database/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "Ljava/util/HashMap;", "Lorg/vitrivr/cottontail/model/basics/Name$SchemaName;", "Lorg/vitrivr/cottontail/database/schema/Schema;", "schemas", "", "getSchemas", "()Ljava/util/Collection;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/CottontailStoreWAL;", "close", "", "createSchema", "dropSchema", "finalize", "initStore", "openStore", "schemaForName", "Companion", "cottontaildb"})
public final class Catalogue
implements DBO {
    @NotNull
    private final Path path;
    @NotNull
    private final Name.RootName name;
    @Nullable
    private final DBO parent;
    private final ReentrantReadWriteLock lock;
    private final HashMap<Name.SchemaName, Schema> registry;
    private final CottontailStoreWAL store;
    private volatile boolean closed;
    @NotNull
    private final Config config;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return this.name;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    private final CatalogueHeader getHeader() {
        CatalogueHeader catalogueHeader = (CatalogueHeader)this.store.get(1L, CatalogueHeaderSerializer.INSTANCE);
        if (catalogueHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue header!");
        }
        return catalogueHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<Name.SchemaName> getSchemas() {
        List list;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            Set<Name.SchemaName> set = this.registry.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"this.registry.keys");
            list = CollectionsKt.toList((Iterable)set);
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            n = this.getHeader().getSchemas().length;
        }
        finally {
            readLock.unlock();
        }
        return n;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int n;
        int n2;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            Map $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl5 = false;
            Iterator iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$_u24__u24$v = element$iv = iterator2.next();
                boolean bl6 = false;
                Map.Entry entry = $dstr$_u24__u24$v;
                boolean bl7 = false;
                Schema v = (Schema)entry.getValue();
                v.close();
            }
            this.store.close();
            this.closed = true;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl8 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    protected final synchronized void finalize() {
        if (!this.getClosed()) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createSchema(@NotNull Name.SchemaName name) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            if (this.registry.containsKey(name)) {
                throw (Throwable)new DatabaseException.SchemaAlreadyExistsException(name);
            }
            Path path = this.getPath().resolve("schema_" + name.getSimple());
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    throw (Throwable)new DatabaseException("Failed to create schema '" + name + "'. Data directory '" + path + "' seems to be occupied.");
                }
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to an IO exception: " + e.getMessage());
            }
            try {
                MapDBConfig mapDBConfig = this.config.getMapdb();
                Path path2 = path.resolve("index.db");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(Schema.FILE_CATALOGUE)");
                CottontailStoreWAL store = mapDBConfig.store(path2);
                store.put(new SchemaHeader(0L, 0L, null, 7, null), SchemaHeaderSerializer.INSTANCE);
                store.commit();
                store.close();
                long sid = this.store.put(new CatalogueEntry(name.getSimple()), CatalogueEntrySerializer.INSTANCE);
                CatalogueHeader catalogueHeader = this.getHeader();
                boolean bl5 = false;
                boolean bl6 = false;
                CatalogueHeader it = catalogueHeader;
                boolean bl7 = false;
                long l = it.getSize() + 1L;
                long l2 = it.getCreated();
                long l3 = System.currentTimeMillis();
                long[] lArray = it.getSchemas();
                int n6 = it.getSchemas().length + 1;
                boolean bl8 = false;
                long[] lArray2 = Arrays.copyOf(lArray, n6);
                Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
                CatalogueHeader catalogueHeader2 = new CatalogueHeader(l, l2, l3, lArray2);
                catalogueHeader2.getSchemas()[catalogueHeader2.getSchemas().length - 1] = sid;
                this.store.update(1L, catalogueHeader2, CatalogueHeaderSerializer.INSTANCE);
                this.store.commit();
            }
            catch (DBException e) {
                List pathsToDelete;
                this.store.rollback();
                List list = pathsToDelete = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
                Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl9 = false;
                    Files.delete(it);
                }
                throw (Throwable)new DatabaseException("Failed to create schema '" + name + "' due to a storage exception: " + e.getMessage());
            }
            Map map2 = this.registry;
            Path path3 = path;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            map2.put(name, new Schema(name, path3, this));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n7 = n2++;
                boolean bl10 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void dropSchema(@NotNull Name.SchemaName name) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            List pathsToDelete;
            Object it3;
            Object v2;
            boolean destination$iv$iv22;
            block14: {
                Object $this$mapTo$iv$iv;
                boolean bl4 = false;
                Schema schema = this.registry.get(name);
                if (schema == null) {
                    throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
                }
                schema.close();
                Object $this$map$iv = this.getHeader().getSchemas();
                boolean $i$f$map = false;
                long[] lArray = $this$map$iv;
                Collection destination$iv$iv22 = new ArrayList(((long[])$this$map$iv).length);
                boolean $i$f$mapTo22 = false;
                Object t = $this$mapTo$iv$iv;
                int n6 = ((void)t).length;
                for (int i = 0; i < n6; ++i) {
                    void it2;
                    void item$iv$iv;
                    void var22_38 = item$iv$iv = t[i];
                    Collection collection = destination$iv$iv22;
                    boolean bl5 = false;
                    CatalogueEntry catalogueEntry = (CatalogueEntry)this.store.get((long)it2, CatalogueEntrySerializer.INSTANCE);
                    if (catalogueEntry == null) {
                        throw (Throwable)new DatabaseException.DataCorruptionException("Failed to read Cottontail DB catalogue entry for SID=" + (long)it2 + '!');
                    }
                    Pair pair = TuplesKt.to((Object)((long)it2), (Object)catalogueEntry);
                    collection.add(pair);
                }
                $this$map$iv = (List)destination$iv$iv22;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv22 = false;
                Iterator $i$f$mapTo22 = $this$mapTo$iv$iv.iterator();
                while ($i$f$mapTo22.hasNext()) {
                    t = $i$f$mapTo22.next();
                    Pair it3 = (Pair)t;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)((CatalogueEntry)it3.getSecond()).getName(), (Object)name.getSimple())) continue;
                    v2 = t;
                    break block14;
                }
                v2 = null;
            }
            Pair pair = v2;
            if (pair == null) {
                throw (Throwable)new DatabaseException("Failed to drop schema '" + name + "'. Did not find a Cottontail DB catalogue entry for schema " + name + '!');
            }
            Pair catalogueEntry = pair;
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                this.store.delete(((Number)catalogueEntry.getFirst()).longValue(), CatalogueEntrySerializer.INSTANCE);
                CatalogueHeader $i$f$map = this.getHeader();
                boolean $this$mapTo$iv$iv = false;
                destination$iv$iv22 = false;
                CatalogueHeader it4 = $i$f$map;
                boolean bl7 = false;
                it3 = it4.getSchemas();
                long l = System.currentTimeMillis();
                long l2 = it4.getCreated();
                long l3 = it4.getSize() - 1L;
                boolean $i$f$filter = false;
                void var37_47 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var40_50 = $this$filterTo$iv$iv;
                int n7 = ((void)var40_50).length;
                for (int i = 0; i < n7; ++i) {
                    void element$iv$iv;
                    void it5 = element$iv$iv = var40_50[i];
                    boolean bl8 = false;
                    if (!(it5 != ((Number)catalogueEntry.getFirst()).longValue())) continue;
                    destination$iv$iv.add((long)element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                long[] lArray = CollectionsKt.toLongArray((Collection)list);
                long l4 = l;
                long l5 = l2;
                long l6 = l3;
                CatalogueHeader catalogueHeader = new CatalogueHeader(l6, l5, l4, lArray);
                this.store.update(1L, catalogueHeader, CatalogueHeaderSerializer.INSTANCE);
                this.store.commit();
            }
            catch (DBException e) {
                this.store.rollback();
                throw (Throwable)new DatabaseException("Failed to drop schema '" + name + "' due to a storage exception: " + e.getMessage());
            }
            this.registry.remove(name);
            Path path = this.getPath().resolve("schema_" + name.getSimple());
            List list = pathsToDelete = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"pathsToDelete");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it3 = (Path)element$iv;
                boolean bl9 = false;
                Files.delete((Path)it3);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n8 = n2++;
                boolean bl10 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Schema schemaForName(@NotNull Name.SchemaName name) {
        Schema schema;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            Schema schema2 = this.registry.get(name);
            if (schema2 == null) {
                throw (Throwable)new DatabaseException.SchemaDoesNotExistException(name);
            }
            Schema schema3 = schema2;
            schema = schema3;
        }
        finally {
            readLock.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"this.lock.read {\n       \u2026xistException(name)\n    }");
        return schema;
    }

    private final CottontailStoreWAL openStore(Path path) {
        CottontailStoreWAL cottontailStoreWAL;
        try {
            cottontailStoreWAL = this.config.getMapdb().store(path);
        }
        catch (DBException e) {
            throw (Throwable)new DatabaseException("Failed to open Cottontail DB catalogue: " + e.getMessage() + "'.");
        }
        return cottontailStoreWAL;
    }

    /*
     * WARNING - void declaration
     */
    private final CottontailStoreWAL initStore(Path path) {
        void var2_3;
        try {
            try {
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                throw (Throwable)new DatabaseException("Failed to create Cottontail DB catalogue due to an IO exception: " + e.getMessage());
            }
            MapDBConfig mapDBConfig = this.config.getMapdb();
            Path path2 = this.config.getRoot().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.config.root.resolve(FILE_CATALOGUE)");
            CottontailStoreWAL store = mapDBConfig.store(path2);
            store.put(new CatalogueHeader(0L, 0L, 0L, null, 15, null), CatalogueHeaderSerializer.INSTANCE);
            store.commit();
        }
        catch (DBException e) {
            throw (Throwable)new DatabaseException("Failed to initialize the Cottontail DB catalogue: " + e.getMessage() + "'.");
        }
        return var2_3;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public Catalogue(@NotNull Config config) {
        CottontailStoreWAL cottontailStoreWAL;
        CottontailStoreWAL cottontailStoreWAL2;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.config.getRoot();
        this.name = Name.RootName.INSTANCE;
        this.lock = new ReentrantReadWriteLock();
        this.registry = new HashMap();
        Path path = this.getPath();
        boolean bl = false;
        boolean bl2 = false;
        Path path2 = path;
        Catalogue catalogue = this;
        boolean bl3 = false;
        Path file = this.getPath().resolve(FILE_CATALOGUE);
        if (Files.exists(file, new LinkOption[0])) {
            Path path3 = file;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
            cottontailStoreWAL2 = this.openStore(path3);
        } else {
            Path path4 = file;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
            cottontailStoreWAL2 = this.initStore(path4);
        }
        catalogue.store = cottontailStoreWAL = cottontailStoreWAL2;
        CatalogueHeader header = this.getHeader();
        for (long sid : header.getSchemas()) {
            CatalogueEntry schema;
            if ((CatalogueEntry)this.store.get(sid, CatalogueEntrySerializer.INSTANCE) == null) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue entry!");
            }
            Path path5 = this.getPath().resolve("schema_" + schema.getName());
            if (!Files.exists(path5, new LinkOption[0])) {
                throw (Throwable)new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schema.getName() + "'. Path " + path5 + " does not exist!");
            }
            Name.SchemaName schemaName = new Name.SchemaName(schema.getName());
            Path path6 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"path");
            Schema s = new Schema(schemaName, path6, this);
            ((Map)this.registry).put(s.getName(), s);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/database/catalogue/Catalogue$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

