/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.column.mapdb;

import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.mapdb.StoreWAL;
import org.mapdb.volume.VolumeFactory;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.database.column.Column;
import org.vitrivr.cottontail.database.column.ColumnTransaction;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.column.mapdb.ColumnHeader;
import org.vitrivr.cottontail.database.column.mapdb.ColumnHeaderSerializer;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.general.TransactionStatus;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;
import org.vitrivr.cottontail.model.exceptions.TransactionException;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003012B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010)\u001a\u00020*H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,2\u0006\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0016R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;", "T", "Lorg/vitrivr/cottontail/model/values/types/Value;", "Lorg/vitrivr/cottontail/database/column/Column;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;Lorg/vitrivr/cottontail/database/entity/Entity;)V", "<set-?>", "", "closed", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "globalLock", "Ljava/util/concurrent/locks/StampedLock;", "header", "Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "getHeader", "()Lorg/vitrivr/cottontail/database/column/mapdb/ColumnHeader;", "maxTupleId", "", "getMaxTupleId", "()J", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "txLock", "close", "", "newTransaction", "Lorg/vitrivr/cottontail/database/column/ColumnTransaction;", "readonly", "tid", "Ljava/util/UUID;", "ColumnRecord", "Companion", "Tx", "cottontaildb"})
public final class MapDBColumn<T extends Value>
implements Column<T> {
    @NotNull
    private final Path path;
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private volatile boolean closed;
    private final StampedLock txLock;
    private final StampedLock globalLock;
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final Entity parent;
    private static final long HEADER_RECORD_ID = 1L;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    private final ColumnHeader getHeader() {
        ColumnHeader columnHeader = (ColumnHeader)this.store.get(1L, ColumnHeaderSerializer.INSTANCE);
        if (columnHeader == null) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnHeader;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.globalLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-MapDBColumn$close$22 = false;
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-MapDBColumn$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public ColumnTransaction<T> newTransaction(boolean readonly, @NotNull UUID tid) {
        Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
        return new Tx(readonly, tid);
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public MapDBColumn(@NotNull Name.ColumnName name, @NotNull Entity parent) {
        void it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Path path = this.getParent().getPath().resolve("col_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"parent.path.resolve(\"col_${name.simple}.db\")");
        this.path = path;
        MapDBColumn mapDBColumn = this;
        try {
            MapDBColumn mapDBColumn2 = mapDBColumn;
            object = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            MapDBColumn mapDBColumn3 = mapDBColumn;
            throw (Throwable)new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'');
        }
        mapDBColumn2.store = object;
        object = this.getHeader();
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        mapDBColumn = this;
        boolean bl3 = false;
        ColumnType<?> columnType = it.getType();
        if (columnType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.database.column.ColumnType<T>");
        }
        ColumnDef columnDef = new ColumnDef(this.getName(), columnType, it.getSize(), it.getNullable());
        mapDBColumn.columnDef = columnDef;
        this.txLock = new StampedLock();
        this.globalLock = new StampedLock();
    }

    @Override
    @NotNull
    public ColumnType<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    public static final /* synthetic */ void access$setStore$p(MapDBColumn $this, CottontailStoreWAL cottontailStoreWAL) {
        $this.store = cottontailStoreWAL;
    }

    public static final /* synthetic */ boolean access$getClosed$p(MapDBColumn $this) {
        return $this.getClosed();
    }

    public static final /* synthetic */ void access$setClosed$p(MapDBColumn $this, boolean bl) {
        $this.closed = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0001H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016R \u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$ColumnRecord;", "Lorg/vitrivr/cottontail/model/basics/Record;", "tupleId", "", "value", "Lorg/vitrivr/cottontail/model/values/types/Value;", "(Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;JLorg/vitrivr/cottontail/model/values/types/Value;)V", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getTupleId", "()J", "getValue", "()Lorg/vitrivr/cottontail/model/values/types/Value;", "values", "getValues", "()[Lorg/vitrivr/cottontail/model/values/types/Value;", "copy", "first", "last", "cottontaildb"})
    public final class ColumnRecord
    implements Record {
        private final long tupleId;
        @Nullable
        private final Value value;

        @NotNull
        public ColumnDef<T>[] getColumns() {
            return new ColumnDef[]{MapDBColumn.this.getColumnDef()};
        }

        @Override
        @NotNull
        public Value[] getValues() {
            return new Value[]{this.value};
        }

        @Override
        @Nullable
        public Value first() {
            return this.value;
        }

        @Override
        @Nullable
        public Value last() {
            return this.value;
        }

        @Override
        @NotNull
        public Record copy() {
            return new ColumnRecord(this.getTupleId(), this.value);
        }

        @Override
        public long getTupleId() {
            return this.tupleId;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        public ColumnRecord(@Nullable long tupleId, Value value) {
            this.tupleId = tupleId;
            this.value = value;
        }

        @Override
        public int getSize() {
            return Record.DefaultImpls.getSize(this);
        }

        @Override
        @NotNull
        public Record assign(@NotNull Value[] values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            return Record.DefaultImpls.assign(this, values);
        }

        @Override
        public boolean has(@NotNull ColumnDef<?> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return Record.DefaultImpls.has(this, column);
        }

        @Override
        @NotNull
        public Map<Name, Value> toMap() {
            return Record.DefaultImpls.toMap(this);
        }

        @Override
        @Nullable
        public <T extends Value> T get(@NotNull ColumnDef<T> column) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            return Record.DefaultImpls.get(this, column);
        }

        @Override
        public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
            Intrinsics.checkNotNullParameter(column, (String)"column");
            Record.DefaultImpls.set(this, column, value);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J)\u0010\"\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00018\u00002\b\u0010$\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\fH\u0016J\u0017\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010*J\u0017\u0010+\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u001cH\u0016J\u0012\u0010.\u001a\f\u0012\b\u0012\u00060\fj\u0002`00/H\u0016J\u001a\u0010.\u001a\f\u0012\b\u0012\u00060\fj\u0002`00/2\u0006\u00101\u001a\u000202H\u0016J\u001f\u00103\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00104R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Tx;", "Lorg/vitrivr/cottontail/database/column/ColumnTransaction;", "readonly", "", "tid", "Ljava/util/UUID;", "(Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn;ZLjava/util/UUID;)V", "columnDef", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "getColumnDef", "()Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "globalStamp", "", "localLock", "Ljava/util/concurrent/locks/StampedLock;", "getReadonly", "()Z", "serializer", "Lorg/mapdb/Serializer;", "<set-?>", "Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "status", "getStatus", "()Lorg/vitrivr/cottontail/database/general/TransactionStatus;", "getTid", "()Ljava/util/UUID;", "txStamp", "checkValidForRead", "", "checkValidForWrite", "checkValidTupleId", "tupleId", "close", "commit", "compareAndUpdate", "value", "expected", "(JLorg/vitrivr/cottontail/model/values/types/Value;Lorg/vitrivr/cottontail/model/values/types/Value;)Z", "count", "delete", "insert", "record", "(Lorg/vitrivr/cottontail/model/values/types/Value;)J", "read", "(J)Lorg/vitrivr/cottontail/model/values/types/Value;", "rollback", "scan", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/model/values/types/Value;)V", "cottontaildb"})
    public final class Tx
    implements ColumnTransaction<T> {
        @NotNull
        private volatile TransactionStatus status;
        private final Serializer<T> serializer;
        private final long globalStamp;
        private final long txStamp;
        private final StampedLock localLock;
        private final boolean readonly;
        @NotNull
        private final UUID tid;

        @Override
        @NotNull
        public TransactionStatus getStatus() {
            return this.status;
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return MapDBColumn.this.getColumnDef();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void commit() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-MapDBColumn$Tx$commit$22 = false;
                if (this.getStatus() == TransactionStatus.DIRTY) {
                    MapDBColumn.this.store.commit();
                    this.status = TransactionStatus.CLEAN;
                }
                Unit $i$a$-write-MapDBColumn$Tx$commit$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void rollback() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-MapDBColumn$Tx$rollback$22 = false;
                if (this.getStatus() == TransactionStatus.DIRTY || this.getStatus() == TransactionStatus.ERROR) {
                    MapDBColumn.this.store.rollback();
                    this.status = TransactionStatus.CLEAN;
                }
                Unit $i$a$-write-MapDBColumn$Tx$rollback$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() {
            StampedLock $this$write$iv = this.localLock;
            boolean $i$f$write = false;
            long stamp$iv = $this$write$iv.writeLock();
            try {
                boolean $i$a$-write-MapDBColumn$Tx$close$22 = false;
                if (this.getStatus() != TransactionStatus.CLOSED) {
                    if (this.getStatus() == TransactionStatus.DIRTY || this.getStatus() == TransactionStatus.ERROR) {
                        this.rollback();
                    }
                    this.status = TransactionStatus.CLOSED;
                    MapDBColumn.this.txLock.unlock(this.txStamp);
                    MapDBColumn.this.globalLock.unlockRead(this.globalStamp);
                }
                Unit $i$a$-write-MapDBColumn$Tx$close$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$write$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                this.checkValidTupleId(tupleId);
                Value value = (Value)MapDBColumn.this.store.get(tupleId, this.serializer);
                return value;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                this.checkValidForRead();
                long l = MapDBColumn.this.getHeader().getCount();
                return l;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Long> scan() {
            long l = 1L;
            return this.scan(new LongRange(l, MapDBColumn.this.getMaxTupleId()));
        }

        @Override
        @NotNull
        public CloseableIterator<Long> scan(@NotNull LongRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new CloseableIterator<Long>(this, range){
                private final long lock;
                private final CottontailStoreWAL.RecordIdIterator wrapped;
                private volatile boolean closed;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ LongRange $range;

                @NotNull
                public Long next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return this.wrapped.next();
                }

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return this.wrapped.hasNext();
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.lock);
                        this.closed = true;
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$range = $captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    this.lock = Tx.access$getLocalLock$p(this$0).readLock();
                    this.wrapped = new CottontailStoreWAL.RecordIdIterator(MapDBColumn.access$getStore$p(this$0.MapDBColumn.this), $captured_local_variable$1);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long insert(@Nullable T record) {
            long $i$a$-read-MapDBColumn$Tx$insert$22;
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                long l;
                boolean $i$a$-read-MapDBColumn$Tx$insert$22 = false;
                try {
                    ColumnHeader header;
                    this.checkValidForWrite();
                    long tupleId = record == null ? MapDBColumn.this.store.preallocate() : MapDBColumn.this.store.put(MapDBColumn.this.getType().cast((Value)record), this.serializer);
                    ColumnHeader columnHeader = header = MapDBColumn.this.getHeader();
                    columnHeader.setCount(columnHeader.getCount() + 1L);
                    header.setModified(System.currentTimeMillis());
                    MapDBColumn.this.store.update(1L, header, ColumnHeaderSerializer.INSTANCE);
                    l = tupleId;
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    UUID uUID = this.getTid();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    throw (Throwable)new TransactionException.TransactionStorageException(uUID, string);
                }
                $i$a$-read-MapDBColumn$Tx$insert$22 = l;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return $i$a$-read-MapDBColumn$Tx$insert$22;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(long tupleId, @Nullable T value) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                try {
                    this.checkValidForWrite();
                    this.checkValidTupleId(tupleId);
                    MapDBColumn.this.store.update(tupleId, value, this.serializer);
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    UUID uUID = this.getTid();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    throw (Throwable)new TransactionException.TransactionStorageException(uUID, string);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            boolean bl;
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl2;
                boolean bl3 = false;
                try {
                    this.checkValidForWrite();
                    this.checkValidTupleId(tupleId);
                    bl2 = MapDBColumn.this.store.compareAndSwap(tupleId, expected, value, this.serializer);
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    UUID uUID = this.getTid();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    throw (Throwable)new TransactionException.TransactionStorageException(uUID, string);
                }
                bl = bl2;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(long tupleId) {
            StampedLock $this$read$iv = this.localLock;
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean bl = false;
                try {
                    ColumnHeader header;
                    this.checkValidForWrite();
                    this.checkValidTupleId(tupleId);
                    MapDBColumn.this.store.delete(tupleId, this.serializer);
                    ColumnHeader columnHeader = header = MapDBColumn.this.getHeader();
                    columnHeader.setCount(columnHeader.getCount() - 1L);
                    header.setModified(System.currentTimeMillis());
                    MapDBColumn.this.store.update(1L, header, ColumnHeaderSerializer.INSTANCE);
                }
                catch (DBException e) {
                    this.status = TransactionStatus.ERROR;
                    UUID uUID = this.getTid();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Unknown";
                    }
                    throw (Throwable)new TransactionException.TransactionStorageException(uUID, string);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        private final void checkValidTupleId(long tupleId) {
            if (tupleId < 0L | tupleId == 1L) {
                throw (Throwable)((Object)new TransactionException.InvalidTupleId(this.getTid(), tupleId));
            }
        }

        private final synchronized void checkValidForRead() {
            if (this.getStatus() == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
        }

        private final synchronized void checkValidForWrite() {
            if (this.getReadonly()) {
                throw (Throwable)new TransactionException.TransactionReadOnlyException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.CLOSED) {
                throw (Throwable)new TransactionException.TransactionClosedException(this.getTid());
            }
            if (this.getStatus() == TransactionStatus.ERROR) {
                throw (Throwable)new TransactionException.TransactionInErrorException(this.getTid());
            }
            if (this.getStatus() != TransactionStatus.DIRTY) {
                this.status = TransactionStatus.DIRTY;
            }
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @NotNull
        public UUID getTid() {
            return this.tid;
        }

        public Tx(@NotNull boolean readonly, UUID tid) {
            Intrinsics.checkNotNullParameter((Object)tid, (String)"tid");
            this.readonly = readonly;
            this.tid = tid;
            this.status = TransactionStatus.CLEAN;
            if (MapDBColumn.this.getClosed()) {
                throw (Throwable)new TransactionException.TransactionDBOClosedException(this.getTid());
            }
            this.serializer = MapDBColumn.this.getType().serializer(MapDBColumn.this.getColumnDef().getLogicalSize());
            this.globalStamp = MapDBColumn.this.globalLock.readLock();
            this.txStamp = this.getReadonly() ? MapDBColumn.this.txLock.readLock() : MapDBColumn.this.txLock.writeLock();
            this.localLock = new StampedLock();
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.localLock;
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/database/column/mapdb/MapDBColumn$Companion;", "", "()V", "HEADER_RECORD_ID", "", "initialize", "", "definition", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "path", "Ljava/nio/file/Path;", "config", "Lorg/vitrivr/cottontail/config/MapDBConfig;", "cottontaildb"})
    public static final class Companion {
        public final void initialize(@NotNull ColumnDef<?> definition, @NotNull Path path, @NotNull MapDBConfig config) {
            Intrinsics.checkNotNullParameter(definition, (String)"definition");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            StoreWAL store = StoreWAL.Companion.make$default((StoreWAL.Companion)StoreWAL.Companion, (String)((Object)path.resolve("col_" + definition.getName().getSimple() + ".db")).toString(), (VolumeFactory)config.getVolumeFactory(), (long)0L, (boolean)false, (int)0, (long)(1L << config.getPageShift()), (long)0L, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (int)4060, null);
            store.put((Object)new ColumnHeader(definition.getType(), definition.getLogicalSize(), definition.getNullable(), 0L, 0L, 0L, 56, null), (Serializer)ColumnHeaderSerializer.INSTANCE);
            store.commit();
            store.close();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

