/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.database.entity.IndexEntry;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.model.exceptions.DatabaseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/database/entity/IndexEntrySerializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/database/entity/IndexEntry;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb"})
public final class IndexEntrySerializer
implements Serializer<IndexEntry> {
    public static final IndexEntrySerializer INSTANCE;

    public void serialize(@NotNull DataOutput2 out, @NotNull IndexEntry value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        out.writeUTF(value.getName());
        out.writeUTF(value.getType().name());
        out.writeBoolean(value.getDirty());
        out.writeInt(value.getColumns().length);
        String[] $this$forEach$iv = value.getColumns();
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl = false;
            out.writeUTF(it);
        }
    }

    @NotNull
    public IndexEntry deserialize(@NotNull DataInput2 input, int available) {
        IndexEntry indexEntry;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            String name = input.readUTF();
            String string = input.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"input.readUTF()");
            IndexType type = IndexType.valueOf(string);
            boolean dirty = input.readBoolean();
            int length = input.readInt();
            String[] stringArray = new String[length];
            int n = 0;
            while (n < length) {
                String string2;
                int n2 = n;
                int n3 = n++;
                String[] stringArray2 = stringArray;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)input.readUTF(), (String)"input.readUTF()");
                stringArray2[n3] = string2;
            }
            String[] columns = stringArray;
            String string3 = name;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
            indexEntry = new IndexEntry(string3, type, dirty, columns);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new DatabaseException.DataCorruptionException("Unsupported index type: " + e.getMessage());
        }
        return indexEntry;
    }

    private IndexEntrySerializer() {
    }

    static {
        IndexEntrySerializer indexEntrySerializer;
        INSTANCE = indexEntrySerializer = new IndexEntrySerializer();
    }
}

