/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.hash;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.hash.UniqueHashIndex$Tx$WhenMappings;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.exceptions.ValidationException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u000234B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010)\u001a\u00020*2\n\u0010\u0004\u001a\u00060+R\u00020\u0005H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020.H\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0016\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R \u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\"\u0010\u0010R\u0014\u0010#\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000eR\u0014\u0010%\u001a\u00020&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "db", "Lorg/mapdb/DB;", "map", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/model/values/types/Value;", "", "Lorg/vitrivr/cottontail/model/basics/TupleId;", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "produces", "getProduces", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "Companion", "Tx", "cottontaildb"})
public final class UniqueHashIndex
extends Index {
    @NotNull
    private final Path path;
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    @NotNull
    private final ColumnDef<?>[] produces;
    private final DB db;
    private final HTreeMap<? extends Value, Long> map;
    private volatile boolean closed;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    public static final String MAP_FIELD_NAME = "map";
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof AtomicBooleanPredicate ? Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) && (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.IN || ((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.EQUAL) : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof AtomicBooleanPredicate) || Intrinsics.areEqual((Object)((ColumnDef)CollectionsKt.first((Iterable)predicate.getColumns())), this.getColumns()[0]) ^ true) {
            cost = Cost.Companion.getINVALID();
        } else if (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.EQUAL) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS();
            float f2 = 1.0E-4f;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ColumnDef columnDef = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f3 = CollectionsKt.sumOfInt((Iterable)collection);
            float f4 = f;
            float f5 = f2;
            cost = new Cost(f5, f4, f3);
        } else if (((AtomicBooleanPredicate)predicate).getOperator() == ComparisonOperator.IN) {
            Collection<Integer> collection;
            Iterable $this$map$iv = predicate.getColumns();
            float f = Cost.Companion.getCOST_MEMORY_ACCESS() * (float)((AtomicBooleanPredicate)predicate).getValues().size();
            float f6 = 1.0E-4f * (float)((AtomicBooleanPredicate)predicate).getValues().size();
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ColumnDef it = (ColumnDef)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Integer n = it.getPhysicalSize();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            float f7 = CollectionsKt.sumOfInt((Iterable)collection);
            float f8 = f;
            float f9 = f6;
            cost = new Cost(f9, f8, f7);
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTransaction begin(@NotNull Entity.Tx parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Tx(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.getGlobalLock();
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-UniqueHashIndex$close$22 = false;
            if (!this.getClosed()) {
                this.db.close();
                this.closed = true;
            }
            Unit $i$a$-write-UniqueHashIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public UniqueHashIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.parent = parent;
        this.columns = columns;
        Path path = this.getParent().getPath().resolve("idx_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve(\"idx_${name.simple}.db\")");
        this.path = path;
        this.type = IndexType.HASH_UQ;
        this.supportsIncrementalUpdate = true;
        this.produces = this.getColumns();
        this.db = this.getParent().getParent().getParent().getConfig().getMapdb().db(this.getPath());
        Serializer serializer2 = ((ColumnDef)ArraysKt.first((Object[])this.getColumns())).getType().serializer(this.getColumns().length);
        GroupSerializer groupSerializer = Serializer.LONG_PACKED;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"Serializer.LONG_PACKED");
        this.map = this.db.hashMap(MAP_FIELD_NAME, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen();
        this.db.commit();
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(UniqueHashIndex.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0014J\b\u0010\u000f\u001a\u00020\bH\u0014J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/Index;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "cleanup", "", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "performCommit", "performRollback", "rebuild", "update", "", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends Index.Tx {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-UniqueHashIndex$Tx$rebuild$22 = false;
                this.checkValidForWrite();
                LOGGER.trace("Rebuilding unique hash index {}", (Object)UniqueHashIndex.this.getName());
                UniqueHashIndex.this.map.clear();
                HTreeMap hTreeMap = UniqueHashIndex.this.map;
                if (hTreeMap == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mapdb.HTreeMap<org.vitrivr.cottontail.model.values.types.Value, org.vitrivr.cottontail.model.basics.TupleId /* = kotlin.Long */>");
                }
                HTreeMap localMap = hTreeMap;
                AutoCloseable autoCloseable = this.getParent().scan(UniqueHashIndex.this.getColumns());
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    CloseableIterator s = (CloseableIterator)autoCloseable;
                    boolean bl3 = false;
                    Iterator $this$forEach$iv = s;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv;
                    boolean bl4 = false;
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object value;
                        Object element$iv = iterator3.next();
                        Record record = (Record)element$iv;
                        boolean bl5 = false;
                        if (record.get(this.getColumns()[0]) == null) {
                            throw (Throwable)new ValidationException.IndexUpdateException(this.getName(), "A value cannot be null for instances of non-unique hash-index but tid=" + this.getTid() + " is");
                        }
                        if (!localMap.containsKey(value)) {
                            ((Map)localMap).put(value, record.getTupleId());
                            continue;
                        }
                        LOGGER.warn("Value must be unique for instances of unique hash-index but '" + value + "' (tid=" + this.getTid() + ") is not! Skipping entry...");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                LOGGER.trace("Rebuilding unique hash index complete!");
                Unit $i$a$-read-UniqueHashIndex$Tx$rebuild$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Collection<DataChangeEvent> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-UniqueHashIndex$Tx$update$22 = false;
                this.checkValidForWrite();
                HTreeMap hTreeMap = UniqueHashIndex.this.map;
                if (hTreeMap == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.mapdb.HTreeMap<org.vitrivr.cottontail.model.values.types.Value, org.vitrivr.cottontail.model.basics.TupleId /* = kotlin.Long */>");
                }
                HTreeMap localMap = hTreeMap;
                Function1<DataChangeEvent, Unit> $fun$atomicInsert$1 = new Function1<DataChangeEvent, Unit>(localMap, this, update){
                    final /* synthetic */ HTreeMap $localMap;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.$localMap = hTreeMap;
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    public final void invoke(@NotNull DataChangeEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Record record = event.getNew();
                        if (record == null || (record = record.get(this.this$0.getColumns()[0])) == null) {
                            Record record2 = event.getNew();
                            throw (Throwable)new ValidationException.IndexUpdateException(this.this$0.getName(), "Values cannot be null for instances of UniqueHashIndex but tid=" + (record2 != null ? Long.valueOf(record2.getTupleId()) : null) + " is.");
                        }
                        Record newValue = record;
                        ((Map)this.$localMap).put(newValue, event.getNew().getTupleId());
                    }
                };
                Function1<DataChangeEvent, Unit> $fun$atomicDelete$2 = new Function1<DataChangeEvent, Unit>(localMap, this, update){
                    final /* synthetic */ HTreeMap $localMap;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.$localMap = hTreeMap;
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    public final void invoke(@NotNull DataChangeEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Record record = event.getOld();
                        if (record == null || (record = record.get(this.this$0.getColumns()[0])) == null) {
                            Record record2 = event.getNew();
                            throw (Throwable)new ValidationException.IndexUpdateException(this.this$0.getName(), "Values cannot be null for instances of UniqueHashIndex but tid=" + (record2 != null ? Long.valueOf(record2.getTupleId()) : null) + " is.");
                        }
                        Record oldValue = record;
                        this.$localMap.remove((Object)oldValue);
                    }
                };
                for (DataChangeEvent event : update) {
                    switch (UniqueHashIndex$Tx$WhenMappings.$EnumSwitchMapping$0[event.getType().ordinal()]) {
                        case 1: {
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 2: {
                            Record record = event.getNew();
                            Record record2 = event.getOld();
                            if (!(Intrinsics.areEqual(record != null ? record.get(this.getColumns()[0]) : null, record2 != null ? record2.get(this.getColumns()[0]) : null) ^ true)) break;
                            $fun$atomicDelete$2.invoke(event);
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 3: {
                            $fun$atomicDelete$2.invoke(event);
                            break;
                        }
                    }
                }
                Unit $i$a$-read-UniqueHashIndex$Tx$update$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new CloseableIterator<Record>(this, predicate){
                private final AtomicBooleanPredicate<?> predicate;
                private final long lock;
                private volatile boolean closed;
                private final List<Record> results;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of hasNext(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Collection collection = this.results;
                    bl2 = false;
                    return !collection.isEmpty();
                }

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return (Record)CollectionsKt.removeFirst(this.results);
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.lock);
                        this.closed = true;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private final List<Record> prepare() {
                    List list;
                    int n;
                    switch (UniqueHashIndex$Tx$WhenMappings.$EnumSwitchMapping$1[this.predicate.getOperator().ordinal()]) {
                        case 1: {
                            n = 1;
                            break;
                        }
                        case 2: {
                            n = this.predicate.getValues().size();
                            break;
                        }
                        default: {
                            throw (Throwable)new QueryException.UnsupportedPredicateException("Instance of unique hash-index does not support " + (Object)((Object)this.predicate.getOperator()) + " comparison operators.");
                        }
                    }
                    int n2 = n;
                    if (this.predicate.getNot()) {
                        void $this$filterTo$iv$iv;
                        Iterable $this$mapTo$iv$iv;
                        boolean bl;
                        Object element$iv$iv;
                        Map $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = CollectionsKt.take((Iterable)this.predicate.getValues(), (int)n2);
                        boolean $i$f$mapNotNull = false;
                        Iterable iterable = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        Iterator<T> $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<Object> iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            Long l;
                            T t;
                            element$iv$iv = t = iterator2.next();
                            bl = false;
                            Value it = (Value)element$iv$iv;
                            boolean bl2 = false;
                            Map map2 = (Map)UniqueHashIndex.access$getMap$p(this.this$0.UniqueHashIndex.this);
                            boolean bl3 = false;
                            if ((Long)map2.get(it) == null) continue;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Long it$iv$iv = l;
                            boolean bl6 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        HashSet blackList = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
                        Map $this$map$iv = (Map)UniqueHashIndex.access$getMap$p(this.this$0.UniqueHashIndex.this);
                        boolean $i$f$map = false;
                        $this$mapNotNullTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                        boolean $i$f$mapTo = false;
                        $this$forEach$iv$iv$iv = $this$mapTo$iv$iv;
                        $i$f$forEach = false;
                        for (Map.Entry entry : $this$forEach$iv$iv$iv.entrySet()) {
                            void it;
                            element$iv$iv = entry;
                            Collection collection = destination$iv$iv;
                            bl = false;
                            V v = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
                            StandaloneRecord standaloneRecord = new StandaloneRecord(((Number)v).longValue(), this.this$0.UniqueHashIndex.this.getProduces(), new Value[]{(Value)it.getKey()});
                            collection.add(standaloneRecord);
                        }
                        Iterable $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$mapTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv2 : $this$filterTo$iv$iv) {
                            StandaloneRecord it = (StandaloneRecord)element$iv$iv2;
                            boolean bl6 = false;
                            if (!(!blackList.contains(it.getTupleId()))) continue;
                            destination$iv$iv.add(element$iv$iv2);
                        }
                        list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    } else {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$mapNotNull$iv = CollectionsKt.take((Iterable)this.predicate.getValues(), (int)n2);
                        boolean $i$f$mapNotNull = false;
                        Iterable $i$f$filter = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator3 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator3.hasNext()) {
                            StandaloneRecord standaloneRecord;
                            T element$iv$iv$iv;
                            T t = element$iv$iv$iv = iterator3.next();
                            boolean bl = false;
                            Value it = (Value)t;
                            boolean bl7 = false;
                            Map map3 = (Map)UniqueHashIndex.access$getMap$p(this.this$0.UniqueHashIndex.this);
                            boolean bl8 = false;
                            Long tupleId = (Long)map3.get(it);
                            if ((tupleId != null ? new StandaloneRecord(tupleId, this.this$0.UniqueHashIndex.this.getProduces(), new Value[]{it}) : null) == null) continue;
                            standaloneRecord = standaloneRecord;
                            boolean bl9 = false;
                            boolean bl10 = false;
                            StandaloneRecord it$iv$iv = standaloneRecord;
                            boolean bl11 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                    }
                    return list;
                }
                {
                    this.this$0 = this$0;
                    this.$predicate = $captured_local_variable$1;
                    if (!($captured_local_variable$1 instanceof AtomicBooleanPredicate)) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.UniqueHashIndex.this.getName() + "' (non-unique hash-index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (AtomicBooleanPredicate)$captured_local_variable$1;
                    Tx.access$checkValidForRead(this$0);
                    this.lock = Tx.access$getLocalLock$p(this$0).readLock();
                    this.results = this.prepare();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        protected void performCommit() {
            UniqueHashIndex.this.db.commit();
        }

        @Override
        protected void performRollback() {
            UniqueHashIndex.this.db.rollback();
        }

        @Override
        protected void cleanup() {
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent);
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.getLocalLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/database/index/hash/UniqueHashIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "MAP_FIELD_NAME", "", "cottontaildb"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

