/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lsh.superbit;

import java.io.Serializable;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.model.values.Complex32VectorValue;
import org.vitrivr.cottontail.model.values.Complex64VectorValue;
import org.vitrivr.cottontail.model.values.DoubleVectorValue;
import org.vitrivr.cottontail.model.values.FloatVectorValue;
import org.vitrivr.cottontail.model.values.types.NumericValue;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\tR\u001a\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/vitrivr/cottontail/database/index/lsh/superbit/SuperBit;", "Ljava/io/Serializable;", "d", "", "N", "L", "seed", "", "species", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "(IIIJLorg/vitrivr/cottontail/model/values/types/VectorValue;)V", "hyperplanes", "", "[Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "signature", "", "vector", "cottontaildb"})
public final class SuperBit
implements Serializable {
    private final VectorValue<?>[] hyperplanes;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final boolean[] signature(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        boolean[] signature = new boolean[this.hyperplanes.length];
        int n = 0;
        int n2 = this.hyperplanes.length;
        while (n < n2) {
            void i;
            signature[i] = this.hyperplanes[i].dot(vector).compareTo(0) >= 0;
            ++i;
        }
        return signature;
    }

    /*
     * WARNING - void declaration
     */
    public SuperBit(int d, int N, int L, long seed, @NotNull VectorValue<?> species) {
        int it;
        VectorValue vectorValue;
        int n;
        VectorValue[] vectorValueArray;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter(species, (String)"species");
        boolean bl = d > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Dimension d must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = N >= 1 && N <= d;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Super-Bit depth N must be 1 <= N <= d";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = L >= 1;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Number of Super-Bits L must be >= 1";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        SplittableRandom random2 = new SplittableRandom(seed);
        int K = N * L;
        VectorValue[] bl6 = new VectorValue[K];
        for (int i = 0; i < K; ++i) {
            VectorValue<Double> vectorValue2;
            n3 = i;
            n2 = i;
            vectorValueArray = bl6;
            n = 0;
            VectorValue<?> vectorValue3 = species;
            if (vectorValue3 instanceof DoubleVectorValue) {
                vectorValue2 = DoubleVectorValue.box-impl(DoubleVectorValue.Companion.random-Jz4_OW8(species.getLogicalSize(), random2));
            } else if (vectorValue3 instanceof FloatVectorValue) {
                vectorValue2 = FloatVectorValue.box-impl(FloatVectorValue.Companion.random-3wzOJwo(species.getLogicalSize(), random2));
            } else if (vectorValue3 instanceof Complex32VectorValue) {
                vectorValue2 = Complex32VectorValue.box-impl(Complex32VectorValue.Companion.random-4O27Dt0(species.getLogicalSize(), random2));
            } else if (vectorValue3 instanceof Complex64VectorValue) {
                vectorValue2 = Complex64VectorValue.box-impl(Complex64VectorValue.Companion.random-Leomr7I(species.getLogicalSize(), random2));
            } else {
                throw (Throwable)new IllegalArgumentException("");
            }
            VectorValue rnd = vectorValue2;
            vectorValueArray[n2] = vectorValue = rnd.div((NumericValue)rnd.norm2());
        }
        VectorValue[] v = bl6;
        VectorValue[] vectorValueArray2 = new VectorValue[K];
        n3 = 0;
        while (n3 < K) {
            n = n3;
            n2 = n3++;
            vectorValueArray = vectorValueArray2;
            boolean bl7 = false;
            vectorValue = v[it];
            vectorValueArray[n2] = vectorValue;
        }
        VectorValue[] w = vectorValueArray2;
        int n4 = 0;
        n3 = L;
        while (n4 < n3) {
            void i;
            it = 1;
            int n5 = N;
            if (it <= n5) {
                void j;
                do {
                    boolean rnd = true;
                    void var16_31 = ++j;
                    while (rnd < var16_31) {
                        void k;
                        w[i * N + j - true] = w[i * N + j - true].minus(w[i * N + k - true].times(w[i * N + k - true].dot(v[i * N + j - true])));
                        ++k;
                    }
                    w[i * N + j - true] = w[i * N + j - true].div((NumericValue)w[i * N + j - true].norm2());
                } while (j != n5);
            }
            ++i;
        }
        this.hyperplanes = w;
    }
}

