/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lucene;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.database.column.ColumnType;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.events.DataChangeEvent;
import org.vitrivr.cottontail.database.index.Index;
import org.vitrivr.cottontail.database.index.IndexTransaction;
import org.vitrivr.cottontail.database.index.IndexType;
import org.vitrivr.cottontail.database.index.lucene.LuceneIndex$Tx$WhenMappings;
import org.vitrivr.cottontail.database.index.lucene.LucenePredicateConversionKt;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.ComparisonOperator;
import org.vitrivr.cottontail.database.queries.components.CompoundBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.Predicate;
import org.vitrivr.cottontail.database.queries.planning.cost.Cost;
import org.vitrivr.cottontail.model.basics.CloseableIterator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Name;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.recordset.StandaloneRecord;
import org.vitrivr.cottontail.model.values.FloatValue;
import org.vitrivr.cottontail.model.values.StringValue;
import org.vitrivr.cottontail.model.values.types.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u000212B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010'\u001a\u00020(2\n\u0010\u0004\u001a\u00060)R\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,H\u0016R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b \u0010\u0010R\u0014\u0010!\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000eR\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;", "Lorg/vitrivr/cottontail/database/index/Index;", "name", "Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "(Lorg/vitrivr/cottontail/model/basics/Name$IndexName;Lorg/vitrivr/cottontail/database/entity/Entity;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;)V", "<set-?>", "", "closed", "getClosed", "()Z", "getColumns", "()[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "[Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "directory", "Lorg/apache/lucene/store/Directory;", "indexReader", "Lorg/apache/lucene/index/DirectoryReader;", "kotlin.jvm.PlatformType", "getName", "()Lorg/vitrivr/cottontail/model/basics/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/database/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "produces", "getProduces", "supportsIncrementalUpdate", "getSupportsIncrementalUpdate", "type", "Lorg/vitrivr/cottontail/database/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/database/index/IndexType;", "begin", "Lorg/vitrivr/cottontail/database/index/IndexTransaction;", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "close", "", "cost", "Lorg/vitrivr/cottontail/database/queries/planning/cost/Cost;", "Companion", "Tx", "cottontaildb"})
public final class LuceneIndex
extends Index {
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final Path path;
    private final boolean supportsIncrementalUpdate;
    @NotNull
    private final IndexType type;
    private volatile boolean closed;
    private final Directory directory;
    private DirectoryReader indexReader;
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    public static final String TID_COLUMN = "_tid";
    private static final Logger LOGGER;
    public static final Companion Companion;

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        boolean bl;
        Object it;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof BooleanPredicate)) return false;
        Iterable $this$all$iv = predicate.getColumns();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                it = (ColumnDef)element$iv;
                boolean bl3 = false;
                if (ArraysKt.contains((Object[])this.getColumns(), (Object)it)) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
        $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            it = (AtomicBooleanPredicate)element$iv;
            boolean bl4 = false;
            if (((AtomicBooleanPredicate)it).getOperator() != ComparisonOperator.LIKE) {
                if (((AtomicBooleanPredicate)it).getOperator() != ComparisonOperator.EQUAL) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Cost cost(@NotNull Predicate predicate) {
        Cost cost;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (this.canProcess(predicate)) {
            void var3_3;
            IndexSearcher searcher = new IndexSearcher((IndexReader)this.indexReader);
            Cost cost2 = Cost.Companion.getZERO();
            Iterable $this$forEach$iv = predicate.getColumns();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ColumnDef it = (ColumnDef)element$iv;
                boolean bl = false;
                cost2 = cost2.plus(new Cost(1.0E-4f, 1.0E-4f, it.getPhysicalSize()).times(searcher.collectionStatistics(it.getName().getSimple()).sumTotalTermFreq()));
            }
            cost = var3_3;
        } else {
            cost = Cost.Companion.getINVALID();
        }
        return cost;
    }

    @Override
    @NotNull
    public IndexTransaction begin(@NotNull Entity.Tx parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new Tx(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.getGlobalLock();
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-LuceneIndex$close$22 = false;
            if (!this.getClosed()) {
                this.indexReader.close();
                this.directory.close();
                this.closed = true;
            }
            Unit $i$a$-write-LuceneIndex$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    public LuceneIndex(@NotNull Name.IndexName name, @NotNull Entity parent, @NotNull ColumnDef<?>[] columns) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.name = name;
        this.parent = parent;
        this.columns = columns;
        this.produces = new ColumnDef[]{new ColumnDef(this.getParent().getName().column("score"), ColumnType.Companion.forName("FLOAT"), 0, false, 12, null)};
        Path path = this.getParent().getPath().resolve("idx_lucene_" + this.getName().getSimple());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.parent.path.resolve\u2026x_lucene_${name.simple}\")");
        this.path = path;
        this.supportsIncrementalUpdate = true;
        this.type = IndexType.LUCENE;
        FSDirectory fSDirectory = FSDirectory.open((Path)this.getPath(), (LockFactory)((LockFactory)NativeFSLockFactory.getDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)fSDirectory, (String)"FSDirectory.open(this.pa\u2026LockFactory.getDefault())");
        this.directory = (Directory)fSDirectory;
        IndexWriter writer = new IndexWriter(this.directory, new IndexWriterConfig((Analyzer)new StandardAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND).setCommitOnClose(true));
        writer.close();
        this.indexReader = DirectoryReader.open((Directory)this.directory);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerFactory.getLogger(LuceneIndex.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0011\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0014J\b\u0010\u0011\u001a\u00020\nH\u0014J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0016\u0010\u0013\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Tx;", "Lorg/vitrivr/cottontail/database/index/Index$Tx;", "Lorg/vitrivr/cottontail/database/index/Index;", "parent", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "(Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex;Lorg/vitrivr/cottontail/database/entity/Entity$Tx;)V", "writer", "Lorg/apache/lucene/index/IndexWriter;", "cleanup", "", "filter", "Lorg/vitrivr/cottontail/model/basics/CloseableIterator;", "Lorg/vitrivr/cottontail/model/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/database/queries/components/Predicate;", "performCommit", "performRollback", "rebuild", "update", "", "Lorg/vitrivr/cottontail/database/events/DataChangeEvent;", "cottontaildb"})
    private final class Tx
    extends Index.Tx {
        private final IndexWriter writer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-LuceneIndex$Tx$rebuild$22 = false;
                this.checkValidForWrite();
                LOGGER.trace("Rebuilding lucene index {}", (Object)LuceneIndex.this.getName());
                IndexWriter indexWriter = this.writer;
                if (indexWriter != null) {
                    indexWriter.deleteAll();
                }
                int count = 0;
                AutoCloseable autoCloseable = this.getParent().scan(LuceneIndex.this.getColumns());
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    CloseableIterator s = (CloseableIterator)autoCloseable;
                    boolean bl3 = false;
                    Iterator $this$forEach$iv = s;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv;
                    boolean bl4 = false;
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object element$iv = iterator3.next();
                        Record record = (Record)element$iv;
                        boolean bl5 = false;
                        IndexWriter indexWriter2 = this.writer;
                        if (indexWriter2 != null) {
                            indexWriter2.addDocument((Iterable)Companion.documentFromRecord(record));
                        }
                        int n = count;
                        count = n + 1;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                LOGGER.trace("Rebuilding lucene index complete!", (Object)LuceneIndex.this.getName());
                Unit $i$a$-read-LuceneIndex$Tx$rebuild$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Collection<DataChangeEvent> update) {
            Intrinsics.checkNotNullParameter(update, (String)"update");
            StampedLock $this$read$iv = this.getLocalLock();
            boolean $i$f$read = false;
            long stamp$iv = $this$read$iv.readLock();
            try {
                boolean $i$a$-read-LuceneIndex$Tx$update$22 = false;
                this.checkValidForWrite();
                Function1<DataChangeEvent, Unit> $fun$atomicInsert$1 = new Function1<DataChangeEvent, Unit>(this, update){
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    public final void invoke(@NotNull DataChangeEvent event) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            IndexWriter indexWriter = Tx.access$getWriter$p(this.this$0);
                            if (indexWriter == null) break block0;
                            Record record = event.getNew();
                            Intrinsics.checkNotNull((Object)record);
                            indexWriter.addDocument((Iterable)org.vitrivr.cottontail.database.index.lucene.LuceneIndex$Companion.access$documentFromRecord(LuceneIndex.Companion, record));
                        }
                    }
                };
                Function1<DataChangeEvent, Unit> $fun$atomicDelete$2 = new Function1<DataChangeEvent, Unit>(this, update){
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Collection $update$inlined;
                    {
                        this.this$0 = tx;
                        this.$update$inlined = collection;
                        super(1);
                    }

                    public final void invoke(@NotNull DataChangeEvent event) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            IndexWriter indexWriter = Tx.access$getWriter$p(this.this$0);
                            if (indexWriter == null) break block0;
                            Query[] queryArray = new Query[1];
                            Record record = event.getOld();
                            Intrinsics.checkNotNull((Object)record);
                            queryArray[0] = NumericDocValuesField.newSlowExactQuery((String)"_tid", (long)record.getTupleId());
                            indexWriter.deleteDocuments(queryArray);
                        }
                    }
                };
                for (DataChangeEvent event : update) {
                    switch (LuceneIndex$Tx$WhenMappings.$EnumSwitchMapping$0[event.getType().ordinal()]) {
                        case 1: {
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 2: {
                            Record record = event.getNew();
                            Record record2 = event.getOld();
                            if (!(Intrinsics.areEqual(record != null ? record.get(this.getColumns()[0]) : null, record2 != null ? record2.get(this.getColumns()[0]) : null) ^ true)) break;
                            $fun$atomicDelete$2.invoke(event);
                            $fun$atomicInsert$1.invoke(event);
                            break;
                        }
                        case 3: {
                            $fun$atomicDelete$2.invoke(event);
                            break;
                        }
                    }
                }
                DirectoryReader oldReader = LuceneIndex.this.indexReader;
                LuceneIndex.this.indexReader = DirectoryReader.open((Directory)LuceneIndex.this.directory);
                oldReader.close();
                Unit $i$a$-read-LuceneIndex$Tx$update$22 = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                throw e$iv;
            }
            finally {
                $this$read$iv.unlock(stamp$iv);
            }
        }

        @Override
        @NotNull
        public CloseableIterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new CloseableIterator<Record>(this, predicate){
                private final BooleanPredicate predicate;
                private final long stamp;
                private volatile int returned;
                private volatile boolean closed;
                private final Query query;
                private final IndexSearcher searcher;
                private final TopDocs results;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ Predicate $predicate;

                public boolean hasNext() {
                    boolean bl = !this.closed;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    return (long)this.returned < this.results.totalHits;
                }

                @NotNull
                public Record next() {
                    boolean bl = !this.closed;
                    int n = 0;
                    boolean bl2 = false;
                    if (!bl) {
                        boolean bl3 = false;
                        String string = "Illegal invocation of next(): This CloseableIterator has been closed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    n = this.returned;
                    this.returned = n + 1;
                    ScoreDoc scores = this.results.scoreDocs[n];
                    Document doc = this.searcher.doc(scores.doc);
                    String string = doc.get("_tid");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc[TID_COLUMN]");
                    String string2 = string;
                    boolean bl4 = false;
                    return new StandaloneRecord(Long.parseLong(string2), this.this$0.LuceneIndex.this.getProduces(), new Value[]{FloatValue.box-impl(FloatValue.constructor-impl(scores.score))});
                }

                public void close() {
                    if (!this.closed) {
                        Tx.access$getLocalLock$p(this.this$0).unlock(this.stamp);
                        this.closed = true;
                    }
                }
                {
                    Query query;
                    boolean bl;
                    block14: {
                        Object it;
                        boolean bl2;
                        boolean $i$f$all;
                        Iterable $this$all$iv;
                        block13: {
                            this.this$0 = this$0;
                            this.$predicate = $captured_local_variable$1;
                            if (!($captured_local_variable$1 instanceof BooleanPredicate)) {
                                throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.LuceneIndex.this.getName() + "' (lucene index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($captured_local_variable$1.getClass()).getSimpleName() + "'.");
                            }
                            this.predicate = (BooleanPredicate)$captured_local_variable$1;
                            Tx.access$checkValidForRead(this$0);
                            $this$all$iv = this.predicate.getColumns();
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    it = (ColumnDef)element$iv;
                                    boolean bl3 = false;
                                    if (ArraysKt.contains((Object[])this.this$0.LuceneIndex.this.getColumns(), (Object)it)) continue;
                                    bl2 = false;
                                    break block13;
                                }
                                bl2 = true;
                            }
                        }
                        if (!bl2) {
                            throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.LuceneIndex.this.getName() + "' (lucene-index) is lacking certain fields the provided predicate requires.");
                        }
                        $this$all$iv = this.predicate.getAtomics();
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                it = (AtomicBooleanPredicate)element$iv;
                                boolean bl4 = false;
                                if (((AtomicBooleanPredicate)it).getOperator() == ComparisonOperator.LIKE || ((AtomicBooleanPredicate)it).getOperator() == ComparisonOperator.EQUAL) continue;
                                bl = false;
                                break block14;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) {
                        throw (Throwable)new QueryException.UnsupportedPredicateException("Index '" + this$0.LuceneIndex.this.getName() + "' (lucene-index) can only process LIKE comparisons.");
                    }
                    this.stamp = Tx.access$getLocalLock$p(this$0).readLock();
                    BooleanPredicate booleanPredicate = this.predicate;
                    if (booleanPredicate instanceof AtomicBooleanPredicate) {
                        query = LucenePredicateConversionKt.toLuceneQuery((AtomicBooleanPredicate)this.predicate);
                    } else if (booleanPredicate instanceof CompoundBooleanPredicate) {
                        query = LucenePredicateConversionKt.toLuceneQuery((CompoundBooleanPredicate)this.predicate);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    this.query = query;
                    this.searcher = new IndexSearcher((IndexReader)LuceneIndex.access$getIndexReader$p(this$0.LuceneIndex.this));
                    this.results = this.searcher.search(this.query, Integer.MAX_VALUE);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        protected void performCommit() {
            IndexWriter indexWriter = this.writer;
            if (indexWriter != null) {
                indexWriter.commit();
            }
            DirectoryReader oldReader = LuceneIndex.this.indexReader;
            LuceneIndex.this.indexReader = DirectoryReader.open((Directory)LuceneIndex.this.directory);
            oldReader.close();
        }

        @Override
        protected void performRollback() {
            block0: {
                IndexWriter indexWriter = this.writer;
                if (indexWriter == null) break block0;
                indexWriter.rollback();
            }
        }

        @Override
        protected void cleanup() {
            block0: {
                IndexWriter indexWriter = this.writer;
                if (indexWriter == null) break block0;
                indexWriter.close();
            }
        }

        public Tx(Entity.Tx parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(parent);
            this.writer = !this.getReadonly() ? new IndexWriter(LuceneIndex.this.directory, new IndexWriterConfig((Analyzer)new StandardAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.APPEND).setMaxBufferedDocs(100000).setCommitOnClose(false)) : null;
        }

        public static final /* synthetic */ IndexWriter access$getWriter$p(Tx $this) {
            return $this.writer;
        }

        public static final /* synthetic */ StampedLock access$getLocalLock$p(Tx $this) {
            return $this.getLocalLock();
        }

        public static final /* synthetic */ void access$checkValidForRead(Tx $this) {
            $this.checkValidForRead();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/vitrivr/cottontail/database/index/lucene/LuceneIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TID_COLUMN", "", "documentFromRecord", "Lorg/apache/lucene/document/Document;", "record", "Lorg/vitrivr/cottontail/model/basics/Record;", "cottontaildb"})
    public static final class Companion {
        private final Document documentFromRecord(Record record) {
            Document document = new Document();
            boolean bl = false;
            boolean bl2 = false;
            Document $this$apply = document;
            boolean bl3 = false;
            $this$apply.add((IndexableField)new NumericDocValuesField(LuceneIndex.TID_COLUMN, record.getTupleId()));
            $this$apply.add((IndexableField)new StoredField(LuceneIndex.TID_COLUMN, record.getTupleId()));
            ColumnDef<?>[] $this$forEach$iv = record.getColumns();
            boolean $i$f$forEach = false;
            ColumnDef<?>[] columnDefArray = $this$forEach$iv;
            int n = columnDefArray.length;
            for (int i = 0; i < n; ++i) {
                ColumnDef<?> element$iv;
                ColumnDef<?> it = element$iv = columnDefArray[i];
                boolean bl4 = false;
                Object value = record.get(it);
                if (!(value instanceof StringValue)) continue;
                $this$apply.add((IndexableField)new TextField(it.getName() + "_txt", ((StringValue)value).unbox-impl(), Field.Store.NO));
                $this$apply.add((IndexableField)new StringField(it.getName() + "_str", ((StringValue)value).unbox-impl(), Field.Store.NO));
            }
            return document;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

