/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.lucene;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.index.lucene.LucenePredicateConversionKt$WhenMappings;
import org.vitrivr.cottontail.database.queries.components.AtomicBooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.BooleanPredicate;
import org.vitrivr.cottontail.database.queries.components.CompoundBooleanPredicate;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.exceptions.QueryException;
import org.vitrivr.cottontail.model.values.PatternValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0004"}, d2={"toLuceneQuery", "Lorg/apache/lucene/search/Query;", "Lorg/vitrivr/cottontail/database/queries/components/AtomicBooleanPredicate;", "Lorg/vitrivr/cottontail/database/queries/components/CompoundBooleanPredicate;", "cottontaildb"})
public final class LucenePredicateConversionKt {
    @NotNull
    public static final Query toLuceneQuery(@NotNull AtomicBooleanPredicate<?> $this$toLuceneQuery) {
        Query query;
        Intrinsics.checkNotNullParameter($this$toLuceneQuery, (String)"$this$toLuceneQuery");
        if (CollectionsKt.first((Iterable)$this$toLuceneQuery.getValues()) instanceof PatternValue) {
            ColumnDef column = (ColumnDef)CollectionsKt.first((Iterable)$this$toLuceneQuery.getColumns());
            Object object = CollectionsKt.first((Iterable)$this$toLuceneQuery.getValues());
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.PatternValue");
            }
            String value = ((PatternValue)object).getLucene();
            switch (LucenePredicateConversionKt$WhenMappings.$EnumSwitchMapping$0[$this$toLuceneQuery.getOperator().ordinal()]) {
                case 1: {
                    query = QueryParserUtil.parse((String[])new String[]{value}, (String[])new String[]{column.getName() + "_txt"}, (Analyzer)((Analyzer)new StandardAnalyzer()));
                    break;
                }
                case 2: {
                    query = (Query)new TermQuery(new Term(column.getName() + "_str", value));
                    break;
                }
                default: {
                    throw (Throwable)new QueryException("Only EQUALS and LIKE queries can be mapped to Apache Lucene!");
                }
            }
        } else {
            throw (Throwable)new QueryException("Only PatternValues can be handled by Apache Lucene!");
        }
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"when (this.operator) {\n \u2026to Apache Lucene!\")\n    }");
        return query;
    }

    @NotNull
    public static final Query toLuceneQuery(@NotNull CompoundBooleanPredicate $this$toLuceneQuery) {
        Query query;
        Query query2;
        BooleanClause.Occur occur;
        Intrinsics.checkNotNullParameter((Object)$this$toLuceneQuery, (String)"$this$toLuceneQuery");
        switch (LucenePredicateConversionKt$WhenMappings.$EnumSwitchMapping$1[$this$toLuceneQuery.getConnector().ordinal()]) {
            case 1: {
                occur = BooleanClause.Occur.MUST;
                break;
            }
            case 2: {
                occur = BooleanClause.Occur.SHOULD;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        BooleanClause.Occur clause = occur;
        BooleanPredicate booleanPredicate = $this$toLuceneQuery.getP1();
        if (booleanPredicate instanceof AtomicBooleanPredicate) {
            query2 = LucenePredicateConversionKt.toLuceneQuery((AtomicBooleanPredicate)$this$toLuceneQuery.getP1());
        } else if (booleanPredicate instanceof CompoundBooleanPredicate) {
            query2 = LucenePredicateConversionKt.toLuceneQuery((CompoundBooleanPredicate)$this$toLuceneQuery.getP1());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Query left = query2;
        BooleanPredicate booleanPredicate2 = $this$toLuceneQuery.getP2();
        if (booleanPredicate2 instanceof AtomicBooleanPredicate) {
            query = LucenePredicateConversionKt.toLuceneQuery((AtomicBooleanPredicate)$this$toLuceneQuery.getP2());
        } else if (booleanPredicate2 instanceof CompoundBooleanPredicate) {
            query = LucenePredicateConversionKt.toLuceneQuery((CompoundBooleanPredicate)$this$toLuceneQuery.getP2());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Query right = query;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(left, clause);
        builder.add(right, clause);
        BooleanQuery booleanQuery = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"builder.build()");
        return (Query)booleanQuery;
    }
}

