/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.database.index.vaplus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SplittableRandom;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.database.entity.Entity;
import org.vitrivr.cottontail.database.index.vaplus.MarksGenerator;
import org.vitrivr.cottontail.model.basics.ColumnDef;
import org.vitrivr.cottontail.model.basics.Record;
import org.vitrivr.cottontail.model.values.types.VectorValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ9\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u000b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0012J!\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u0014J7\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\n2\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J!\u0010\u001f\u001a\u00020\u00072\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010!\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\"J'\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010$\u001a\u00020\u0007\u00a2\u0006\u0002\u0010%J'\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0\n\u00a2\u0006\u0002\u0010+J+\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020-0\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/database/index/vaplus/VAPlus;", "Ljava/io/Serializable;", "()V", "totalNumberOfBits", "", "compressBounds", "Lkotlin/Pair;", "", "", "bounds", "", "", "([[D)Lkotlin/Pair;", "computeBounds", "vector", "marks", "([D[[D)Lkotlin/Pair;", "convertToDoubleArray", "Lorg/vitrivr/cottontail/model/values/types/VectorValue;", "getCells", "([D[[D)[I", "getDataSample", "tx", "Lorg/vitrivr/cottontail/database/entity/Entity$Tx;", "Lorg/vitrivr/cottontail/database/entity/Entity;", "columns", "Lorg/vitrivr/cottontail/model/basics/ColumnDef;", "size", "(Lorg/vitrivr/cottontail/database/entity/Entity$Tx;[Lorg/vitrivr/cottontail/model/basics/ColumnDef;I)[[D", "getMaxIndex", "array", "nonUniformBitAllocation", "dataSample", "dimension", "([[DI)[I", "nonUniformQuantization", "b", "([[D[I)[[D", "scan", "", "query", "", "", "([F[Ljava/util/List;)V", "transformToKLTDomain", "Lorg/apache/commons/math3/linear/RealMatrix;", "cottontaildb"})
public final class VAPlus
implements Serializable {
    private final int totalNumberOfBits;

    @NotNull
    public final double[][] getDataSample(@NotNull Entity.Tx tx, @NotNull ColumnDef<?>[] columns, int size) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        double p = (double)size / (double)tx.count();
        ArrayList<double[]> dataSample = new ArrayList<double[]>(size + 100);
        SplittableRandom random2 = new SplittableRandom(System.currentTimeMillis());
        Iterator $this$forEach$iv = tx.scan(columns);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            Record record = (Record)element$iv;
            boolean bl2 = false;
            if (!(random2.nextDouble() >= 1.0 - p)) continue;
            Object obj = record.get(columns[0]);
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.model.values.types.VectorValue<*>");
            }
            dataSample.add(this.convertToDoubleArray((VectorValue)obj));
        }
        Collection $this$toTypedArray$iv = dataSample;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new double[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (double[][])TArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<double[][], RealMatrix> transformToKLTDomain(@NotNull double[][] dataSample) {
        Intrinsics.checkNotNullParameter((Object)dataSample, (String)"dataSample");
        RealMatrix cBar = new Covariance(MatrixUtils.createRealMatrix((double[][])dataSample)).getCovarianceMatrix();
        EigenDecomposition eigenDecomposition = new EigenDecomposition(cBar);
        RealMatrix k = MatrixUtils.createRealMatrix((int)40, (int)40);
        int n = 0;
        RealMatrix realMatrix = cBar;
        Intrinsics.checkNotNullExpressionValue((Object)realMatrix, (String)"cBar");
        int n2 = realMatrix.getColumnDimension();
        while (n < n2) {
            void column;
            RealVector eigenVector = eigenDecomposition.getEigenvector((int)column);
            int n3 = 0;
            int n4 = cBar.getRowDimension();
            while (n3 < n4) {
                void row;
                k.setEntry((int)row, (int)column, eigenVector.getEntry((int)row));
                ++row;
            }
            ++column;
        }
        RealMatrix kBar = k.transpose();
        Object[] $this$forEachIndexed$iv = (Object[])dataSample;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n5 = index$iv++;
            double[] dArray = (double[])item$iv;
            int index = n5;
            boolean bl = false;
            RealMatrix dataMatrix = MatrixUtils.createRealMatrix((double[][])new double[][]{element});
            Intrinsics.checkNotNullExpressionValue((Object)kBar.multiply(dataMatrix.transpose()).getColumnVector(0).toArray(), (String)"kBar.multiply(dataMatrix\u2026ColumnVector(0).toArray()");
        }
        return new Pair((Object)dataSample, (Object)kBar);
    }

    @NotNull
    public final int[] nonUniformBitAllocation(@NotNull double[][] dataSample, int dimension) {
        int index;
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)dataSample, (String)"dataSample");
        double[] mean = new double[dimension];
        double[] variance = new double[dimension];
        int n2 = 0;
        int n3 = dimension;
        while (n2 < n3) {
            int n4 = 0;
            n = dataSample.length;
            while (n4 < n) {
                int n5 = i;
                mean[n5] = mean[n5] + dataSample[index][i];
                ++index;
            }
            mean[i] = mean[i] / (double)((Object[])dataSample).length;
            ++i;
        }
        n3 = dimension;
        for (i = 0; i < n3; ++i) {
            n = dataSample.length;
            for (index = 0; index < n; ++index) {
                int n6 = i;
                double d = dataSample[index][i] - mean[i];
                int n7 = 2;
                boolean bl = false;
                variance[n6] = variance[n6] + Math.pow(d, n7);
            }
            variance[i] = mean[i] / (double)((Object[])dataSample).length;
        }
        int b0 = this.totalNumberOfBits;
        int k = 0;
        int[] nArray = new int[dimension];
        int n8 = 0;
        while (n8 < dimension) {
            int n9;
            int n10 = n8;
            int n11 = n8++;
            int[] nArray2 = nArray;
            boolean bl = false;
            nArray2[n11] = n9 = 0;
        }
        int[] b = nArray;
        while (k < b0) {
            int j;
            int n12 = j = this.getMaxIndex(variance);
            b[n12] = b[n12] + 1;
            variance[j] = variance[j] / (double)4;
            ++k;
        }
        return b;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final double[][] nonUniformQuantization(@NotNull double[][] dataSample, @NotNull int[] b) {
        Intrinsics.checkNotNullParameter((Object)dataSample, (String)"dataSample");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int n = b.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            void it;
            int n4 = n2;
            int n5 = n2++;
            int[] nArray2 = nArray;
            boolean bl = false;
            int n6 = 1;
            int n7 = 2 << b[it] - 1;
            boolean bl2 = false;
            n6 = Math.max(n6, n7);
            n7 = Short.MAX_VALUE;
            bl2 = false;
            nArray2[n5] = n3 = Math.min(n6, n7);
        }
        int[] numberOfMarks = nArray;
        return MarksGenerator.INSTANCE.getNonUniformMarks(dataSample, numberOfMarks);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final int[] getCells(@NotNull double[] vector, @NotNull double[][] marks) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)marks, (String)"marks");
        int n = vector.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int index;
            void it;
            block3: {
                int n3;
                int n4 = i;
                int n5 = i;
                int[] nArray2 = nArray;
                boolean bl = false;
                double[] $this$indexOfFirst$iv = marks[it];
                boolean $i$f$indexOfFirst = false;
                int n6 = 0;
                int n7 = $this$indexOfFirst$iv.length;
                while (n6 < n7) {
                    void index$iv;
                    double i2 = $this$indexOfFirst$iv[index$iv];
                    boolean bl2 = false;
                    if (i2 >= vector[it]) {
                        n3 = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n3 = index = -1;
            }
            nArray2[n5] = n2 = index == -1 ? marks[it].length - 2 : index - 1;
        }
        return nArray;
    }

    @NotNull
    public final double[] convertToDoubleArray(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final int getMaxIndex(double[] array) {
        double maxValue = Double.MIN_VALUE;
        int maxIndex = -1;
        int n = 0;
        int n2 = array.length;
        while (n < n2) {
            void index;
            double element = array[index];
            if (element > maxValue) {
                maxValue = element;
                maxIndex = index;
            }
            ++index;
        }
        return maxIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<double[][], double[][]> computeBounds(@NotNull double[] vector, @NotNull double[][] marks) {
        double[] dArray;
        int n;
        int n2;
        int it;
        int n3;
        double[][] dArrayArray;
        int n4;
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)marks, (String)"marks");
        int n5 = ((Object[])marks).length;
        double[][] dArrayArray2 = new double[n5][];
        int n6 = 0;
        while (n6 < n5) {
            int n7 = n6;
            n4 = n6++;
            dArrayArray = dArrayArray2;
            n3 = 0;
            int n8 = 0;
            n2 = marks[it].length - 1;
            n = 0;
            dArray = new double[Math.max(n8, n2)];
            dArrayArray[n4] = dArray;
        }
        double[][] lbounds = dArrayArray2;
        int n9 = ((Object[])marks).length;
        double[][] dArrayArray3 = new double[n9][];
        it = 0;
        while (it < n9) {
            void it2;
            n3 = it;
            n4 = it++;
            dArrayArray = dArrayArray3;
            boolean bl = false;
            n2 = 0;
            n = marks[it2].length - 1;
            boolean bl2 = false;
            dArray = new double[Math.max(n2, n)];
            dArrayArray[n4] = dArray;
        }
        double[][] ubounds = dArrayArray3;
        n9 = 0;
        int n10 = marks.length;
        while (n9 < n10) {
            void i;
            double[] dimMarks = marks[i];
            double fvi = vector[i];
            Sequence $this$forEachIndexed$iv = SequencesKt.windowed$default((Sequence)ArraysKt.asSequence((double[])dimMarks), (int)2, (int)0, (boolean)false, (int)2, null);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it3;
                int n11 = index$iv++;
                boolean bl = false;
                if (n11 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int j = n11;
                boolean bl3 = false;
                boolean weights = true;
                double d = ((Number)it3.get(0)).doubleValue() - fvi;
                int n12 = 0;
                d = Math.abs(d);
                n12 = 2;
                boolean bl4 = false;
                double d0fv1 = (double)weights * Math.pow(d, n12);
                double d2 = ((Number)it3.get(1)).doubleValue() - fvi;
                int n13 = 0;
                d2 = Math.abs(d2);
                n13 = 2;
                boolean bl5 = false;
                double d1fv1 = (double)weights * Math.pow(d2, n13);
                if (fvi < ((Number)it3.get(0)).doubleValue()) {
                    lbounds[i][j] = d0fv1;
                } else if (fvi > ((Number)it3.get(1)).doubleValue()) {
                    lbounds[i][j] = d1fv1;
                }
                if (fvi <= (((Number)it3.get(0)).doubleValue() + ((Number)it3.get(1)).doubleValue()) / (double)2) {
                    ubounds[i][j] = d1fv1;
                    continue;
                }
                ubounds[i][j] = d0fv1;
            }
            ++i;
        }
        return new Pair((Object)lbounds, (Object)ubounds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<int[], float[]> compressBounds(@NotNull double[][] bounds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Object[] $this$map$iv = (Object[])bounds;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double[] dArray = (double[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ((void)it).length;
            collection.add(n);
        }
        List lengths = (List)destination$iv$iv;
        int totalLength = CollectionsKt.sumOfInt((Iterable)lengths);
        Function0 cumLengths2 = (Function0)new Function0<int[]>(lengths){
            final /* synthetic */ List $lengths;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final int[] invoke() {
                void var1_1;
                int[] cumLengthsTmp = new int[this.$lengths.size()];
                int cumSum = 0;
                for (int i = 0; i < this.$lengths.size() - 1; ++i) {
                    cumLengthsTmp[i + 1] = cumSum += ((Number)this.$lengths.get(i)).intValue();
                }
                return var1_1;
            }
            {
                this.$lengths = list;
                super(0);
            }
        };
        Function0 newBounds2 = (Function0)new Function0<float[]>(totalLength, lengths, cumLengths2, bounds){
            final /* synthetic */ int $totalLength;
            final /* synthetic */ List $lengths;
            final /* synthetic */ Function0 $cumLengths;
            final /* synthetic */ double[][] $bounds;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final float[] invoke() {
                void var1_1;
                float[] newBoundsTmp = new float[this.$totalLength];
                int j = 0;
                for (int i = 0; i < this.$lengths.size(); ++i) {
                    for (j = 0; j < ((Number)this.$lengths.get(i)).intValue(); ++j) {
                        newBoundsTmp[((int[])this.$cumLengths.invoke())[i] + j] = (float)this.$bounds[i][j];
                    }
                }
                return var1_1;
            }
            {
                this.$totalLength = n;
                this.$lengths = list;
                this.$cumLengths = function0;
                this.$bounds = dArray;
                super(0);
            }
        };
        return new Pair(cumLengths2.invoke(), newBounds2.invoke());
    }

    public final void scan(@NotNull float[] query, @NotNull List<Double>[] marks) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(marks, (String)"marks");
    }

    public VAPlus() {
        this.totalNumberOfBits = 32;
    }
}

